package org.cloudfoundry.client.v2.servicekeys;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Immutable implementation of {@link _CreateServiceKeyRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code CreateServiceKeyRequest.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_CreateServiceKeyRequest"})
public final class CreateServiceKeyRequest
    extends org.cloudfoundry.client.v2.servicekeys._CreateServiceKeyRequest {
  private final String name;
  private final @Nullable Map<String, Object> parameters;
  private final String serviceInstanceId;

  private CreateServiceKeyRequest(CreateServiceKeyRequest.Builder builder) {
    this.name = builder.name;
    this.parameters = builder.parameters == null ? null : createUnmodifiableMap(false, false, builder.parameters);
    this.serviceInstanceId = builder.serviceInstanceId;
  }

  /**
   * The name
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * Key/value pairs of all arbitrary parameters to pass along to the service broker
   */
  @Override
  public @Nullable Map<String, Object> getParameters() {
    return parameters;
  }

  /**
   * The service instance id
   */
  @Override
  public String getServiceInstanceId() {
    return serviceInstanceId;
  }

  /**
   * This instance is equal to all instances of {@code CreateServiceKeyRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateServiceKeyRequest
        && equalTo((CreateServiceKeyRequest) another);
  }

  private boolean equalTo(CreateServiceKeyRequest another) {
    return name.equals(another.name)
        && Objects.equals(parameters, another.parameters)
        && serviceInstanceId.equals(another.serviceInstanceId);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code parameters}, {@code serviceInstanceId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + name.hashCode();
    h = h * 17 + Objects.hashCode(parameters);
    h = h * 17 + serviceInstanceId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CreateServiceKeyRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateServiceKeyRequest{"
        + "name=" + name
        + ", parameters=" + parameters
        + ", serviceInstanceId=" + serviceInstanceId
        + "}";
  }

  /**
   * Creates a builder for {@link CreateServiceKeyRequest CreateServiceKeyRequest}.
   * @return A new CreateServiceKeyRequest builder
   */
  public static CreateServiceKeyRequest.Builder builder() {
    return new CreateServiceKeyRequest.Builder();
  }

  /**
   * Builds instances of type {@link CreateServiceKeyRequest CreateServiceKeyRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_SERVICE_INSTANCE_ID = 0x2L;
    private long initBits = 0x3L;

    private String name;
    private Map<String, Object> parameters = null;
    private String serviceInstanceId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateServiceKeyRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateServiceKeyRequest instance) {
      return from((_CreateServiceKeyRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CreateServiceKeyRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CreateServiceKeyRequest instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.getName());
      Map<String, Object> parametersValue = instance.getParameters();
      if (parametersValue != null) {
        putAllParameters(parametersValue);
      }
      serviceInstanceId(instance.getServiceInstanceId());
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateServiceKeyRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Put one entry to the {@link _CreateServiceKeyRequest#getParameters() parameters} map.
     * @param key The key in the parameters map
     * @param value The associated value in the parameters map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder parameter(String key, Object value) {
      if (this.parameters == null) {
        this.parameters = new LinkedHashMap<String, Object>();
      }
      this.parameters.put(
          Objects.requireNonNull(key, "parameters key"),
          Objects.requireNonNull(value, "parameters value"));
      return this;
    }

    /**
     * Put one entry to the {@link _CreateServiceKeyRequest#getParameters() parameters} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder parameter(Map.Entry<String, ? extends Object> entry) {
      if (this.parameters == null) {
        this.parameters = new LinkedHashMap<String, Object>();
      }
      String k = entry.getKey();
      Object v = entry.getValue();
      this.parameters.put(
          Objects.requireNonNull(k, "parameters key"),
          Objects.requireNonNull(v, "parameters value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link _CreateServiceKeyRequest#getParameters() parameters} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param parameters The entries that will be added to the parameters map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder parameters(@Nullable Map<String, ? extends Object> parameters) {
      if (parameters == null) {
        this.parameters = null;
        return this;
      }
      this.parameters = new LinkedHashMap<String, Object>();
      return putAllParameters(parameters);
    }

    /**
     * Put all mappings from the specified map as entries to {@link _CreateServiceKeyRequest#getParameters() parameters} map. Nulls are not permitted
     * @param parameters The entries that will be added to the parameters map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllParameters(Map<String, ? extends Object> parameters) {
      if (this.parameters == null) {
        this.parameters = new LinkedHashMap<String, Object>();
      }
      for (Map.Entry<String, ? extends Object> entry : parameters.entrySet()) {
        String k = entry.getKey();
        Object v = entry.getValue();
        this.parameters.put(
            Objects.requireNonNull(k, "parameters key"),
            Objects.requireNonNull(v, "parameters value"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateServiceKeyRequest#getServiceInstanceId() serviceInstanceId} attribute.
     * @param serviceInstanceId The value for serviceInstanceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceInstanceId(String serviceInstanceId) {
      this.serviceInstanceId = Objects.requireNonNull(serviceInstanceId, "serviceInstanceId");
      initBits &= ~INIT_BIT_SERVICE_INSTANCE_ID;
      return this;
    }

    /**
     * Builds a new {@link CreateServiceKeyRequest CreateServiceKeyRequest}.
     * @return An immutable instance of CreateServiceKeyRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateServiceKeyRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CreateServiceKeyRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_SERVICE_INSTANCE_ID) != 0) attributes.add("serviceInstanceId");
      return "Cannot build CreateServiceKeyRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
