package org.cloudfoundry.client.v2.shareddomains;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link _GetSharedDomainRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code GetSharedDomainRequest.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_GetSharedDomainRequest"})
public final class GetSharedDomainRequest
    extends org.cloudfoundry.client.v2.shareddomains._GetSharedDomainRequest {
  private final String sharedDomainId;

  private GetSharedDomainRequest(GetSharedDomainRequest.Builder builder) {
    this.sharedDomainId = builder.sharedDomainId;
  }

  /**
   * The shared domain id
   */
  @Override
  public String getSharedDomainId() {
    return sharedDomainId;
  }

  /**
   * This instance is equal to all instances of {@code GetSharedDomainRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetSharedDomainRequest
        && equalTo((GetSharedDomainRequest) another);
  }

  private boolean equalTo(GetSharedDomainRequest another) {
    return sharedDomainId.equals(another.sharedDomainId);
  }

  /**
   * Computes a hash code from attributes: {@code sharedDomainId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + sharedDomainId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetSharedDomainRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetSharedDomainRequest{"
        + "sharedDomainId=" + sharedDomainId
        + "}";
  }

  /**
   * Creates a builder for {@link GetSharedDomainRequest GetSharedDomainRequest}.
   * @return A new GetSharedDomainRequest builder
   */
  public static GetSharedDomainRequest.Builder builder() {
    return new GetSharedDomainRequest.Builder();
  }

  /**
   * Builds instances of type {@link GetSharedDomainRequest GetSharedDomainRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_SHARED_DOMAIN_ID = 0x1L;
    private long initBits = 0x1L;

    private String sharedDomainId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetSharedDomainRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetSharedDomainRequest instance) {
      return from((_GetSharedDomainRequest) instance);
    }

    /**
     * Copy abstract value type {@code _GetSharedDomainRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetSharedDomainRequest instance) {
      Objects.requireNonNull(instance, "instance");
      sharedDomainId(instance.getSharedDomainId());
      return this;
    }

    /**
     * Initializes the value for the {@link _GetSharedDomainRequest#getSharedDomainId() sharedDomainId} attribute.
     * @param sharedDomainId The value for sharedDomainId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder sharedDomainId(String sharedDomainId) {
      this.sharedDomainId = Objects.requireNonNull(sharedDomainId, "sharedDomainId");
      initBits &= ~INIT_BIT_SHARED_DOMAIN_ID;
      return this;
    }

    /**
     * Builds a new {@link GetSharedDomainRequest GetSharedDomainRequest}.
     * @return An immutable instance of GetSharedDomainRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetSharedDomainRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetSharedDomainRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_SHARED_DOMAIN_ID) != 0) attributes.add("sharedDomainId");
      return "Cannot build GetSharedDomainRequest, some of required attributes are not set " + attributes;
    }
  }
}
