package org.cloudfoundry.client.v2.userprovidedserviceinstances;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Immutable implementation of {@link _CreateUserProvidedServiceInstanceRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code CreateUserProvidedServiceInstanceRequest.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_CreateUserProvidedServiceInstanceRequest"})
public final class CreateUserProvidedServiceInstanceRequest
    extends org.cloudfoundry.client.v2.userprovidedserviceinstances._CreateUserProvidedServiceInstanceRequest {
  private final @Nullable Map<String, Object> credentials;
  private final String name;
  private final @Nullable String routeServiceUrl;
  private final String spaceId;
  private final @Nullable String syslogDrainUrl;

  private CreateUserProvidedServiceInstanceRequest(CreateUserProvidedServiceInstanceRequest.Builder builder) {
    this.credentials = builder.credentials == null ? null : createUnmodifiableMap(false, false, builder.credentials);
    this.name = builder.name;
    this.routeServiceUrl = builder.routeServiceUrl;
    this.spaceId = builder.spaceId;
    this.syslogDrainUrl = builder.syslogDrainUrl;
  }

  /**
   * Key/value pairs that can be stored to store credentials
   */
  @Override
  public @Nullable Map<String, Object> getCredentials() {
    return credentials;
  }

  /**
   * The name
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * URL to which requests for bound routes will be forwarded
   */
  @Override
  public @Nullable String getRouteServiceUrl() {
    return routeServiceUrl;
  }

  /**
   * The space id
   */
  @Override
  public String getSpaceId() {
    return spaceId;
  }

  /**
   * The url for the syslog_drain to direct to
   */
  @Override
  public @Nullable String getSyslogDrainUrl() {
    return syslogDrainUrl;
  }

  /**
   * This instance is equal to all instances of {@code CreateUserProvidedServiceInstanceRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateUserProvidedServiceInstanceRequest
        && equalTo((CreateUserProvidedServiceInstanceRequest) another);
  }

  private boolean equalTo(CreateUserProvidedServiceInstanceRequest another) {
    return Objects.equals(credentials, another.credentials)
        && name.equals(another.name)
        && Objects.equals(routeServiceUrl, another.routeServiceUrl)
        && spaceId.equals(another.spaceId)
        && Objects.equals(syslogDrainUrl, another.syslogDrainUrl);
  }

  /**
   * Computes a hash code from attributes: {@code credentials}, {@code name}, {@code routeServiceUrl}, {@code spaceId}, {@code syslogDrainUrl}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(credentials);
    h = h * 17 + name.hashCode();
    h = h * 17 + Objects.hashCode(routeServiceUrl);
    h = h * 17 + spaceId.hashCode();
    h = h * 17 + Objects.hashCode(syslogDrainUrl);
    return h;
  }

  /**
   * Prints the immutable value {@code CreateUserProvidedServiceInstanceRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateUserProvidedServiceInstanceRequest{"
        + "credentials=" + credentials
        + ", name=" + name
        + ", routeServiceUrl=" + routeServiceUrl
        + ", spaceId=" + spaceId
        + ", syslogDrainUrl=" + syslogDrainUrl
        + "}";
  }

  /**
   * Creates a builder for {@link CreateUserProvidedServiceInstanceRequest CreateUserProvidedServiceInstanceRequest}.
   * @return A new CreateUserProvidedServiceInstanceRequest builder
   */
  public static CreateUserProvidedServiceInstanceRequest.Builder builder() {
    return new CreateUserProvidedServiceInstanceRequest.Builder();
  }

  /**
   * Builds instances of type {@link CreateUserProvidedServiceInstanceRequest CreateUserProvidedServiceInstanceRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_SPACE_ID = 0x2L;
    private long initBits = 0x3L;

    private Map<String, Object> credentials = null;
    private String name;
    private String routeServiceUrl;
    private String spaceId;
    private String syslogDrainUrl;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateUserProvidedServiceInstanceRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateUserProvidedServiceInstanceRequest instance) {
      return from((_CreateUserProvidedServiceInstanceRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CreateUserProvidedServiceInstanceRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CreateUserProvidedServiceInstanceRequest instance) {
      Objects.requireNonNull(instance, "instance");
      Map<String, Object> credentialsValue = instance.getCredentials();
      if (credentialsValue != null) {
        putAllCredentials(credentialsValue);
      }
      name(instance.getName());
      String routeServiceUrlValue = instance.getRouteServiceUrl();
      if (routeServiceUrlValue != null) {
        routeServiceUrl(routeServiceUrlValue);
      }
      spaceId(instance.getSpaceId());
      String syslogDrainUrlValue = instance.getSyslogDrainUrl();
      if (syslogDrainUrlValue != null) {
        syslogDrainUrl(syslogDrainUrlValue);
      }
      return this;
    }

    /**
     * Put one entry to the {@link _CreateUserProvidedServiceInstanceRequest#getCredentials() credentials} map.
     * @param key The key in the credentials map
     * @param value The associated value in the credentials map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder credential(String key, Object value) {
      if (this.credentials == null) {
        this.credentials = new LinkedHashMap<String, Object>();
      }
      this.credentials.put(
          Objects.requireNonNull(key, "credentials key"),
          Objects.requireNonNull(value, "credentials value"));
      return this;
    }

    /**
     * Put one entry to the {@link _CreateUserProvidedServiceInstanceRequest#getCredentials() credentials} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder credential(Map.Entry<String, ? extends Object> entry) {
      if (this.credentials == null) {
        this.credentials = new LinkedHashMap<String, Object>();
      }
      String k = entry.getKey();
      Object v = entry.getValue();
      this.credentials.put(
          Objects.requireNonNull(k, "credentials key"),
          Objects.requireNonNull(v, "credentials value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link _CreateUserProvidedServiceInstanceRequest#getCredentials() credentials} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param credentials The entries that will be added to the credentials map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder credentials(@Nullable Map<String, ? extends Object> credentials) {
      if (credentials == null) {
        this.credentials = null;
        return this;
      }
      this.credentials = new LinkedHashMap<String, Object>();
      return putAllCredentials(credentials);
    }

    /**
     * Put all mappings from the specified map as entries to {@link _CreateUserProvidedServiceInstanceRequest#getCredentials() credentials} map. Nulls are not permitted
     * @param credentials The entries that will be added to the credentials map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllCredentials(Map<String, ? extends Object> credentials) {
      if (this.credentials == null) {
        this.credentials = new LinkedHashMap<String, Object>();
      }
      for (Map.Entry<String, ? extends Object> entry : credentials.entrySet()) {
        String k = entry.getKey();
        Object v = entry.getValue();
        this.credentials.put(
            Objects.requireNonNull(k, "credentials key"),
            Objects.requireNonNull(v, "credentials value"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateUserProvidedServiceInstanceRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateUserProvidedServiceInstanceRequest#getRouteServiceUrl() routeServiceUrl} attribute.
     * @param routeServiceUrl The value for routeServiceUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder routeServiceUrl(@Nullable String routeServiceUrl) {
      this.routeServiceUrl = routeServiceUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateUserProvidedServiceInstanceRequest#getSpaceId() spaceId} attribute.
     * @param spaceId The value for spaceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String spaceId) {
      this.spaceId = Objects.requireNonNull(spaceId, "spaceId");
      initBits &= ~INIT_BIT_SPACE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateUserProvidedServiceInstanceRequest#getSyslogDrainUrl() syslogDrainUrl} attribute.
     * @param syslogDrainUrl The value for syslogDrainUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder syslogDrainUrl(@Nullable String syslogDrainUrl) {
      this.syslogDrainUrl = syslogDrainUrl;
      return this;
    }

    /**
     * Builds a new {@link CreateUserProvidedServiceInstanceRequest CreateUserProvidedServiceInstanceRequest}.
     * @return An immutable instance of CreateUserProvidedServiceInstanceRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateUserProvidedServiceInstanceRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CreateUserProvidedServiceInstanceRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_SPACE_ID) != 0) attributes.add("spaceId");
      return "Cannot build CreateUserProvidedServiceInstanceRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
