package org.cloudfoundry.client.v2.userprovidedserviceinstances;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;

/**
 * Immutable implementation of {@link _ListUserProvidedServiceInstanceServiceBindingsRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ListUserProvidedServiceInstanceServiceBindingsRequest.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_ListUserProvidedServiceInstanceServiceBindingsRequest"})
public final class ListUserProvidedServiceInstanceServiceBindingsRequest
    extends org.cloudfoundry.client.v2.userprovidedserviceinstances._ListUserProvidedServiceInstanceServiceBindingsRequest {
  private final @Nullable List<String> applicationIds;
  private final String userProvidedServiceInstanceId;
  private final @Nullable OrderDirection orderDirection;
  private final @Nullable Integer page;
  private final @Nullable Integer resultsPerPage;

  private ListUserProvidedServiceInstanceServiceBindingsRequest(ListUserProvidedServiceInstanceServiceBindingsRequest.Builder builder) {
    this.applicationIds = builder.applicationIds == null ? null : createUnmodifiableList(true, builder.applicationIds);
    this.userProvidedServiceInstanceId = builder.userProvidedServiceInstanceId;
    this.orderDirection = builder.orderDirection;
    this.page = builder.page;
    this.resultsPerPage = builder.resultsPerPage;
  }

  /**
   * The ids of the applications
   */
  @Override
  public @Nullable List<String> getApplicationIds() {
    return applicationIds;
  }

  /**
   * The user provided service instance id
   */
  @Override
  public String getUserProvidedServiceInstanceId() {
    return userProvidedServiceInstanceId;
  }

  /**
   * The order direction
   */
  @Override
  public @Nullable OrderDirection getOrderDirection() {
    return orderDirection;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getResultsPerPage() {
    return resultsPerPage;
  }

  /**
   * This instance is equal to all instances of {@code ListUserProvidedServiceInstanceServiceBindingsRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListUserProvidedServiceInstanceServiceBindingsRequest
        && equalTo((ListUserProvidedServiceInstanceServiceBindingsRequest) another);
  }

  private boolean equalTo(ListUserProvidedServiceInstanceServiceBindingsRequest another) {
    return Objects.equals(applicationIds, another.applicationIds)
        && userProvidedServiceInstanceId.equals(another.userProvidedServiceInstanceId)
        && Objects.equals(orderDirection, another.orderDirection)
        && Objects.equals(page, another.page)
        && Objects.equals(resultsPerPage, another.resultsPerPage);
  }

  /**
   * Computes a hash code from attributes: {@code applicationIds}, {@code userProvidedServiceInstanceId}, {@code orderDirection}, {@code page}, {@code resultsPerPage}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(applicationIds);
    h = h * 17 + userProvidedServiceInstanceId.hashCode();
    h = h * 17 + Objects.hashCode(orderDirection);
    h = h * 17 + Objects.hashCode(page);
    h = h * 17 + Objects.hashCode(resultsPerPage);
    return h;
  }

  /**
   * Prints the immutable value {@code ListUserProvidedServiceInstanceServiceBindingsRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListUserProvidedServiceInstanceServiceBindingsRequest{"
        + "applicationIds=" + applicationIds
        + ", userProvidedServiceInstanceId=" + userProvidedServiceInstanceId
        + ", orderDirection=" + orderDirection
        + ", page=" + page
        + ", resultsPerPage=" + resultsPerPage
        + "}";
  }

  /**
   * Creates a builder for {@link ListUserProvidedServiceInstanceServiceBindingsRequest ListUserProvidedServiceInstanceServiceBindingsRequest}.
   * @return A new ListUserProvidedServiceInstanceServiceBindingsRequest builder
   */
  public static ListUserProvidedServiceInstanceServiceBindingsRequest.Builder builder() {
    return new ListUserProvidedServiceInstanceServiceBindingsRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListUserProvidedServiceInstanceServiceBindingsRequest ListUserProvidedServiceInstanceServiceBindingsRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_USER_PROVIDED_SERVICE_INSTANCE_ID = 0x1L;
    private long initBits = 0x1L;

    private List<String> applicationIds = null;
    private String userProvidedServiceInstanceId;
    private OrderDirection orderDirection;
    private Integer page;
    private Integer resultsPerPage;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v2.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListUserProvidedServiceInstanceServiceBindingsRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListUserProvidedServiceInstanceServiceBindingsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListUserProvidedServiceInstanceServiceBindingsRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ListUserProvidedServiceInstanceServiceBindingsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        OrderDirection orderDirectionValue = instance.getOrderDirection();
        if (orderDirectionValue != null) {
          orderDirection(orderDirectionValue);
        }
        Integer resultsPerPageValue = instance.getResultsPerPage();
        if (resultsPerPageValue != null) {
          resultsPerPage(resultsPerPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
      if (object instanceof org.cloudfoundry.client.v2.userprovidedserviceinstances._ListUserProvidedServiceInstanceServiceBindingsRequest) {
        org.cloudfoundry.client.v2.userprovidedserviceinstances._ListUserProvidedServiceInstanceServiceBindingsRequest instance = (org.cloudfoundry.client.v2.userprovidedserviceinstances._ListUserProvidedServiceInstanceServiceBindingsRequest) object;
        userProvidedServiceInstanceId(instance.getUserProvidedServiceInstanceId());
        List<String> applicationIdsValue = instance.getApplicationIds();
        if (applicationIdsValue != null) {
          addAllApplicationIds(applicationIdsValue);
        }
      }
    }

    /**
     * Adds one element to {@link _ListUserProvidedServiceInstanceServiceBindingsRequest#getApplicationIds() applicationIds} list.
     * @param element A applicationIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(String element) {
      if (this.applicationIds == null) {
        this.applicationIds = new ArrayList<String>();
      }
      this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
      return this;
    }

    /**
     * Adds elements to {@link _ListUserProvidedServiceInstanceServiceBindingsRequest#getApplicationIds() applicationIds} list.
     * @param elements An array of applicationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(String... elements) {
      if (this.applicationIds == null) {
        this.applicationIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ListUserProvidedServiceInstanceServiceBindingsRequest#getApplicationIds() applicationIds} list.
     * @param elements An iterable of applicationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.applicationIds = null;
        return this;
      }
      this.applicationIds = new ArrayList<String>();
      return addAllApplicationIds(elements);
    }

    /**
     * Adds elements to {@link _ListUserProvidedServiceInstanceServiceBindingsRequest#getApplicationIds() applicationIds} list.
     * @param elements An iterable of applicationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllApplicationIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "applicationIds element");
      if (this.applicationIds == null) {
        this.applicationIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _ListUserProvidedServiceInstanceServiceBindingsRequest#getUserProvidedServiceInstanceId() userProvidedServiceInstanceId} attribute.
     * @param userProvidedServiceInstanceId The value for userProvidedServiceInstanceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userProvidedServiceInstanceId(String userProvidedServiceInstanceId) {
      this.userProvidedServiceInstanceId = Objects.requireNonNull(userProvidedServiceInstanceId, "userProvidedServiceInstanceId");
      initBits &= ~INIT_BIT_USER_PROVIDED_SERVICE_INSTANCE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _ListUserProvidedServiceInstanceServiceBindingsRequest#getOrderDirection() orderDirection} attribute.
     * @param orderDirection The value for orderDirection (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
      this.orderDirection = orderDirection;
      return this;
    }

    /**
     * Initializes the value for the {@link _ListUserProvidedServiceInstanceServiceBindingsRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link _ListUserProvidedServiceInstanceServiceBindingsRequest#getResultsPerPage() resultsPerPage} attribute.
     * @param resultsPerPage The value for resultsPerPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
      this.resultsPerPage = resultsPerPage;
      return this;
    }

    /**
     * Builds a new {@link ListUserProvidedServiceInstanceServiceBindingsRequest ListUserProvidedServiceInstanceServiceBindingsRequest}.
     * @return An immutable instance of ListUserProvidedServiceInstanceServiceBindingsRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListUserProvidedServiceInstanceServiceBindingsRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ListUserProvidedServiceInstanceServiceBindingsRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_USER_PROVIDED_SERVICE_INSTANCE_ID) != 0) attributes.add("userProvidedServiceInstanceId");
      return "Cannot build ListUserProvidedServiceInstanceServiceBindingsRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
