package org.cloudfoundry.client.v3;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Immutable implementation of {@link _BuildpackData}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code BuildpackData.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_BuildpackData"})
public final class BuildpackData extends org.cloudfoundry.client.v3._BuildpackData {
  private final @Nullable String buildpack;
  private final @Nullable String stack;

  private BuildpackData(BuildpackData.Builder builder) {
    this.buildpack = builder.buildpack;
    this.stack = builder.stack;
  }

  /**
   * The buildpack
   */
  @JsonProperty("buildpack")
  @Override
  public @Nullable String getBuildpack() {
    return buildpack;
  }

  /**
   * The stack
   */
  @JsonProperty("stack")
  @Override
  public @Nullable String getStack() {
    return stack;
  }

  /**
   * This instance is equal to all instances of {@code BuildpackData} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof BuildpackData
        && equalTo((BuildpackData) another);
  }

  private boolean equalTo(BuildpackData another) {
    return Objects.equals(buildpack, another.buildpack)
        && Objects.equals(stack, another.stack);
  }

  /**
   * Computes a hash code from attributes: {@code buildpack}, {@code stack}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(buildpack);
    h = h * 17 + Objects.hashCode(stack);
    return h;
  }

  /**
   * Prints the immutable value {@code BuildpackData} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "BuildpackData{"
        + "buildpack=" + buildpack
        + ", stack=" + stack
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3._BuildpackData {
    String buildpack;
    String stack;
    @JsonProperty("buildpack")
    public void setBuildpack(@Nullable String buildpack) {
      this.buildpack = buildpack;
    }
    @JsonProperty("stack")
    public void setStack(@Nullable String stack) {
      this.stack = stack;
    }
    @Override
    public String getBuildpack() { throw new UnsupportedOperationException(); }
    @Override
    public String getStack() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static BuildpackData fromJson(Json json) {
    BuildpackData.Builder builder = BuildpackData.builder();
    if (json.buildpack != null) {
      builder.buildpack(json.buildpack);
    }
    if (json.stack != null) {
      builder.stack(json.stack);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link BuildpackData BuildpackData}.
   * @return A new BuildpackData builder
   */
  public static BuildpackData.Builder builder() {
    return new BuildpackData.Builder();
  }

  /**
   * Builds instances of type {@link BuildpackData BuildpackData}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private String buildpack;
    private String stack;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code BuildpackData} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(BuildpackData instance) {
      return from((_BuildpackData) instance);
    }

    /**
     * Copy abstract value type {@code _BuildpackData} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_BuildpackData instance) {
      Objects.requireNonNull(instance, "instance");
      String buildpackValue = instance.getBuildpack();
      if (buildpackValue != null) {
        buildpack(buildpackValue);
      }
      String stackValue = instance.getStack();
      if (stackValue != null) {
        stack(stackValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _BuildpackData#getBuildpack() buildpack} attribute.
     * @param buildpack The value for buildpack (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder buildpack(@Nullable String buildpack) {
      this.buildpack = buildpack;
      return this;
    }

    /**
     * Initializes the value for the {@link _BuildpackData#getStack() stack} attribute.
     * @param stack The value for stack (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder stack(@Nullable String stack) {
      this.stack = stack;
      return this;
    }

    /**
     * Builds a new {@link BuildpackData BuildpackData}.
     * @return An immutable instance of BuildpackData
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public BuildpackData build() {
      return new BuildpackData(this);
    }
  }
}
