package org.cloudfoundry.client.v3;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Immutable implementation of {@link _Hash}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code Hash.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_Hash"})
public final class Hash extends org.cloudfoundry.client.v3._Hash {
  private final @Nullable String type;
  private final @Nullable String value;

  private Hash(Hash.Builder builder) {
    this.type = builder.type;
    this.value = builder.value;
  }

  /**
   * The type
   */
  @JsonProperty("type")
  @Override
  public @Nullable String getType() {
    return type;
  }

  /**
   * The value
   */
  @JsonProperty("value")
  @Override
  public @Nullable String getValue() {
    return value;
  }

  /**
   * This instance is equal to all instances of {@code Hash} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Hash
        && equalTo((Hash) another);
  }

  private boolean equalTo(Hash another) {
    return Objects.equals(type, another.type)
        && Objects.equals(value, another.value);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(type);
    h = h * 17 + Objects.hashCode(value);
    return h;
  }

  /**
   * Prints the immutable value {@code Hash} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Hash{"
        + "type=" + type
        + ", value=" + value
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3._Hash {
    String type;
    String value;
    @JsonProperty("type")
    public void setType(@Nullable String type) {
      this.type = type;
    }
    @JsonProperty("value")
    public void setValue(@Nullable String value) {
      this.value = value;
    }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
    @Override
    public String getValue() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static Hash fromJson(Json json) {
    Hash.Builder builder = Hash.builder();
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.value != null) {
      builder.value(json.value);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Hash Hash}.
   * @return A new Hash builder
   */
  public static Hash.Builder builder() {
    return new Hash.Builder();
  }

  /**
   * Builds instances of type {@link Hash Hash}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private String type;
    private String value;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Hash} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Hash instance) {
      return from((_Hash) instance);
    }

    /**
     * Copy abstract value type {@code _Hash} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Hash instance) {
      Objects.requireNonNull(instance, "instance");
      String typeValue = instance.getType();
      if (typeValue != null) {
        type(typeValue);
      }
      String valueValue = instance.getValue();
      if (valueValue != null) {
        value(valueValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _Hash#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(@Nullable String type) {
      this.type = type;
      return this;
    }

    /**
     * Initializes the value for the {@link _Hash#getValue() value} attribute.
     * @param value The value for value (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder value(@Nullable String value) {
      this.value = value;
      return this;
    }

    /**
     * Builds a new {@link Hash Hash}.
     * @return An immutable instance of Hash
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Hash build() {
      return new Hash(this);
    }
  }
}
