package org.cloudfoundry.client.v3.applications;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link _GetApplicationProcessStatisticsRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code GetApplicationProcessStatisticsRequest.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_GetApplicationProcessStatisticsRequest"})
public final class GetApplicationProcessStatisticsRequest
    extends org.cloudfoundry.client.v3.applications._GetApplicationProcessStatisticsRequest {
  private final String applicationId;
  private final String type;

  private GetApplicationProcessStatisticsRequest(GetApplicationProcessStatisticsRequest.Builder builder) {
    this.applicationId = builder.applicationId;
    this.type = builder.type;
  }

  /**
   * The application id
   */
  @Override
  public String getApplicationId() {
    return applicationId;
  }

  /**
   * The type of the process
   */
  @Override
  public String getType() {
    return type;
  }

  /**
   * This instance is equal to all instances of {@code GetApplicationProcessStatisticsRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetApplicationProcessStatisticsRequest
        && equalTo((GetApplicationProcessStatisticsRequest) another);
  }

  private boolean equalTo(GetApplicationProcessStatisticsRequest another) {
    return applicationId.equals(another.applicationId)
        && type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code applicationId}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + applicationId.hashCode();
    h = h * 17 + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetApplicationProcessStatisticsRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetApplicationProcessStatisticsRequest{"
        + "applicationId=" + applicationId
        + ", type=" + type
        + "}";
  }

  /**
   * Creates a builder for {@link GetApplicationProcessStatisticsRequest GetApplicationProcessStatisticsRequest}.
   * @return A new GetApplicationProcessStatisticsRequest builder
   */
  public static GetApplicationProcessStatisticsRequest.Builder builder() {
    return new GetApplicationProcessStatisticsRequest.Builder();
  }

  /**
   * Builds instances of type {@link GetApplicationProcessStatisticsRequest GetApplicationProcessStatisticsRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_APPLICATION_ID = 0x1L;
    private static final long INIT_BIT_TYPE = 0x2L;
    private long initBits = 0x3L;

    private String applicationId;
    private String type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetApplicationProcessStatisticsRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetApplicationProcessStatisticsRequest instance) {
      return from((_GetApplicationProcessStatisticsRequest) instance);
    }

    /**
     * Copy abstract value type {@code _GetApplicationProcessStatisticsRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetApplicationProcessStatisticsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      applicationId(instance.getApplicationId());
      type(instance.getType());
      return this;
    }

    /**
     * Initializes the value for the {@link _GetApplicationProcessStatisticsRequest#getApplicationId() applicationId} attribute.
     * @param applicationId The value for applicationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(String applicationId) {
      this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
      initBits &= ~INIT_BIT_APPLICATION_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _GetApplicationProcessStatisticsRequest#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(String type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link GetApplicationProcessStatisticsRequest GetApplicationProcessStatisticsRequest}.
     * @return An immutable instance of GetApplicationProcessStatisticsRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetApplicationProcessStatisticsRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetApplicationProcessStatisticsRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_APPLICATION_ID) != 0) attributes.add("applicationId");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build GetApplicationProcessStatisticsRequest, some of required attributes are not set " + attributes;
    }
  }
}
