package org.cloudfoundry.client.v3.applications;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link _StopApplicationRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code StopApplicationRequest.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_StopApplicationRequest"})
public final class StopApplicationRequest
    extends org.cloudfoundry.client.v3.applications._StopApplicationRequest {
  private final String applicationId;

  private StopApplicationRequest(StopApplicationRequest.Builder builder) {
    this.applicationId = builder.applicationId;
  }

  /**
   * The application id
   */
  @Override
  public String getApplicationId() {
    return applicationId;
  }

  /**
   * This instance is equal to all instances of {@code StopApplicationRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof StopApplicationRequest
        && equalTo((StopApplicationRequest) another);
  }

  private boolean equalTo(StopApplicationRequest another) {
    return applicationId.equals(another.applicationId);
  }

  /**
   * Computes a hash code from attributes: {@code applicationId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + applicationId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code StopApplicationRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "StopApplicationRequest{"
        + "applicationId=" + applicationId
        + "}";
  }

  /**
   * Creates a builder for {@link StopApplicationRequest StopApplicationRequest}.
   * @return A new StopApplicationRequest builder
   */
  public static StopApplicationRequest.Builder builder() {
    return new StopApplicationRequest.Builder();
  }

  /**
   * Builds instances of type {@link StopApplicationRequest StopApplicationRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_APPLICATION_ID = 0x1L;
    private long initBits = 0x1L;

    private String applicationId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code StopApplicationRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(StopApplicationRequest instance) {
      return from((_StopApplicationRequest) instance);
    }

    /**
     * Copy abstract value type {@code _StopApplicationRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_StopApplicationRequest instance) {
      Objects.requireNonNull(instance, "instance");
      applicationId(instance.getApplicationId());
      return this;
    }

    /**
     * Initializes the value for the {@link _StopApplicationRequest#getApplicationId() applicationId} attribute.
     * @param applicationId The value for applicationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(String applicationId) {
      this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
      initBits &= ~INIT_BIT_APPLICATION_ID;
      return this;
    }

    /**
     * Builds a new {@link StopApplicationRequest StopApplicationRequest}.
     * @return An immutable instance of StopApplicationRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public StopApplicationRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new StopApplicationRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_APPLICATION_ID) != 0) attributes.add("applicationId");
      return "Cannot build StopApplicationRequest, some of required attributes are not set " + attributes;
    }
  }
}
