package org.cloudfoundry.client.v3.droplets;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link _GetDropletRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code GetDropletRequest.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_GetDropletRequest"})
public final class GetDropletRequest extends org.cloudfoundry.client.v3.droplets._GetDropletRequest {
  private final String dropletId;

  private GetDropletRequest(GetDropletRequest.Builder builder) {
    this.dropletId = builder.dropletId;
  }

  /**
   * The droplet id
   */
  @Override
  public String getDropletId() {
    return dropletId;
  }

  /**
   * This instance is equal to all instances of {@code GetDropletRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetDropletRequest
        && equalTo((GetDropletRequest) another);
  }

  private boolean equalTo(GetDropletRequest another) {
    return dropletId.equals(another.dropletId);
  }

  /**
   * Computes a hash code from attributes: {@code dropletId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + dropletId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetDropletRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetDropletRequest{"
        + "dropletId=" + dropletId
        + "}";
  }

  /**
   * Creates a builder for {@link GetDropletRequest GetDropletRequest}.
   * @return A new GetDropletRequest builder
   */
  public static GetDropletRequest.Builder builder() {
    return new GetDropletRequest.Builder();
  }

  /**
   * Builds instances of type {@link GetDropletRequest GetDropletRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_DROPLET_ID = 0x1L;
    private long initBits = 0x1L;

    private String dropletId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetDropletRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetDropletRequest instance) {
      return from((_GetDropletRequest) instance);
    }

    /**
     * Copy abstract value type {@code _GetDropletRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetDropletRequest instance) {
      Objects.requireNonNull(instance, "instance");
      dropletId(instance.getDropletId());
      return this;
    }

    /**
     * Initializes the value for the {@link _GetDropletRequest#getDropletId() dropletId} attribute.
     * @param dropletId The value for dropletId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder dropletId(String dropletId) {
      this.dropletId = Objects.requireNonNull(dropletId, "dropletId");
      initBits &= ~INIT_BIT_DROPLET_ID;
      return this;
    }

    /**
     * Builds a new {@link GetDropletRequest GetDropletRequest}.
     * @return An immutable instance of GetDropletRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetDropletRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetDropletRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_DROPLET_ID) != 0) attributes.add("dropletId");
      return "Cannot build GetDropletRequest, some of required attributes are not set " + attributes;
    }
  }
}
