package org.cloudfoundry.client.v3.processes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Immutable implementation of {@link _ProcessStatisticsResource}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ProcessStatisticsResource.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_ProcessStatisticsResource"})
public final class ProcessStatisticsResource
    extends org.cloudfoundry.client.v3.processes._ProcessStatisticsResource {
  private final @Nullable Long diskQuota;
  private final @Nullable Long fdsQuota;
  private final @Nullable String host;
  private final @Nullable Integer index;
  private final @Nullable List<PortMapping> instancePorts;
  private final @Nullable Long memoryQuota;
  private final @Nullable String state;
  private final @Nullable String type;
  private final @Nullable Long uptime;
  private final @Nullable ProcessUsage usage;

  private ProcessStatisticsResource(ProcessStatisticsResource.Builder builder) {
    this.diskQuota = builder.diskQuota;
    this.fdsQuota = builder.fdsQuota;
    this.host = builder.host;
    this.index = builder.index;
    this.instancePorts = builder.instancePorts == null ? null : createUnmodifiableList(true, builder.instancePorts);
    this.memoryQuota = builder.memoryQuota;
    this.state = builder.state;
    this.type = builder.type;
    this.uptime = builder.uptime;
    this.usage = builder.usage;
  }

  /**
   * The disk quota
   */
  @JsonProperty("disk_quota")
  @Override
  public @Nullable Long getDiskQuota() {
    return diskQuota;
  }

  /**
   * The file desriptor quota
   */
  @JsonProperty("fds_quota")
  @Override
  public @Nullable Long getFdsQuota() {
    return fdsQuota;
  }

  /**
   * The host
   */
  @JsonProperty("host")
  @Override
  public @Nullable String getHost() {
    return host;
  }

  /**
   * The index
   */
  @JsonProperty("index")
  @Override
  public @Nullable Integer getIndex() {
    return index;
  }

  /**
   * The instance port mappings
   */
  @JsonProperty("instance_ports")
  @Override
  public @Nullable List<PortMapping> getInstancePorts() {
    return instancePorts;
  }

  /**
   * The memory quota
   */
  @JsonProperty("mem_quota")
  @Override
  public @Nullable Long getMemoryQuota() {
    return memoryQuota;
  }

  /**
   * The state
   */
  @JsonProperty("state")
  @Override
  public @Nullable String getState() {
    return state;
  }

  /**
   * The type
   */
  @JsonProperty("type")
  @Override
  public @Nullable String getType() {
    return type;
  }

  /**
   * The uptime
   */
  @JsonProperty("uptime")
  @Override
  public @Nullable Long getUptime() {
    return uptime;
  }

  /**
   * The usage
   */
  @JsonProperty("usage")
  @Override
  public @Nullable ProcessUsage getUsage() {
    return usage;
  }

  /**
   * This instance is equal to all instances of {@code ProcessStatisticsResource} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ProcessStatisticsResource
        && equalTo((ProcessStatisticsResource) another);
  }

  private boolean equalTo(ProcessStatisticsResource another) {
    return Objects.equals(diskQuota, another.diskQuota)
        && Objects.equals(fdsQuota, another.fdsQuota)
        && Objects.equals(host, another.host)
        && Objects.equals(index, another.index)
        && Objects.equals(instancePorts, another.instancePorts)
        && Objects.equals(memoryQuota, another.memoryQuota)
        && Objects.equals(state, another.state)
        && Objects.equals(type, another.type)
        && Objects.equals(uptime, another.uptime)
        && Objects.equals(usage, another.usage);
  }

  /**
   * Computes a hash code from attributes: {@code diskQuota}, {@code fdsQuota}, {@code host}, {@code index}, {@code instancePorts}, {@code memoryQuota}, {@code state}, {@code type}, {@code uptime}, {@code usage}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(diskQuota);
    h = h * 17 + Objects.hashCode(fdsQuota);
    h = h * 17 + Objects.hashCode(host);
    h = h * 17 + Objects.hashCode(index);
    h = h * 17 + Objects.hashCode(instancePorts);
    h = h * 17 + Objects.hashCode(memoryQuota);
    h = h * 17 + Objects.hashCode(state);
    h = h * 17 + Objects.hashCode(type);
    h = h * 17 + Objects.hashCode(uptime);
    h = h * 17 + Objects.hashCode(usage);
    return h;
  }

  /**
   * Prints the immutable value {@code ProcessStatisticsResource} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ProcessStatisticsResource{"
        + "diskQuota=" + diskQuota
        + ", fdsQuota=" + fdsQuota
        + ", host=" + host
        + ", index=" + index
        + ", instancePorts=" + instancePorts
        + ", memoryQuota=" + memoryQuota
        + ", state=" + state
        + ", type=" + type
        + ", uptime=" + uptime
        + ", usage=" + usage
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.processes._ProcessStatisticsResource {
    Long diskQuota;
    Long fdsQuota;
    String host;
    Integer index;
    List<PortMapping> instancePorts = null;
    Long memoryQuota;
    String state;
    String type;
    Long uptime;
    ProcessUsage usage;
    @JsonProperty("disk_quota")
    public void setDiskQuota(@Nullable Long diskQuota) {
      this.diskQuota = diskQuota;
    }
    @JsonProperty("fds_quota")
    public void setFdsQuota(@Nullable Long fdsQuota) {
      this.fdsQuota = fdsQuota;
    }
    @JsonProperty("host")
    public void setHost(@Nullable String host) {
      this.host = host;
    }
    @JsonProperty("index")
    public void setIndex(@Nullable Integer index) {
      this.index = index;
    }
    @JsonProperty("instance_ports")
    public void setInstancePorts(@Nullable List<PortMapping> instancePorts) {
      this.instancePorts = instancePorts;
    }
    @JsonProperty("mem_quota")
    public void setMemoryQuota(@Nullable Long memoryQuota) {
      this.memoryQuota = memoryQuota;
    }
    @JsonProperty("state")
    public void setState(@Nullable String state) {
      this.state = state;
    }
    @JsonProperty("type")
    public void setType(@Nullable String type) {
      this.type = type;
    }
    @JsonProperty("uptime")
    public void setUptime(@Nullable Long uptime) {
      this.uptime = uptime;
    }
    @JsonProperty("usage")
    public void setUsage(@Nullable ProcessUsage usage) {
      this.usage = usage;
    }
    @Override
    public Long getDiskQuota() { throw new UnsupportedOperationException(); }
    @Override
    public Long getFdsQuota() { throw new UnsupportedOperationException(); }
    @Override
    public String getHost() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getIndex() { throw new UnsupportedOperationException(); }
    @Override
    public List<PortMapping> getInstancePorts() { throw new UnsupportedOperationException(); }
    @Override
    public Long getMemoryQuota() { throw new UnsupportedOperationException(); }
    @Override
    public String getState() { throw new UnsupportedOperationException(); }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
    @Override
    public Long getUptime() { throw new UnsupportedOperationException(); }
    @Override
    public ProcessUsage getUsage() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ProcessStatisticsResource fromJson(Json json) {
    ProcessStatisticsResource.Builder builder = ProcessStatisticsResource.builder();
    if (json.diskQuota != null) {
      builder.diskQuota(json.diskQuota);
    }
    if (json.fdsQuota != null) {
      builder.fdsQuota(json.fdsQuota);
    }
    if (json.host != null) {
      builder.host(json.host);
    }
    if (json.index != null) {
      builder.index(json.index);
    }
    if (json.instancePorts != null) {
      builder.addAllInstancePorts(json.instancePorts);
    }
    if (json.memoryQuota != null) {
      builder.memoryQuota(json.memoryQuota);
    }
    if (json.state != null) {
      builder.state(json.state);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.uptime != null) {
      builder.uptime(json.uptime);
    }
    if (json.usage != null) {
      builder.usage(json.usage);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ProcessStatisticsResource ProcessStatisticsResource}.
   * @return A new ProcessStatisticsResource builder
   */
  public static ProcessStatisticsResource.Builder builder() {
    return new ProcessStatisticsResource.Builder();
  }

  /**
   * Builds instances of type {@link ProcessStatisticsResource ProcessStatisticsResource}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private Long diskQuota;
    private Long fdsQuota;
    private String host;
    private Integer index;
    private List<PortMapping> instancePorts = null;
    private Long memoryQuota;
    private String state;
    private String type;
    private Long uptime;
    private ProcessUsage usage;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.processes.ProcessStatistics} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ProcessStatistics instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ProcessStatisticsResource} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ProcessStatisticsResource instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ProcessStatisticsResource} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ProcessStatisticsResource instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof ProcessStatistics) {
        ProcessStatistics instance = (ProcessStatistics) object;
        Long fdsQuotaValue = instance.getFdsQuota();
        if (fdsQuotaValue != null) {
          fdsQuota(fdsQuotaValue);
        }
        ProcessUsage usageValue = instance.getUsage();
        if (usageValue != null) {
          usage(usageValue);
        }
        String hostValue = instance.getHost();
        if (hostValue != null) {
          host(hostValue);
        }
        Integer indexValue = instance.getIndex();
        if (indexValue != null) {
          index(indexValue);
        }
        Long memoryQuotaValue = instance.getMemoryQuota();
        if (memoryQuotaValue != null) {
          memoryQuota(memoryQuotaValue);
        }
        String stateValue = instance.getState();
        if (stateValue != null) {
          state(stateValue);
        }
        String typeValue = instance.getType();
        if (typeValue != null) {
          type(typeValue);
        }
        Long diskQuotaValue = instance.getDiskQuota();
        if (diskQuotaValue != null) {
          diskQuota(diskQuotaValue);
        }
        List<PortMapping> instancePortsValue = instance.getInstancePorts();
        if (instancePortsValue != null) {
          addAllInstancePorts(instancePortsValue);
        }
        Long uptimeValue = instance.getUptime();
        if (uptimeValue != null) {
          uptime(uptimeValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link _ProcessStatisticsResource#getDiskQuota() diskQuota} attribute.
     * @param diskQuota The value for diskQuota (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder diskQuota(@Nullable Long diskQuota) {
      this.diskQuota = diskQuota;
      return this;
    }

    /**
     * Initializes the value for the {@link _ProcessStatisticsResource#getFdsQuota() fdsQuota} attribute.
     * @param fdsQuota The value for fdsQuota (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder fdsQuota(@Nullable Long fdsQuota) {
      this.fdsQuota = fdsQuota;
      return this;
    }

    /**
     * Initializes the value for the {@link _ProcessStatisticsResource#getHost() host} attribute.
     * @param host The value for host (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder host(@Nullable String host) {
      this.host = host;
      return this;
    }

    /**
     * Initializes the value for the {@link _ProcessStatisticsResource#getIndex() index} attribute.
     * @param index The value for index (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder index(@Nullable Integer index) {
      this.index = index;
      return this;
    }

    /**
     * Adds one element to {@link _ProcessStatisticsResource#getInstancePorts() instancePorts} list.
     * @param element A instancePorts element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder instancePort(PortMapping element) {
      if (this.instancePorts == null) {
        this.instancePorts = new ArrayList<PortMapping>();
      }
      this.instancePorts.add(Objects.requireNonNull(element, "instancePorts element"));
      return this;
    }

    /**
     * Adds elements to {@link _ProcessStatisticsResource#getInstancePorts() instancePorts} list.
     * @param elements An array of instancePorts elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder instancePort(PortMapping... elements) {
      if (this.instancePorts == null) {
        this.instancePorts = new ArrayList<PortMapping>();
      }
      for (PortMapping element : elements) {
        this.instancePorts.add(Objects.requireNonNull(element, "instancePorts element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ProcessStatisticsResource#getInstancePorts() instancePorts} list.
     * @param elements An iterable of instancePorts elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder instancePorts(@Nullable Iterable<? extends PortMapping> elements) {
      if (elements == null) {
        this.instancePorts = null;
        return this;
      }
      this.instancePorts = new ArrayList<PortMapping>();
      return addAllInstancePorts(elements);
    }

    /**
     * Adds elements to {@link _ProcessStatisticsResource#getInstancePorts() instancePorts} list.
     * @param elements An iterable of instancePorts elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllInstancePorts(Iterable<? extends PortMapping> elements) {
      Objects.requireNonNull(elements, "instancePorts element");
      if (this.instancePorts == null) {
        this.instancePorts = new ArrayList<PortMapping>();
      }
      for (PortMapping element : elements) {
        this.instancePorts.add(Objects.requireNonNull(element, "instancePorts element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _ProcessStatisticsResource#getMemoryQuota() memoryQuota} attribute.
     * @param memoryQuota The value for memoryQuota (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder memoryQuota(@Nullable Long memoryQuota) {
      this.memoryQuota = memoryQuota;
      return this;
    }

    /**
     * Initializes the value for the {@link _ProcessStatisticsResource#getState() state} attribute.
     * @param state The value for state (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder state(@Nullable String state) {
      this.state = state;
      return this;
    }

    /**
     * Initializes the value for the {@link _ProcessStatisticsResource#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(@Nullable String type) {
      this.type = type;
      return this;
    }

    /**
     * Initializes the value for the {@link _ProcessStatisticsResource#getUptime() uptime} attribute.
     * @param uptime The value for uptime (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder uptime(@Nullable Long uptime) {
      this.uptime = uptime;
      return this;
    }

    /**
     * Initializes the value for the {@link _ProcessStatisticsResource#getUsage() usage} attribute.
     * @param usage The value for usage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder usage(@Nullable ProcessUsage usage) {
      this.usage = usage;
      return this;
    }

    /**
     * Builds a new {@link ProcessStatisticsResource ProcessStatisticsResource}.
     * @return An immutable instance of ProcessStatisticsResource
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ProcessStatisticsResource build() {
      return new ProcessStatisticsResource(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
