package org.cloudfoundry.uaa.clients;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link _BatchCreateClientsResponse}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code BatchCreateClientsResponse.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_BatchCreateClientsResponse"})
public final class BatchCreateClientsResponse extends org.cloudfoundry.uaa.clients._BatchCreateClientsResponse {
  private final List<Client> clients;

  private BatchCreateClientsResponse(BatchCreateClientsResponse.Builder builder) {
    this.clients = createUnmodifiableList(true, builder.clients);
  }

  /**
   * The created clients
   */
  @JsonProperty("clients")
  @Override
  public List<Client> getClients() {
    return clients;
  }

  /**
   * This instance is equal to all instances of {@code BatchCreateClientsResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof BatchCreateClientsResponse
        && equalTo((BatchCreateClientsResponse) another);
  }

  private boolean equalTo(BatchCreateClientsResponse another) {
    return clients.equals(another.clients);
  }

  /**
   * Computes a hash code from attributes: {@code clients}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + clients.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code BatchCreateClientsResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "BatchCreateClientsResponse{"
        + "clients=" + clients
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.clients._BatchCreateClientsResponse {
    List<Client> clients = Collections.emptyList();
    @JsonProperty("clients")
    public void setClients(List<Client> clients) {
      this.clients = clients;
    }
    @Override
    public List<Client> getClients() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static BatchCreateClientsResponse fromJson(Json json) {
    BatchCreateClientsResponse.Builder builder = BatchCreateClientsResponse.builder();
    if (json.clients != null) {
      builder.addAllClients(json.clients);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link BatchCreateClientsResponse BatchCreateClientsResponse}.
   * @return A new BatchCreateClientsResponse builder
   */
  public static BatchCreateClientsResponse.Builder builder() {
    return new BatchCreateClientsResponse.Builder();
  }

  /**
   * Builds instances of type {@link BatchCreateClientsResponse BatchCreateClientsResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private List<Client> clients = new ArrayList<Client>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code BatchCreateClientsResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(BatchCreateClientsResponse instance) {
      return from((_BatchCreateClientsResponse) instance);
    }

    /**
     * Copy abstract value type {@code _BatchCreateClientsResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_BatchCreateClientsResponse instance) {
      Objects.requireNonNull(instance, "instance");
      addAllClients(instance.getClients());
      return this;
    }

    /**
     * Adds one element to {@link _BatchCreateClientsResponse#getClients() clients} list.
     * @param element A clients element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder client(Client element) {
      this.clients.add(Objects.requireNonNull(element, "clients element"));
      return this;
    }

    /**
     * Adds elements to {@link _BatchCreateClientsResponse#getClients() clients} list.
     * @param elements An array of clients elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder client(Client... elements) {
      for (Client element : elements) {
        this.clients.add(Objects.requireNonNull(element, "clients element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _BatchCreateClientsResponse#getClients() clients} list.
     * @param elements An iterable of clients elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clients(Iterable<? extends Client> elements) {
      this.clients.clear();
      return addAllClients(elements);
    }

    /**
     * Adds elements to {@link _BatchCreateClientsResponse#getClients() clients} list.
     * @param elements An iterable of clients elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllClients(Iterable<? extends Client> elements) {
      for (Client element : elements) {
        this.clients.add(Objects.requireNonNull(element, "clients element"));
      }
      return this;
    }

    /**
     * Builds a new {@link BatchCreateClientsResponse BatchCreateClientsResponse}.
     * @return An immutable instance of BatchCreateClientsResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public BatchCreateClientsResponse build() {
      return new BatchCreateClientsResponse(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
