package org.cloudfoundry.uaa.groups;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;

/**
 * Immutable implementation of {@link _CreateGroupRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code CreateGroupRequest.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_CreateGroupRequest"})
public final class CreateGroupRequest extends org.cloudfoundry.uaa.groups._CreateGroupRequest {
  private final @Nullable String description;
  private final String displayName;
  private final @Nullable List<MemberSummary> members;
  private final @Nullable String identityZoneId;

  private CreateGroupRequest(CreateGroupRequest.Builder builder) {
    this.description = builder.description;
    this.displayName = builder.displayName;
    this.members = builder.members == null ? null : createUnmodifiableList(true, builder.members);
    this.identityZoneId = builder.identityZoneId;
  }

  /**
   * Human readable description of the group, displayed e.g. when approving scopes
   */
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * The identifier specified upon creation of the group, unique within the identity zone
   */
  @Override
  public String getDisplayName() {
    return displayName;
  }

  /**
   * Array of group members
   */
  @Override
  public @Nullable List<MemberSummary> getMembers() {
    return members;
  }

  /**
   * Returns the identity zone id
   * @return the identity zone id
   */
  @Override
  public @Nullable String getIdentityZoneId() {
    return identityZoneId;
  }

  /**
   * This instance is equal to all instances of {@code CreateGroupRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateGroupRequest
        && equalTo((CreateGroupRequest) another);
  }

  private boolean equalTo(CreateGroupRequest another) {
    return Objects.equals(description, another.description)
        && displayName.equals(another.displayName)
        && Objects.equals(members, another.members)
        && Objects.equals(identityZoneId, another.identityZoneId);
  }

  /**
   * Computes a hash code from attributes: {@code description}, {@code displayName}, {@code members}, {@code identityZoneId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(description);
    h = h * 17 + displayName.hashCode();
    h = h * 17 + Objects.hashCode(members);
    h = h * 17 + Objects.hashCode(identityZoneId);
    return h;
  }

  /**
   * Prints the immutable value {@code CreateGroupRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateGroupRequest{"
        + "description=" + description
        + ", displayName=" + displayName
        + ", members=" + members
        + ", identityZoneId=" + identityZoneId
        + "}";
  }

  /**
   * Creates a builder for {@link CreateGroupRequest CreateGroupRequest}.
   * @return A new CreateGroupRequest builder
   */
  public static CreateGroupRequest.Builder builder() {
    return new CreateGroupRequest.Builder();
  }

  /**
   * Builds instances of type {@link CreateGroupRequest CreateGroupRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_DISPLAY_NAME = 0x1L;
    private long initBits = 0x1L;

    private String description;
    private String displayName;
    private List<MemberSummary> members = null;
    private String identityZoneId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.IdentityZoned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(IdentityZoned instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateGroupRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateGroupRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _CreateGroupRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CreateGroupRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof IdentityZoned) {
        IdentityZoned instance = (IdentityZoned) object;
        String identityZoneIdValue = instance.getIdentityZoneId();
        if (identityZoneIdValue != null) {
          identityZoneId(identityZoneIdValue);
        }
      }
      if (object instanceof org.cloudfoundry.uaa.groups._CreateGroupRequest) {
        org.cloudfoundry.uaa.groups._CreateGroupRequest instance = (org.cloudfoundry.uaa.groups._CreateGroupRequest) object;
        String descriptionValue = instance.getDescription();
        if (descriptionValue != null) {
          description(descriptionValue);
        }
        displayName(instance.getDisplayName());
        List<MemberSummary> membersValue = instance.getMembers();
        if (membersValue != null) {
          addAllMembers(membersValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link _CreateGroupRequest#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateGroupRequest#getDisplayName() displayName} attribute.
     * @param displayName The value for displayName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder displayName(String displayName) {
      this.displayName = Objects.requireNonNull(displayName, "displayName");
      initBits &= ~INIT_BIT_DISPLAY_NAME;
      return this;
    }

    /**
     * Adds one element to {@link _CreateGroupRequest#getMembers() members} list.
     * @param element A members element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder member(MemberSummary element) {
      if (this.members == null) {
        this.members = new ArrayList<MemberSummary>();
      }
      this.members.add(Objects.requireNonNull(element, "members element"));
      return this;
    }

    /**
     * Adds elements to {@link _CreateGroupRequest#getMembers() members} list.
     * @param elements An array of members elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder member(MemberSummary... elements) {
      if (this.members == null) {
        this.members = new ArrayList<MemberSummary>();
      }
      for (MemberSummary element : elements) {
        this.members.add(Objects.requireNonNull(element, "members element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _CreateGroupRequest#getMembers() members} list.
     * @param elements An iterable of members elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder members(@Nullable Iterable<? extends MemberSummary> elements) {
      if (elements == null) {
        this.members = null;
        return this;
      }
      this.members = new ArrayList<MemberSummary>();
      return addAllMembers(elements);
    }

    /**
     * Adds elements to {@link _CreateGroupRequest#getMembers() members} list.
     * @param elements An iterable of members elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllMembers(Iterable<? extends MemberSummary> elements) {
      Objects.requireNonNull(elements, "members element");
      if (this.members == null) {
        this.members = new ArrayList<MemberSummary>();
      }
      for (MemberSummary element : elements) {
        this.members.add(Objects.requireNonNull(element, "members element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateGroupRequest#getIdentityZoneId() identityZoneId} attribute.
     * @param identityZoneId The value for identityZoneId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
      return this;
    }

    /**
     * Builds a new {@link CreateGroupRequest CreateGroupRequest}.
     * @return An immutable instance of CreateGroupRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateGroupRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CreateGroupRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_DISPLAY_NAME) != 0) attributes.add("displayName");
      return "Cannot build CreateGroupRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
