package org.cloudfoundry.uaa.groups;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;

/**
 * Immutable implementation of {@link _MapExternalGroupRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code MapExternalGroupRequest.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_MapExternalGroupRequest"})
public final class MapExternalGroupRequest extends org.cloudfoundry.uaa.groups._MapExternalGroupRequest {
  private final String externalGroup;
  private final String groupId;
  private final @Nullable String origin;
  private final @Nullable String identityZoneId;

  private MapExternalGroupRequest(MapExternalGroupRequest.Builder builder) {
    this.externalGroup = builder.externalGroup;
    this.groupId = builder.groupId;
    this.origin = builder.origin;
    this.identityZoneId = builder.identityZoneId;
  }

  /**
   * The identifier for the group in external identity provider that needs to be mapped to internal UAA groups
   */
  @Override
  public String getExternalGroup() {
    return externalGroup;
  }

  /**
   * The group unique ID
   */
  @Override
  public String getGroupId() {
    return groupId;
  }

  /**
   * Unique alias of the identity provider
   */
  @Override
  public @Nullable String getOrigin() {
    return origin;
  }

  /**
   * Returns the identity zone id
   * @return the identity zone id
   */
  @Override
  public @Nullable String getIdentityZoneId() {
    return identityZoneId;
  }

  /**
   * This instance is equal to all instances of {@code MapExternalGroupRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof MapExternalGroupRequest
        && equalTo((MapExternalGroupRequest) another);
  }

  private boolean equalTo(MapExternalGroupRequest another) {
    return externalGroup.equals(another.externalGroup)
        && groupId.equals(another.groupId)
        && Objects.equals(origin, another.origin)
        && Objects.equals(identityZoneId, another.identityZoneId);
  }

  /**
   * Computes a hash code from attributes: {@code externalGroup}, {@code groupId}, {@code origin}, {@code identityZoneId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + externalGroup.hashCode();
    h = h * 17 + groupId.hashCode();
    h = h * 17 + Objects.hashCode(origin);
    h = h * 17 + Objects.hashCode(identityZoneId);
    return h;
  }

  /**
   * Prints the immutable value {@code MapExternalGroupRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "MapExternalGroupRequest{"
        + "externalGroup=" + externalGroup
        + ", groupId=" + groupId
        + ", origin=" + origin
        + ", identityZoneId=" + identityZoneId
        + "}";
  }

  /**
   * Creates a builder for {@link MapExternalGroupRequest MapExternalGroupRequest}.
   * @return A new MapExternalGroupRequest builder
   */
  public static MapExternalGroupRequest.Builder builder() {
    return new MapExternalGroupRequest.Builder();
  }

  /**
   * Builds instances of type {@link MapExternalGroupRequest MapExternalGroupRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_EXTERNAL_GROUP = 0x1L;
    private static final long INIT_BIT_GROUP_ID = 0x2L;
    private long initBits = 0x3L;

    private String externalGroup;
    private String groupId;
    private String origin;
    private String identityZoneId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.IdentityZoned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(IdentityZoned instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code MapExternalGroupRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(MapExternalGroupRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _MapExternalGroupRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_MapExternalGroupRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof IdentityZoned) {
        IdentityZoned instance = (IdentityZoned) object;
        String identityZoneIdValue = instance.getIdentityZoneId();
        if (identityZoneIdValue != null) {
          identityZoneId(identityZoneIdValue);
        }
      }
      if (object instanceof org.cloudfoundry.uaa.groups._MapExternalGroupRequest) {
        org.cloudfoundry.uaa.groups._MapExternalGroupRequest instance = (org.cloudfoundry.uaa.groups._MapExternalGroupRequest) object;
        externalGroup(instance.getExternalGroup());
        groupId(instance.getGroupId());
        String originValue = instance.getOrigin();
        if (originValue != null) {
          origin(originValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link _MapExternalGroupRequest#getExternalGroup() externalGroup} attribute.
     * @param externalGroup The value for externalGroup 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder externalGroup(String externalGroup) {
      this.externalGroup = Objects.requireNonNull(externalGroup, "externalGroup");
      initBits &= ~INIT_BIT_EXTERNAL_GROUP;
      return this;
    }

    /**
     * Initializes the value for the {@link _MapExternalGroupRequest#getGroupId() groupId} attribute.
     * @param groupId The value for groupId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder groupId(String groupId) {
      this.groupId = Objects.requireNonNull(groupId, "groupId");
      initBits &= ~INIT_BIT_GROUP_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _MapExternalGroupRequest#getOrigin() origin} attribute.
     * @param origin The value for origin (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder origin(@Nullable String origin) {
      this.origin = origin;
      return this;
    }

    /**
     * Initializes the value for the {@link _MapExternalGroupRequest#getIdentityZoneId() identityZoneId} attribute.
     * @param identityZoneId The value for identityZoneId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
      return this;
    }

    /**
     * Builds a new {@link MapExternalGroupRequest MapExternalGroupRequest}.
     * @return An immutable instance of MapExternalGroupRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public MapExternalGroupRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new MapExternalGroupRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_EXTERNAL_GROUP) != 0) attributes.add("externalGroup");
      if ((initBits & INIT_BIT_GROUP_ID) != 0) attributes.add("groupId");
      return "Cannot build MapExternalGroupRequest, some of required attributes are not set " + attributes;
    }
  }
}
