package org.cloudfoundry.uaa.identityproviders;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Immutable implementation of {@link _AttributeMappings}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code AttributeMappings.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_AttributeMappings"})
public final class AttributeMappings extends org.cloudfoundry.uaa.identityproviders._AttributeMappings {
  private final @Nullable String email;
  private final @Nullable List<String> externalGroups;
  private final @Nullable String familyName;
  private final @Nullable String firstName;
  private final @Nullable String givenName;
  private final @Nullable String phoneNumber;

  private AttributeMappings(AttributeMappings.Builder builder) {
    this.email = builder.email;
    this.externalGroups = builder.externalGroups == null ? null : createUnmodifiableList(true, builder.externalGroups);
    this.familyName = builder.familyName;
    this.firstName = builder.firstName;
    this.givenName = builder.givenName;
    this.phoneNumber = builder.phoneNumber;
  }

  /**
   * Map email to the attribute for email in the provider assertion.
   */
  @JsonProperty("email")
  @Override
  public @Nullable String getEmail() {
    return email;
  }

  /**
   * Map external_groups to the attribute for groups in the provider assertion (can be a list or a string).
   */
  @JsonProperty("external_groups")
  @JsonFormat(with = {JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
  @Override
  public @Nullable List<String> getExternalGroups() {
    return externalGroups;
  }

  /**
   * Map family_name to the attribute for family name in the provider assertion.
   */
  @JsonProperty("family_name")
  @Override
  public @Nullable String getFamilyName() {
    return familyName;
  }

  /**
   * Map first_name to the attribute for fist name in the provider assertion.
   */
  @JsonProperty("first_name")
  @Override
  public @Nullable String getFirstName() {
    return firstName;
  }

  /**
   * Map given_name to the attribute for given name in the provider assertion.
   */
  @JsonProperty("given_name")
  @Override
  public @Nullable String getGivenName() {
    return givenName;
  }

  /**
   * Map phone_number to the attribute for phone number in the provider assertion.
   */
  @JsonProperty("phone_number")
  @Override
  public @Nullable String getPhoneNumber() {
    return phoneNumber;
  }

  /**
   * This instance is equal to all instances of {@code AttributeMappings} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof AttributeMappings
        && equalTo((AttributeMappings) another);
  }

  private boolean equalTo(AttributeMappings another) {
    return Objects.equals(email, another.email)
        && Objects.equals(externalGroups, another.externalGroups)
        && Objects.equals(familyName, another.familyName)
        && Objects.equals(firstName, another.firstName)
        && Objects.equals(givenName, another.givenName)
        && Objects.equals(phoneNumber, another.phoneNumber);
  }

  /**
   * Computes a hash code from attributes: {@code email}, {@code externalGroups}, {@code familyName}, {@code firstName}, {@code givenName}, {@code phoneNumber}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(email);
    h = h * 17 + Objects.hashCode(externalGroups);
    h = h * 17 + Objects.hashCode(familyName);
    h = h * 17 + Objects.hashCode(firstName);
    h = h * 17 + Objects.hashCode(givenName);
    h = h * 17 + Objects.hashCode(phoneNumber);
    return h;
  }

  /**
   * Prints the immutable value {@code AttributeMappings} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "AttributeMappings{"
        + "email=" + email
        + ", externalGroups=" + externalGroups
        + ", familyName=" + familyName
        + ", firstName=" + firstName
        + ", givenName=" + givenName
        + ", phoneNumber=" + phoneNumber
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.identityproviders._AttributeMappings {
    String email;
    List<String> externalGroups = null;
    String familyName;
    String firstName;
    String givenName;
    String phoneNumber;
    @JsonProperty("email")
    public void setEmail(@Nullable String email) {
      this.email = email;
    }
    @JsonProperty("external_groups")
    @JsonFormat(with = {JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
    public void setExternalGroups(@Nullable List<String> externalGroups) {
      this.externalGroups = externalGroups;
    }
    @JsonProperty("family_name")
    public void setFamilyName(@Nullable String familyName) {
      this.familyName = familyName;
    }
    @JsonProperty("first_name")
    public void setFirstName(@Nullable String firstName) {
      this.firstName = firstName;
    }
    @JsonProperty("given_name")
    public void setGivenName(@Nullable String givenName) {
      this.givenName = givenName;
    }
    @JsonProperty("phone_number")
    public void setPhoneNumber(@Nullable String phoneNumber) {
      this.phoneNumber = phoneNumber;
    }
    @Override
    public String getEmail() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getExternalGroups() { throw new UnsupportedOperationException(); }
    @Override
    public String getFamilyName() { throw new UnsupportedOperationException(); }
    @Override
    public String getFirstName() { throw new UnsupportedOperationException(); }
    @Override
    public String getGivenName() { throw new UnsupportedOperationException(); }
    @Override
    public String getPhoneNumber() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static AttributeMappings fromJson(Json json) {
    AttributeMappings.Builder builder = AttributeMappings.builder();
    if (json.email != null) {
      builder.email(json.email);
    }
    if (json.externalGroups != null) {
      builder.addAllExternalGroups(json.externalGroups);
    }
    if (json.familyName != null) {
      builder.familyName(json.familyName);
    }
    if (json.firstName != null) {
      builder.firstName(json.firstName);
    }
    if (json.givenName != null) {
      builder.givenName(json.givenName);
    }
    if (json.phoneNumber != null) {
      builder.phoneNumber(json.phoneNumber);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link AttributeMappings AttributeMappings}.
   * @return A new AttributeMappings builder
   */
  public static AttributeMappings.Builder builder() {
    return new AttributeMappings.Builder();
  }

  /**
   * Builds instances of type {@link AttributeMappings AttributeMappings}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private String email;
    private List<String> externalGroups = null;
    private String familyName;
    private String firstName;
    private String givenName;
    private String phoneNumber;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AttributeMappings} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AttributeMappings instance) {
      return from((_AttributeMappings) instance);
    }

    /**
     * Copy abstract value type {@code _AttributeMappings} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_AttributeMappings instance) {
      Objects.requireNonNull(instance, "instance");
      String emailValue = instance.getEmail();
      if (emailValue != null) {
        email(emailValue);
      }
      List<String> externalGroupsValue = instance.getExternalGroups();
      if (externalGroupsValue != null) {
        addAllExternalGroups(externalGroupsValue);
      }
      String familyNameValue = instance.getFamilyName();
      if (familyNameValue != null) {
        familyName(familyNameValue);
      }
      String firstNameValue = instance.getFirstName();
      if (firstNameValue != null) {
        firstName(firstNameValue);
      }
      String givenNameValue = instance.getGivenName();
      if (givenNameValue != null) {
        givenName(givenNameValue);
      }
      String phoneNumberValue = instance.getPhoneNumber();
      if (phoneNumberValue != null) {
        phoneNumber(phoneNumberValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _AttributeMappings#getEmail() email} attribute.
     * @param email The value for email (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder email(@Nullable String email) {
      this.email = email;
      return this;
    }

    /**
     * Adds one element to {@link _AttributeMappings#getExternalGroups() externalGroups} list.
     * @param element A externalGroups element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder externalGroup(String element) {
      if (this.externalGroups == null) {
        this.externalGroups = new ArrayList<String>();
      }
      this.externalGroups.add(Objects.requireNonNull(element, "externalGroups element"));
      return this;
    }

    /**
     * Adds elements to {@link _AttributeMappings#getExternalGroups() externalGroups} list.
     * @param elements An array of externalGroups elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder externalGroup(String... elements) {
      if (this.externalGroups == null) {
        this.externalGroups = new ArrayList<String>();
      }
      for (String element : elements) {
        this.externalGroups.add(Objects.requireNonNull(element, "externalGroups element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _AttributeMappings#getExternalGroups() externalGroups} list.
     * @param elements An iterable of externalGroups elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder externalGroups(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.externalGroups = null;
        return this;
      }
      this.externalGroups = new ArrayList<String>();
      return addAllExternalGroups(elements);
    }

    /**
     * Adds elements to {@link _AttributeMappings#getExternalGroups() externalGroups} list.
     * @param elements An iterable of externalGroups elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllExternalGroups(Iterable<String> elements) {
      Objects.requireNonNull(elements, "externalGroups element");
      if (this.externalGroups == null) {
        this.externalGroups = new ArrayList<String>();
      }
      for (String element : elements) {
        this.externalGroups.add(Objects.requireNonNull(element, "externalGroups element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _AttributeMappings#getFamilyName() familyName} attribute.
     * @param familyName The value for familyName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder familyName(@Nullable String familyName) {
      this.familyName = familyName;
      return this;
    }

    /**
     * Initializes the value for the {@link _AttributeMappings#getFirstName() firstName} attribute.
     * @param firstName The value for firstName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder firstName(@Nullable String firstName) {
      this.firstName = firstName;
      return this;
    }

    /**
     * Initializes the value for the {@link _AttributeMappings#getGivenName() givenName} attribute.
     * @param givenName The value for givenName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder givenName(@Nullable String givenName) {
      this.givenName = givenName;
      return this;
    }

    /**
     * Initializes the value for the {@link _AttributeMappings#getPhoneNumber() phoneNumber} attribute.
     * @param phoneNumber The value for phoneNumber (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder phoneNumber(@Nullable String phoneNumber) {
      this.phoneNumber = phoneNumber;
      return this;
    }

    /**
     * Builds a new {@link AttributeMappings AttributeMappings}.
     * @return An immutable instance of AttributeMappings
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public AttributeMappings build() {
      return new AttributeMappings(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
