package org.cloudfoundry.uaa.identityproviders;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;

/**
 * Immutable implementation of {@link _CreateIdentityProviderRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code CreateIdentityProviderRequest.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_CreateIdentityProviderRequest"})
public final class CreateIdentityProviderRequest
    extends org.cloudfoundry.uaa.identityproviders._CreateIdentityProviderRequest {
  private final @Nullable Boolean active;
  private final String configuration;
  private final String name;
  private final String originKey;
  private final Type type;
  private final @Nullable String identityZoneId;

  private CreateIdentityProviderRequest(CreateIdentityProviderRequest.Builder builder) {
    this.active = builder.active;
    this.configuration = builder.configuration;
    this.name = builder.name;
    this.originKey = builder.originKey;
    this.type = builder.type;
    this.identityZoneId = builder.identityZoneId;
  }

  /**
   * Whether the identity provider is active
   */
  @Override
  public @Nullable Boolean getActive() {
    return active;
  }

  /**
   * The configuration of this identity provider according to its type.
   */
  @Override
  public String getConfiguration() {
    return configuration;
  }

  /**
   * Human-readable name for this provider
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * A unique alias for the provider
   */
  @Override
  public String getOriginKey() {
    return originKey;
  }

  /**
   * The type of the identity provider.
   */
  @Override
  public Type getType() {
    return type;
  }

  /**
   * Returns the identity zone id
   * @return the identity zone id
   */
  @Override
  public @Nullable String getIdentityZoneId() {
    return identityZoneId;
  }

  /**
   * This instance is equal to all instances of {@code CreateIdentityProviderRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateIdentityProviderRequest
        && equalTo((CreateIdentityProviderRequest) another);
  }

  private boolean equalTo(CreateIdentityProviderRequest another) {
    return Objects.equals(active, another.active)
        && configuration.equals(another.configuration)
        && name.equals(another.name)
        && originKey.equals(another.originKey)
        && type.equals(another.type)
        && Objects.equals(identityZoneId, another.identityZoneId);
  }

  /**
   * Computes a hash code from attributes: {@code active}, {@code configuration}, {@code name}, {@code originKey}, {@code type}, {@code identityZoneId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(active);
    h = h * 17 + configuration.hashCode();
    h = h * 17 + name.hashCode();
    h = h * 17 + originKey.hashCode();
    h = h * 17 + type.hashCode();
    h = h * 17 + Objects.hashCode(identityZoneId);
    return h;
  }

  /**
   * Prints the immutable value {@code CreateIdentityProviderRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateIdentityProviderRequest{"
        + "active=" + active
        + ", configuration=" + configuration
        + ", name=" + name
        + ", originKey=" + originKey
        + ", type=" + type
        + ", identityZoneId=" + identityZoneId
        + "}";
  }

  /**
   * Creates a builder for {@link CreateIdentityProviderRequest CreateIdentityProviderRequest}.
   * @return A new CreateIdentityProviderRequest builder
   */
  public static CreateIdentityProviderRequest.Builder builder() {
    return new CreateIdentityProviderRequest.Builder();
  }

  /**
   * Builds instances of type {@link CreateIdentityProviderRequest CreateIdentityProviderRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_CONFIGURATION = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private static final long INIT_BIT_ORIGIN_KEY = 0x4L;
    private static final long INIT_BIT_TYPE = 0x8L;
    private long initBits = 0xfL;

    private Boolean active;
    private String configuration;
    private String name;
    private String originKey;
    private Type type;
    private String identityZoneId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.IdentityZoned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(IdentityZoned instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateIdentityProviderRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateIdentityProviderRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _CreateIdentityProviderRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CreateIdentityProviderRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof IdentityZoned) {
        IdentityZoned instance = (IdentityZoned) object;
        String identityZoneIdValue = instance.getIdentityZoneId();
        if (identityZoneIdValue != null) {
          identityZoneId(identityZoneIdValue);
        }
      }
      if (object instanceof org.cloudfoundry.uaa.identityproviders._CreateIdentityProviderRequest) {
        org.cloudfoundry.uaa.identityproviders._CreateIdentityProviderRequest instance = (org.cloudfoundry.uaa.identityproviders._CreateIdentityProviderRequest) object;
        name(instance.getName());
        Boolean activeValue = instance.getActive();
        if (activeValue != null) {
          active(activeValue);
        }
        type(instance.getType());
        configuration(instance.getConfiguration());
        originKey(instance.getOriginKey());
      }
    }

    /**
     * Initializes the value for the {@link _CreateIdentityProviderRequest#getActive() active} attribute.
     * @param active The value for active (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder active(@Nullable Boolean active) {
      this.active = active;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateIdentityProviderRequest#getConfiguration() configuration} attribute.
     * @param configuration The value for configuration 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder configuration(String configuration) {
      this.configuration = Objects.requireNonNull(configuration, "configuration");
      initBits &= ~INIT_BIT_CONFIGURATION;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateIdentityProviderRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateIdentityProviderRequest#getOriginKey() originKey} attribute.
     * @param originKey The value for originKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder originKey(String originKey) {
      this.originKey = Objects.requireNonNull(originKey, "originKey");
      initBits &= ~INIT_BIT_ORIGIN_KEY;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateIdentityProviderRequest#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(Type type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateIdentityProviderRequest#getIdentityZoneId() identityZoneId} attribute.
     * @param identityZoneId The value for identityZoneId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
      return this;
    }

    /**
     * Builds a new {@link CreateIdentityProviderRequest CreateIdentityProviderRequest}.
     * @return An immutable instance of CreateIdentityProviderRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateIdentityProviderRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CreateIdentityProviderRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_CONFIGURATION) != 0) attributes.add("configuration");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_ORIGIN_KEY) != 0) attributes.add("originKey");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build CreateIdentityProviderRequest, some of required attributes are not set " + attributes;
    }
  }
}
