package org.cloudfoundry.uaa.identityproviders;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link _LockoutPolicy}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code LockoutPolicy.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_LockoutPolicy"})
public final class LockoutPolicy extends org.cloudfoundry.uaa.identityproviders._LockoutPolicy {
  private final Integer lockAccountPeriodInSecond;
  private final Integer lockoutPeriodInSecond;
  private final Integer numberOfAllowedFailures;

  private LockoutPolicy(LockoutPolicy.Builder builder) {
    this.lockAccountPeriodInSecond = builder.lockAccountPeriodInSecond;
    this.lockoutPeriodInSecond = builder.lockoutPeriodInSecond;
    this.numberOfAllowedFailures = builder.numberOfAllowedFailures;
  }

  /**
   * Number of seconds to lock out an account when lockoutAfterFailures failures is exceeded (defaults to 300).
   */
  @JsonProperty("countFailuresWithin")
  @Override
  public Integer getLockAccountPeriodInSecond() {
    return lockAccountPeriodInSecond;
  }

  /**
   * Number of seconds in which lockoutAfterFailures failures must occur in order for account to be locked (defaults to 3600).
   */
  @JsonProperty("lockoutPeriodSeconds")
  @Override
  public Integer getLockoutPeriodInSecond() {
    return lockoutPeriodInSecond;
  }

  /**
   * Number of allowed failures before account is locked (defaults to 5).
   */
  @JsonProperty("lockoutAfterFailures")
  @Override
  public Integer getNumberOfAllowedFailures() {
    return numberOfAllowedFailures;
  }

  /**
   * This instance is equal to all instances of {@code LockoutPolicy} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof LockoutPolicy
        && equalTo((LockoutPolicy) another);
  }

  private boolean equalTo(LockoutPolicy another) {
    return lockAccountPeriodInSecond.equals(another.lockAccountPeriodInSecond)
        && lockoutPeriodInSecond.equals(another.lockoutPeriodInSecond)
        && numberOfAllowedFailures.equals(another.numberOfAllowedFailures);
  }

  /**
   * Computes a hash code from attributes: {@code lockAccountPeriodInSecond}, {@code lockoutPeriodInSecond}, {@code numberOfAllowedFailures}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + lockAccountPeriodInSecond.hashCode();
    h = h * 17 + lockoutPeriodInSecond.hashCode();
    h = h * 17 + numberOfAllowedFailures.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code LockoutPolicy} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "LockoutPolicy{"
        + "lockAccountPeriodInSecond=" + lockAccountPeriodInSecond
        + ", lockoutPeriodInSecond=" + lockoutPeriodInSecond
        + ", numberOfAllowedFailures=" + numberOfAllowedFailures
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.identityproviders._LockoutPolicy {
    Integer lockAccountPeriodInSecond;
    Integer lockoutPeriodInSecond;
    Integer numberOfAllowedFailures;
    @JsonProperty("countFailuresWithin")
    public void setLockAccountPeriodInSecond(Integer lockAccountPeriodInSecond) {
      this.lockAccountPeriodInSecond = lockAccountPeriodInSecond;
    }
    @JsonProperty("lockoutPeriodSeconds")
    public void setLockoutPeriodInSecond(Integer lockoutPeriodInSecond) {
      this.lockoutPeriodInSecond = lockoutPeriodInSecond;
    }
    @JsonProperty("lockoutAfterFailures")
    public void setNumberOfAllowedFailures(Integer numberOfAllowedFailures) {
      this.numberOfAllowedFailures = numberOfAllowedFailures;
    }
    @Override
    public Integer getLockAccountPeriodInSecond() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getLockoutPeriodInSecond() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getNumberOfAllowedFailures() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static LockoutPolicy fromJson(Json json) {
    LockoutPolicy.Builder builder = LockoutPolicy.builder();
    if (json.lockAccountPeriodInSecond != null) {
      builder.lockAccountPeriodInSecond(json.lockAccountPeriodInSecond);
    }
    if (json.lockoutPeriodInSecond != null) {
      builder.lockoutPeriodInSecond(json.lockoutPeriodInSecond);
    }
    if (json.numberOfAllowedFailures != null) {
      builder.numberOfAllowedFailures(json.numberOfAllowedFailures);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link LockoutPolicy LockoutPolicy}.
   * @return A new LockoutPolicy builder
   */
  public static LockoutPolicy.Builder builder() {
    return new LockoutPolicy.Builder();
  }

  /**
   * Builds instances of type {@link LockoutPolicy LockoutPolicy}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_LOCK_ACCOUNT_PERIOD_IN_SECOND = 0x1L;
    private static final long INIT_BIT_LOCKOUT_PERIOD_IN_SECOND = 0x2L;
    private static final long INIT_BIT_NUMBER_OF_ALLOWED_FAILURES = 0x4L;
    private long initBits = 0x7L;

    private Integer lockAccountPeriodInSecond;
    private Integer lockoutPeriodInSecond;
    private Integer numberOfAllowedFailures;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code LockoutPolicy} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(LockoutPolicy instance) {
      return from((_LockoutPolicy) instance);
    }

    /**
     * Copy abstract value type {@code _LockoutPolicy} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_LockoutPolicy instance) {
      Objects.requireNonNull(instance, "instance");
      lockAccountPeriodInSecond(instance.getLockAccountPeriodInSecond());
      lockoutPeriodInSecond(instance.getLockoutPeriodInSecond());
      numberOfAllowedFailures(instance.getNumberOfAllowedFailures());
      return this;
    }

    /**
     * Initializes the value for the {@link _LockoutPolicy#getLockAccountPeriodInSecond() lockAccountPeriodInSecond} attribute.
     * @param lockAccountPeriodInSecond The value for lockAccountPeriodInSecond 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder lockAccountPeriodInSecond(Integer lockAccountPeriodInSecond) {
      this.lockAccountPeriodInSecond = Objects.requireNonNull(lockAccountPeriodInSecond, "lockAccountPeriodInSecond");
      initBits &= ~INIT_BIT_LOCK_ACCOUNT_PERIOD_IN_SECOND;
      return this;
    }

    /**
     * Initializes the value for the {@link _LockoutPolicy#getLockoutPeriodInSecond() lockoutPeriodInSecond} attribute.
     * @param lockoutPeriodInSecond The value for lockoutPeriodInSecond 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder lockoutPeriodInSecond(Integer lockoutPeriodInSecond) {
      this.lockoutPeriodInSecond = Objects.requireNonNull(lockoutPeriodInSecond, "lockoutPeriodInSecond");
      initBits &= ~INIT_BIT_LOCKOUT_PERIOD_IN_SECOND;
      return this;
    }

    /**
     * Initializes the value for the {@link _LockoutPolicy#getNumberOfAllowedFailures() numberOfAllowedFailures} attribute.
     * @param numberOfAllowedFailures The value for numberOfAllowedFailures 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder numberOfAllowedFailures(Integer numberOfAllowedFailures) {
      this.numberOfAllowedFailures = Objects.requireNonNull(numberOfAllowedFailures, "numberOfAllowedFailures");
      initBits &= ~INIT_BIT_NUMBER_OF_ALLOWED_FAILURES;
      return this;
    }

    /**
     * Builds a new {@link LockoutPolicy LockoutPolicy}.
     * @return An immutable instance of LockoutPolicy
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public LockoutPolicy build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new LockoutPolicy(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_LOCK_ACCOUNT_PERIOD_IN_SECOND) != 0) attributes.add("lockAccountPeriodInSecond");
      if ((initBits & INIT_BIT_LOCKOUT_PERIOD_IN_SECOND) != 0) attributes.add("lockoutPeriodInSecond");
      if ((initBits & INIT_BIT_NUMBER_OF_ALLOWED_FAILURES) != 0) attributes.add("numberOfAllowedFailures");
      return "Cannot build LockoutPolicy, some of required attributes are not set " + attributes;
    }
  }
}
