package org.cloudfoundry.uaa.identityzones;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Immutable implementation of {@link _UpdateIdentityZoneRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code UpdateIdentityZoneRequest.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_UpdateIdentityZoneRequest"})
public final class UpdateIdentityZoneRequest
    extends org.cloudfoundry.uaa.identityzones._UpdateIdentityZoneRequest {
  private final @Nullable IdentityZoneConfiguration configuration;
  private final @Nullable String description;
  private final String identityZoneId;
  private final String name;
  private final String subdomain;
  private final @Nullable Integer version;

  private UpdateIdentityZoneRequest(UpdateIdentityZoneRequest.Builder builder) {
    this.configuration = builder.configuration;
    this.description = builder.description;
    this.identityZoneId = builder.identityZoneId;
    this.name = builder.name;
    this.subdomain = builder.subdomain;
    this.version = builder.version;
  }

  /**
   * The configuration
   */
  @Override
  public @Nullable IdentityZoneConfiguration getConfiguration() {
    return configuration;
  }

  /**
   * The description of the identity zone
   */
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * The id of the identity zone
   */
  @Override
  public String getIdentityZoneId() {
    return identityZoneId;
  }

  /**
   * The name of the identity zone
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * The unique subdomain. It will be converted into lowercase upon creation.
   */
  @Override
  public String getSubdomain() {
    return subdomain;
  }

  /**
   * The version of the identity zone
   */
  @Override
  public @Nullable Integer getVersion() {
    return version;
  }

  /**
   * This instance is equal to all instances of {@code UpdateIdentityZoneRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateIdentityZoneRequest
        && equalTo((UpdateIdentityZoneRequest) another);
  }

  private boolean equalTo(UpdateIdentityZoneRequest another) {
    return Objects.equals(configuration, another.configuration)
        && Objects.equals(description, another.description)
        && identityZoneId.equals(another.identityZoneId)
        && name.equals(another.name)
        && subdomain.equals(another.subdomain)
        && Objects.equals(version, another.version);
  }

  /**
   * Computes a hash code from attributes: {@code configuration}, {@code description}, {@code identityZoneId}, {@code name}, {@code subdomain}, {@code version}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(configuration);
    h = h * 17 + Objects.hashCode(description);
    h = h * 17 + identityZoneId.hashCode();
    h = h * 17 + name.hashCode();
    h = h * 17 + subdomain.hashCode();
    h = h * 17 + Objects.hashCode(version);
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateIdentityZoneRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateIdentityZoneRequest{"
        + "configuration=" + configuration
        + ", description=" + description
        + ", identityZoneId=" + identityZoneId
        + ", name=" + name
        + ", subdomain=" + subdomain
        + ", version=" + version
        + "}";
  }

  /**
   * Creates a builder for {@link UpdateIdentityZoneRequest UpdateIdentityZoneRequest}.
   * @return A new UpdateIdentityZoneRequest builder
   */
  public static UpdateIdentityZoneRequest.Builder builder() {
    return new UpdateIdentityZoneRequest.Builder();
  }

  /**
   * Builds instances of type {@link UpdateIdentityZoneRequest UpdateIdentityZoneRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_IDENTITY_ZONE_ID = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private static final long INIT_BIT_SUBDOMAIN = 0x4L;
    private long initBits = 0x7L;

    private IdentityZoneConfiguration configuration;
    private String description;
    private String identityZoneId;
    private String name;
    private String subdomain;
    private Integer version;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateIdentityZoneRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateIdentityZoneRequest instance) {
      return from((_UpdateIdentityZoneRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UpdateIdentityZoneRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UpdateIdentityZoneRequest instance) {
      Objects.requireNonNull(instance, "instance");
      IdentityZoneConfiguration configurationValue = instance.getConfiguration();
      if (configurationValue != null) {
        configuration(configurationValue);
      }
      String descriptionValue = instance.getDescription();
      if (descriptionValue != null) {
        description(descriptionValue);
      }
      identityZoneId(instance.getIdentityZoneId());
      name(instance.getName());
      subdomain(instance.getSubdomain());
      Integer versionValue = instance.getVersion();
      if (versionValue != null) {
        version(versionValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateIdentityZoneRequest#getConfiguration() configuration} attribute.
     * @param configuration The value for configuration (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder configuration(@Nullable IdentityZoneConfiguration configuration) {
      this.configuration = configuration;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateIdentityZoneRequest#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateIdentityZoneRequest#getIdentityZoneId() identityZoneId} attribute.
     * @param identityZoneId The value for identityZoneId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneId(String identityZoneId) {
      this.identityZoneId = Objects.requireNonNull(identityZoneId, "identityZoneId");
      initBits &= ~INIT_BIT_IDENTITY_ZONE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateIdentityZoneRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateIdentityZoneRequest#getSubdomain() subdomain} attribute.
     * @param subdomain The value for subdomain 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder subdomain(String subdomain) {
      this.subdomain = Objects.requireNonNull(subdomain, "subdomain");
      initBits &= ~INIT_BIT_SUBDOMAIN;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateIdentityZoneRequest#getVersion() version} attribute.
     * @param version The value for version (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder version(@Nullable Integer version) {
      this.version = version;
      return this;
    }

    /**
     * Builds a new {@link UpdateIdentityZoneRequest UpdateIdentityZoneRequest}.
     * @return An immutable instance of UpdateIdentityZoneRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateIdentityZoneRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UpdateIdentityZoneRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_IDENTITY_ZONE_ID) != 0) attributes.add("identityZoneId");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_SUBDOMAIN) != 0) attributes.add("subdomain");
      return "Cannot build UpdateIdentityZoneRequest, some of required attributes are not set " + attributes;
    }
  }
}
