package org.cloudfoundry.uaa.tokens;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.BasicAuthorized;

/**
 * Immutable implementation of {@link _CheckTokenRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code CheckTokenRequest.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_CheckTokenRequest"})
public final class CheckTokenRequest extends org.cloudfoundry.uaa.tokens._CheckTokenRequest {
  private final @Nullable List<String> scopes;
  private final String token;
  private final String clientId;
  private final String clientSecret;

  private CheckTokenRequest(CheckTokenRequest.Builder builder) {
    this.scopes = builder.scopes == null ? null : createUnmodifiableList(true, builder.scopes);
    this.token = builder.token;
    this.clientId = builder.clientId;
    this.clientSecret = builder.clientSecret;
  }

  /**
   * The scopes authorized by the user for this client
   */
  @Override
  public @Nullable List<String> getScopes() {
    return scopes;
  }

  /**
   * The token
   */
  @Override
  public String getToken() {
    return token;
  }

  /**
   * The client id
   */
  @Override
  public String getClientId() {
    return clientId;
  }

  /**
   * The client secret
   */
  @Override
  public String getClientSecret() {
    return clientSecret;
  }

  /**
   * This instance is equal to all instances of {@code CheckTokenRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CheckTokenRequest
        && equalTo((CheckTokenRequest) another);
  }

  private boolean equalTo(CheckTokenRequest another) {
    return Objects.equals(scopes, another.scopes)
        && token.equals(another.token)
        && clientId.equals(another.clientId)
        && clientSecret.equals(another.clientSecret);
  }

  /**
   * Computes a hash code from attributes: {@code scopes}, {@code token}, {@code clientId}, {@code clientSecret}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(scopes);
    h = h * 17 + token.hashCode();
    h = h * 17 + clientId.hashCode();
    h = h * 17 + clientSecret.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CheckTokenRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CheckTokenRequest{"
        + "scopes=" + scopes
        + ", token=" + token
        + ", clientId=" + clientId
        + ", clientSecret=" + clientSecret
        + "}";
  }

  /**
   * Creates a builder for {@link CheckTokenRequest CheckTokenRequest}.
   * @return A new CheckTokenRequest builder
   */
  public static CheckTokenRequest.Builder builder() {
    return new CheckTokenRequest.Builder();
  }

  /**
   * Builds instances of type {@link CheckTokenRequest CheckTokenRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_TOKEN = 0x1L;
    private static final long INIT_BIT_CLIENT_ID = 0x2L;
    private static final long INIT_BIT_CLIENT_SECRET = 0x4L;
    private long initBits = 0x7L;

    private List<String> scopes = null;
    private String token;
    private String clientId;
    private String clientSecret;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.BasicAuthorized} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(BasicAuthorized instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code CheckTokenRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CheckTokenRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _CheckTokenRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CheckTokenRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof BasicAuthorized) {
        BasicAuthorized instance = (BasicAuthorized) object;
        clientSecret(instance.getClientSecret());
        clientId(instance.getClientId());
      }
      if (object instanceof org.cloudfoundry.uaa.tokens._CheckTokenRequest) {
        org.cloudfoundry.uaa.tokens._CheckTokenRequest instance = (org.cloudfoundry.uaa.tokens._CheckTokenRequest) object;
        List<String> scopesValue = instance.getScopes();
        if (scopesValue != null) {
          addAllScopes(scopesValue);
        }
        token(instance.getToken());
      }
    }

    /**
     * Adds one element to {@link _CheckTokenRequest#getScopes() scopes} list.
     * @param element A scopes element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder scope(String element) {
      if (this.scopes == null) {
        this.scopes = new ArrayList<String>();
      }
      this.scopes.add(Objects.requireNonNull(element, "scopes element"));
      return this;
    }

    /**
     * Adds elements to {@link _CheckTokenRequest#getScopes() scopes} list.
     * @param elements An array of scopes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder scope(String... elements) {
      if (this.scopes == null) {
        this.scopes = new ArrayList<String>();
      }
      for (String element : elements) {
        this.scopes.add(Objects.requireNonNull(element, "scopes element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _CheckTokenRequest#getScopes() scopes} list.
     * @param elements An iterable of scopes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder scopes(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.scopes = null;
        return this;
      }
      this.scopes = new ArrayList<String>();
      return addAllScopes(elements);
    }

    /**
     * Adds elements to {@link _CheckTokenRequest#getScopes() scopes} list.
     * @param elements An iterable of scopes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllScopes(Iterable<String> elements) {
      Objects.requireNonNull(elements, "scopes element");
      if (this.scopes == null) {
        this.scopes = new ArrayList<String>();
      }
      for (String element : elements) {
        this.scopes.add(Objects.requireNonNull(element, "scopes element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _CheckTokenRequest#getToken() token} attribute.
     * @param token The value for token 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder token(String token) {
      this.token = Objects.requireNonNull(token, "token");
      initBits &= ~INIT_BIT_TOKEN;
      return this;
    }

    /**
     * Initializes the value for the {@link _CheckTokenRequest#getClientId() clientId} attribute.
     * @param clientId The value for clientId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clientId(String clientId) {
      this.clientId = Objects.requireNonNull(clientId, "clientId");
      initBits &= ~INIT_BIT_CLIENT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _CheckTokenRequest#getClientSecret() clientSecret} attribute.
     * @param clientSecret The value for clientSecret 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clientSecret(String clientSecret) {
      this.clientSecret = Objects.requireNonNull(clientSecret, "clientSecret");
      initBits &= ~INIT_BIT_CLIENT_SECRET;
      return this;
    }

    /**
     * Builds a new {@link CheckTokenRequest CheckTokenRequest}.
     * @return An immutable instance of CheckTokenRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CheckTokenRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CheckTokenRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_TOKEN) != 0) attributes.add("token");
      if ((initBits & INIT_BIT_CLIENT_ID) != 0) attributes.add("clientId");
      if ((initBits & INIT_BIT_CLIENT_SECRET) != 0) attributes.add("clientSecret");
      return "Cannot build CheckTokenRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
