package org.cloudfoundry.uaa.tokens;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link _CheckTokenResponse}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code CheckTokenResponse.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_CheckTokenResponse"})
public final class CheckTokenResponse extends org.cloudfoundry.uaa.tokens._CheckTokenResponse {
  private final List<String> audiences;
  private final List<String> authorities;
  private final Long authorizationTime;
  private final String authorizedParty;
  private final String cid;
  private final String clientId;
  private final String email;
  private final Long expirationTime;
  private final String grantType;
  private final Long issuedAt;
  private final String issuer;
  private final String jwtId;
  private final String origin;
  private final Boolean revocable;
  private final String revocationSignature;
  private final List<String> scopes;
  private final String subject;
  private final String userId;
  private final String userName;
  private final String zoneId;

  private CheckTokenResponse(CheckTokenResponse.Builder builder) {
    this.audiences = createUnmodifiableList(true, builder.audiences);
    this.authorities = createUnmodifiableList(true, builder.authorities);
    this.authorizationTime = builder.authorizationTime;
    this.authorizedParty = builder.authorizedParty;
    this.cid = builder.cid;
    this.clientId = builder.clientId;
    this.email = builder.email;
    this.expirationTime = builder.expirationTime;
    this.grantType = builder.grantType;
    this.issuedAt = builder.issuedAt;
    this.issuer = builder.issuer;
    this.jwtId = builder.jwtId;
    this.origin = builder.origin;
    this.revocable = builder.revocable;
    this.revocationSignature = builder.revocationSignature;
    this.scopes = createUnmodifiableList(true, builder.scopes);
    this.subject = builder.subject;
    this.userId = builder.userId;
    this.userName = builder.userName;
    this.zoneId = builder.zoneId;
  }

  /**
   * The audience claim
   */
  @JsonProperty("aud")
  @Override
  public List<String> getAudiences() {
    return audiences;
  }

  /**
   * The authorities
   */
  @JsonProperty("authorities")
  @Override
  public List<String> getAuthorities() {
    return authorities;
  }

  /**
   * The auth time
   */
  @JsonProperty("auth_time")
  @Override
  public Long getAuthorizationTime() {
    return authorizationTime;
  }

  /**
   * The authorized party
   */
  @JsonProperty("azp")
  @Override
  public String getAuthorizedParty() {
    return authorizedParty;
  }

  /**
   * The cid
   */
  @JsonProperty("cid")
  @Override
  public String getCid() {
    return cid;
  }

  /**
   * The client id
   */
  @JsonProperty("client_id")
  @Override
  public String getClientId() {
    return clientId;
  }

  /**
   * The email
   */
  @JsonProperty("email")
  @Override
  public String getEmail() {
    return email;
  }

  /**
   * The expiration time claim
   */
  @JsonProperty("exp")
  @Override
  public Long getExpirationTime() {
    return expirationTime;
  }

  /**
   * The grant type
   */
  @JsonProperty("grant_type")
  @Override
  public String getGrantType() {
    return grantType;
  }

  /**
   * The issued at claim
   */
  @JsonProperty("iat")
  @Override
  public Long getIssuedAt() {
    return issuedAt;
  }

  /**
   * The issuer claim
   */
  @JsonProperty("iss")
  @Override
  public String getIssuer() {
    return issuer;
  }

  /**
   * The jwt id claim
   */
  @JsonProperty("jti")
  @Override
  public String getJwtId() {
    return jwtId;
  }

  /**
   * The origin
   */
  @JsonProperty("origin")
  @Override
  public String getOrigin() {
    return origin;
  }

  /**
   * Whether token is revocable
   */
  @JsonProperty("revocable")
  @Override
  public Boolean getRevocable() {
    return revocable;
  }

  /**
   * The revocation signature
   */
  @JsonProperty("rev_sig")
  @Override
  public String getRevocationSignature() {
    return revocationSignature;
  }

  /**
   * The scopes authorized by the user for this client
   */
  @JsonProperty("scope")
  @Override
  public List<String> getScopes() {
    return scopes;
  }

  /**
   * The subject claim
   */
  @JsonProperty("sub")
  @Override
  public String getSubject() {
    return subject;
  }

  /**
   * The user id
   */
  @JsonProperty("user_id")
  @Override
  public String getUserId() {
    return userId;
  }

  /**
   * The user name
   */
  @JsonProperty("user_name")
  @Override
  public String getUserName() {
    return userName;
  }

  /**
   * The zone id
   */
  @JsonProperty("zid")
  @Override
  public String getZoneId() {
    return zoneId;
  }

  /**
   * This instance is equal to all instances of {@code CheckTokenResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CheckTokenResponse
        && equalTo((CheckTokenResponse) another);
  }

  private boolean equalTo(CheckTokenResponse another) {
    return audiences.equals(another.audiences)
        && authorities.equals(another.authorities)
        && authorizationTime.equals(another.authorizationTime)
        && authorizedParty.equals(another.authorizedParty)
        && cid.equals(another.cid)
        && clientId.equals(another.clientId)
        && email.equals(another.email)
        && expirationTime.equals(another.expirationTime)
        && grantType.equals(another.grantType)
        && issuedAt.equals(another.issuedAt)
        && issuer.equals(another.issuer)
        && jwtId.equals(another.jwtId)
        && origin.equals(another.origin)
        && revocable.equals(another.revocable)
        && revocationSignature.equals(another.revocationSignature)
        && scopes.equals(another.scopes)
        && subject.equals(another.subject)
        && userId.equals(another.userId)
        && userName.equals(another.userName)
        && zoneId.equals(another.zoneId);
  }

  /**
   * Computes a hash code from attributes: {@code audiences}, {@code authorities}, {@code authorizationTime}, {@code authorizedParty}, {@code cid}, {@code clientId}, {@code email}, {@code expirationTime}, {@code grantType}, {@code issuedAt}, {@code issuer}, {@code jwtId}, {@code origin}, {@code revocable}, {@code revocationSignature}, {@code scopes}, {@code subject}, {@code userId}, {@code userName}, {@code zoneId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + audiences.hashCode();
    h = h * 17 + authorities.hashCode();
    h = h * 17 + authorizationTime.hashCode();
    h = h * 17 + authorizedParty.hashCode();
    h = h * 17 + cid.hashCode();
    h = h * 17 + clientId.hashCode();
    h = h * 17 + email.hashCode();
    h = h * 17 + expirationTime.hashCode();
    h = h * 17 + grantType.hashCode();
    h = h * 17 + issuedAt.hashCode();
    h = h * 17 + issuer.hashCode();
    h = h * 17 + jwtId.hashCode();
    h = h * 17 + origin.hashCode();
    h = h * 17 + revocable.hashCode();
    h = h * 17 + revocationSignature.hashCode();
    h = h * 17 + scopes.hashCode();
    h = h * 17 + subject.hashCode();
    h = h * 17 + userId.hashCode();
    h = h * 17 + userName.hashCode();
    h = h * 17 + zoneId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CheckTokenResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CheckTokenResponse{"
        + "audiences=" + audiences
        + ", authorities=" + authorities
        + ", authorizationTime=" + authorizationTime
        + ", authorizedParty=" + authorizedParty
        + ", cid=" + cid
        + ", clientId=" + clientId
        + ", email=" + email
        + ", expirationTime=" + expirationTime
        + ", grantType=" + grantType
        + ", issuedAt=" + issuedAt
        + ", issuer=" + issuer
        + ", jwtId=" + jwtId
        + ", origin=" + origin
        + ", revocable=" + revocable
        + ", revocationSignature=" + revocationSignature
        + ", scopes=" + scopes
        + ", subject=" + subject
        + ", userId=" + userId
        + ", userName=" + userName
        + ", zoneId=" + zoneId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.tokens._CheckTokenResponse {
    List<String> audiences = Collections.emptyList();
    List<String> authorities = Collections.emptyList();
    Long authorizationTime;
    String authorizedParty;
    String cid;
    String clientId;
    String email;
    Long expirationTime;
    String grantType;
    Long issuedAt;
    String issuer;
    String jwtId;
    String origin;
    Boolean revocable;
    String revocationSignature;
    List<String> scopes = Collections.emptyList();
    String subject;
    String userId;
    String userName;
    String zoneId;
    @JsonProperty("aud")
    public void setAudiences(List<String> audiences) {
      this.audiences = audiences;
    }
    @JsonProperty("authorities")
    public void setAuthorities(List<String> authorities) {
      this.authorities = authorities;
    }
    @JsonProperty("auth_time")
    public void setAuthorizationTime(Long authorizationTime) {
      this.authorizationTime = authorizationTime;
    }
    @JsonProperty("azp")
    public void setAuthorizedParty(String authorizedParty) {
      this.authorizedParty = authorizedParty;
    }
    @JsonProperty("cid")
    public void setCid(String cid) {
      this.cid = cid;
    }
    @JsonProperty("client_id")
    public void setClientId(String clientId) {
      this.clientId = clientId;
    }
    @JsonProperty("email")
    public void setEmail(String email) {
      this.email = email;
    }
    @JsonProperty("exp")
    public void setExpirationTime(Long expirationTime) {
      this.expirationTime = expirationTime;
    }
    @JsonProperty("grant_type")
    public void setGrantType(String grantType) {
      this.grantType = grantType;
    }
    @JsonProperty("iat")
    public void setIssuedAt(Long issuedAt) {
      this.issuedAt = issuedAt;
    }
    @JsonProperty("iss")
    public void setIssuer(String issuer) {
      this.issuer = issuer;
    }
    @JsonProperty("jti")
    public void setJwtId(String jwtId) {
      this.jwtId = jwtId;
    }
    @JsonProperty("origin")
    public void setOrigin(String origin) {
      this.origin = origin;
    }
    @JsonProperty("revocable")
    public void setRevocable(Boolean revocable) {
      this.revocable = revocable;
    }
    @JsonProperty("rev_sig")
    public void setRevocationSignature(String revocationSignature) {
      this.revocationSignature = revocationSignature;
    }
    @JsonProperty("scope")
    public void setScopes(List<String> scopes) {
      this.scopes = scopes;
    }
    @JsonProperty("sub")
    public void setSubject(String subject) {
      this.subject = subject;
    }
    @JsonProperty("user_id")
    public void setUserId(String userId) {
      this.userId = userId;
    }
    @JsonProperty("user_name")
    public void setUserName(String userName) {
      this.userName = userName;
    }
    @JsonProperty("zid")
    public void setZoneId(String zoneId) {
      this.zoneId = zoneId;
    }
    @Override
    public List<String> getAudiences() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getAuthorities() { throw new UnsupportedOperationException(); }
    @Override
    public Long getAuthorizationTime() { throw new UnsupportedOperationException(); }
    @Override
    public String getAuthorizedParty() { throw new UnsupportedOperationException(); }
    @Override
    public String getCid() { throw new UnsupportedOperationException(); }
    @Override
    public String getClientId() { throw new UnsupportedOperationException(); }
    @Override
    public String getEmail() { throw new UnsupportedOperationException(); }
    @Override
    public Long getExpirationTime() { throw new UnsupportedOperationException(); }
    @Override
    public String getGrantType() { throw new UnsupportedOperationException(); }
    @Override
    public Long getIssuedAt() { throw new UnsupportedOperationException(); }
    @Override
    public String getIssuer() { throw new UnsupportedOperationException(); }
    @Override
    public String getJwtId() { throw new UnsupportedOperationException(); }
    @Override
    public String getOrigin() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getRevocable() { throw new UnsupportedOperationException(); }
    @Override
    public String getRevocationSignature() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getScopes() { throw new UnsupportedOperationException(); }
    @Override
    public String getSubject() { throw new UnsupportedOperationException(); }
    @Override
    public String getUserId() { throw new UnsupportedOperationException(); }
    @Override
    public String getUserName() { throw new UnsupportedOperationException(); }
    @Override
    public String getZoneId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static CheckTokenResponse fromJson(Json json) {
    CheckTokenResponse.Builder builder = CheckTokenResponse.builder();
    if (json.audiences != null) {
      builder.addAllAudiences(json.audiences);
    }
    if (json.authorities != null) {
      builder.addAllAuthorities(json.authorities);
    }
    if (json.authorizationTime != null) {
      builder.authorizationTime(json.authorizationTime);
    }
    if (json.authorizedParty != null) {
      builder.authorizedParty(json.authorizedParty);
    }
    if (json.cid != null) {
      builder.cid(json.cid);
    }
    if (json.clientId != null) {
      builder.clientId(json.clientId);
    }
    if (json.email != null) {
      builder.email(json.email);
    }
    if (json.expirationTime != null) {
      builder.expirationTime(json.expirationTime);
    }
    if (json.grantType != null) {
      builder.grantType(json.grantType);
    }
    if (json.issuedAt != null) {
      builder.issuedAt(json.issuedAt);
    }
    if (json.issuer != null) {
      builder.issuer(json.issuer);
    }
    if (json.jwtId != null) {
      builder.jwtId(json.jwtId);
    }
    if (json.origin != null) {
      builder.origin(json.origin);
    }
    if (json.revocable != null) {
      builder.revocable(json.revocable);
    }
    if (json.revocationSignature != null) {
      builder.revocationSignature(json.revocationSignature);
    }
    if (json.scopes != null) {
      builder.addAllScopes(json.scopes);
    }
    if (json.subject != null) {
      builder.subject(json.subject);
    }
    if (json.userId != null) {
      builder.userId(json.userId);
    }
    if (json.userName != null) {
      builder.userName(json.userName);
    }
    if (json.zoneId != null) {
      builder.zoneId(json.zoneId);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link CheckTokenResponse CheckTokenResponse}.
   * @return A new CheckTokenResponse builder
   */
  public static CheckTokenResponse.Builder builder() {
    return new CheckTokenResponse.Builder();
  }

  /**
   * Builds instances of type {@link CheckTokenResponse CheckTokenResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_AUTHORIZATION_TIME = 0x1L;
    private static final long INIT_BIT_AUTHORIZED_PARTY = 0x2L;
    private static final long INIT_BIT_CID = 0x4L;
    private static final long INIT_BIT_CLIENT_ID = 0x8L;
    private static final long INIT_BIT_EMAIL = 0x10L;
    private static final long INIT_BIT_EXPIRATION_TIME = 0x20L;
    private static final long INIT_BIT_GRANT_TYPE = 0x40L;
    private static final long INIT_BIT_ISSUED_AT = 0x80L;
    private static final long INIT_BIT_ISSUER = 0x100L;
    private static final long INIT_BIT_JWT_ID = 0x200L;
    private static final long INIT_BIT_ORIGIN = 0x400L;
    private static final long INIT_BIT_REVOCABLE = 0x800L;
    private static final long INIT_BIT_REVOCATION_SIGNATURE = 0x1000L;
    private static final long INIT_BIT_SUBJECT = 0x2000L;
    private static final long INIT_BIT_USER_ID = 0x4000L;
    private static final long INIT_BIT_USER_NAME = 0x8000L;
    private static final long INIT_BIT_ZONE_ID = 0x10000L;
    private long initBits = 0x1ffffL;

    private List<String> audiences = new ArrayList<String>();
    private List<String> authorities = new ArrayList<String>();
    private Long authorizationTime;
    private String authorizedParty;
    private String cid;
    private String clientId;
    private String email;
    private Long expirationTime;
    private String grantType;
    private Long issuedAt;
    private String issuer;
    private String jwtId;
    private String origin;
    private Boolean revocable;
    private String revocationSignature;
    private List<String> scopes = new ArrayList<String>();
    private String subject;
    private String userId;
    private String userName;
    private String zoneId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CheckTokenResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CheckTokenResponse instance) {
      return from((_CheckTokenResponse) instance);
    }

    /**
     * Copy abstract value type {@code _CheckTokenResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CheckTokenResponse instance) {
      Objects.requireNonNull(instance, "instance");
      addAllAudiences(instance.getAudiences());
      addAllAuthorities(instance.getAuthorities());
      authorizationTime(instance.getAuthorizationTime());
      authorizedParty(instance.getAuthorizedParty());
      cid(instance.getCid());
      clientId(instance.getClientId());
      email(instance.getEmail());
      expirationTime(instance.getExpirationTime());
      grantType(instance.getGrantType());
      issuedAt(instance.getIssuedAt());
      issuer(instance.getIssuer());
      jwtId(instance.getJwtId());
      origin(instance.getOrigin());
      revocable(instance.getRevocable());
      revocationSignature(instance.getRevocationSignature());
      addAllScopes(instance.getScopes());
      subject(instance.getSubject());
      userId(instance.getUserId());
      userName(instance.getUserName());
      zoneId(instance.getZoneId());
      return this;
    }

    /**
     * Adds one element to {@link _CheckTokenResponse#getAudiences() audiences} list.
     * @param element A audiences element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder audience(String element) {
      this.audiences.add(Objects.requireNonNull(element, "audiences element"));
      return this;
    }

    /**
     * Adds elements to {@link _CheckTokenResponse#getAudiences() audiences} list.
     * @param elements An array of audiences elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder audience(String... elements) {
      for (String element : elements) {
        this.audiences.add(Objects.requireNonNull(element, "audiences element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _CheckTokenResponse#getAudiences() audiences} list.
     * @param elements An iterable of audiences elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder audiences(Iterable<String> elements) {
      this.audiences.clear();
      return addAllAudiences(elements);
    }

    /**
     * Adds elements to {@link _CheckTokenResponse#getAudiences() audiences} list.
     * @param elements An iterable of audiences elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAudiences(Iterable<String> elements) {
      for (String element : elements) {
        this.audiences.add(Objects.requireNonNull(element, "audiences element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link _CheckTokenResponse#getAuthorities() authorities} list.
     * @param element A authorities element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder authority(String element) {
      this.authorities.add(Objects.requireNonNull(element, "authorities element"));
      return this;
    }

    /**
     * Adds elements to {@link _CheckTokenResponse#getAuthorities() authorities} list.
     * @param elements An array of authorities elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder authority(String... elements) {
      for (String element : elements) {
        this.authorities.add(Objects.requireNonNull(element, "authorities element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _CheckTokenResponse#getAuthorities() authorities} list.
     * @param elements An iterable of authorities elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder authorities(Iterable<String> elements) {
      this.authorities.clear();
      return addAllAuthorities(elements);
    }

    /**
     * Adds elements to {@link _CheckTokenResponse#getAuthorities() authorities} list.
     * @param elements An iterable of authorities elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAuthorities(Iterable<String> elements) {
      for (String element : elements) {
        this.authorities.add(Objects.requireNonNull(element, "authorities element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _CheckTokenResponse#getAuthorizationTime() authorizationTime} attribute.
     * @param authorizationTime The value for authorizationTime 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder authorizationTime(Long authorizationTime) {
      this.authorizationTime = Objects.requireNonNull(authorizationTime, "authorizationTime");
      initBits &= ~INIT_BIT_AUTHORIZATION_TIME;
      return this;
    }

    /**
     * Initializes the value for the {@link _CheckTokenResponse#getAuthorizedParty() authorizedParty} attribute.
     * @param authorizedParty The value for authorizedParty 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder authorizedParty(String authorizedParty) {
      this.authorizedParty = Objects.requireNonNull(authorizedParty, "authorizedParty");
      initBits &= ~INIT_BIT_AUTHORIZED_PARTY;
      return this;
    }

    /**
     * Initializes the value for the {@link _CheckTokenResponse#getCid() cid} attribute.
     * @param cid The value for cid 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder cid(String cid) {
      this.cid = Objects.requireNonNull(cid, "cid");
      initBits &= ~INIT_BIT_CID;
      return this;
    }

    /**
     * Initializes the value for the {@link _CheckTokenResponse#getClientId() clientId} attribute.
     * @param clientId The value for clientId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clientId(String clientId) {
      this.clientId = Objects.requireNonNull(clientId, "clientId");
      initBits &= ~INIT_BIT_CLIENT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _CheckTokenResponse#getEmail() email} attribute.
     * @param email The value for email 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder email(String email) {
      this.email = Objects.requireNonNull(email, "email");
      initBits &= ~INIT_BIT_EMAIL;
      return this;
    }

    /**
     * Initializes the value for the {@link _CheckTokenResponse#getExpirationTime() expirationTime} attribute.
     * @param expirationTime The value for expirationTime 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder expirationTime(Long expirationTime) {
      this.expirationTime = Objects.requireNonNull(expirationTime, "expirationTime");
      initBits &= ~INIT_BIT_EXPIRATION_TIME;
      return this;
    }

    /**
     * Initializes the value for the {@link _CheckTokenResponse#getGrantType() grantType} attribute.
     * @param grantType The value for grantType 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder grantType(String grantType) {
      this.grantType = Objects.requireNonNull(grantType, "grantType");
      initBits &= ~INIT_BIT_GRANT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link _CheckTokenResponse#getIssuedAt() issuedAt} attribute.
     * @param issuedAt The value for issuedAt 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder issuedAt(Long issuedAt) {
      this.issuedAt = Objects.requireNonNull(issuedAt, "issuedAt");
      initBits &= ~INIT_BIT_ISSUED_AT;
      return this;
    }

    /**
     * Initializes the value for the {@link _CheckTokenResponse#getIssuer() issuer} attribute.
     * @param issuer The value for issuer 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder issuer(String issuer) {
      this.issuer = Objects.requireNonNull(issuer, "issuer");
      initBits &= ~INIT_BIT_ISSUER;
      return this;
    }

    /**
     * Initializes the value for the {@link _CheckTokenResponse#getJwtId() jwtId} attribute.
     * @param jwtId The value for jwtId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder jwtId(String jwtId) {
      this.jwtId = Objects.requireNonNull(jwtId, "jwtId");
      initBits &= ~INIT_BIT_JWT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _CheckTokenResponse#getOrigin() origin} attribute.
     * @param origin The value for origin 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder origin(String origin) {
      this.origin = Objects.requireNonNull(origin, "origin");
      initBits &= ~INIT_BIT_ORIGIN;
      return this;
    }

    /**
     * Initializes the value for the {@link _CheckTokenResponse#getRevocable() revocable} attribute.
     * @param revocable The value for revocable 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder revocable(Boolean revocable) {
      this.revocable = Objects.requireNonNull(revocable, "revocable");
      initBits &= ~INIT_BIT_REVOCABLE;
      return this;
    }

    /**
     * Initializes the value for the {@link _CheckTokenResponse#getRevocationSignature() revocationSignature} attribute.
     * @param revocationSignature The value for revocationSignature 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder revocationSignature(String revocationSignature) {
      this.revocationSignature = Objects.requireNonNull(revocationSignature, "revocationSignature");
      initBits &= ~INIT_BIT_REVOCATION_SIGNATURE;
      return this;
    }

    /**
     * Adds one element to {@link _CheckTokenResponse#getScopes() scopes} list.
     * @param element A scopes element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder scope(String element) {
      this.scopes.add(Objects.requireNonNull(element, "scopes element"));
      return this;
    }

    /**
     * Adds elements to {@link _CheckTokenResponse#getScopes() scopes} list.
     * @param elements An array of scopes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder scope(String... elements) {
      for (String element : elements) {
        this.scopes.add(Objects.requireNonNull(element, "scopes element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _CheckTokenResponse#getScopes() scopes} list.
     * @param elements An iterable of scopes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder scopes(Iterable<String> elements) {
      this.scopes.clear();
      return addAllScopes(elements);
    }

    /**
     * Adds elements to {@link _CheckTokenResponse#getScopes() scopes} list.
     * @param elements An iterable of scopes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllScopes(Iterable<String> elements) {
      for (String element : elements) {
        this.scopes.add(Objects.requireNonNull(element, "scopes element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _CheckTokenResponse#getSubject() subject} attribute.
     * @param subject The value for subject 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder subject(String subject) {
      this.subject = Objects.requireNonNull(subject, "subject");
      initBits &= ~INIT_BIT_SUBJECT;
      return this;
    }

    /**
     * Initializes the value for the {@link _CheckTokenResponse#getUserId() userId} attribute.
     * @param userId The value for userId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userId(String userId) {
      this.userId = Objects.requireNonNull(userId, "userId");
      initBits &= ~INIT_BIT_USER_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _CheckTokenResponse#getUserName() userName} attribute.
     * @param userName The value for userName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userName(String userName) {
      this.userName = Objects.requireNonNull(userName, "userName");
      initBits &= ~INIT_BIT_USER_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link _CheckTokenResponse#getZoneId() zoneId} attribute.
     * @param zoneId The value for zoneId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder zoneId(String zoneId) {
      this.zoneId = Objects.requireNonNull(zoneId, "zoneId");
      initBits &= ~INIT_BIT_ZONE_ID;
      return this;
    }

    /**
     * Builds a new {@link CheckTokenResponse CheckTokenResponse}.
     * @return An immutable instance of CheckTokenResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CheckTokenResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CheckTokenResponse(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_AUTHORIZATION_TIME) != 0) attributes.add("authorizationTime");
      if ((initBits & INIT_BIT_AUTHORIZED_PARTY) != 0) attributes.add("authorizedParty");
      if ((initBits & INIT_BIT_CID) != 0) attributes.add("cid");
      if ((initBits & INIT_BIT_CLIENT_ID) != 0) attributes.add("clientId");
      if ((initBits & INIT_BIT_EMAIL) != 0) attributes.add("email");
      if ((initBits & INIT_BIT_EXPIRATION_TIME) != 0) attributes.add("expirationTime");
      if ((initBits & INIT_BIT_GRANT_TYPE) != 0) attributes.add("grantType");
      if ((initBits & INIT_BIT_ISSUED_AT) != 0) attributes.add("issuedAt");
      if ((initBits & INIT_BIT_ISSUER) != 0) attributes.add("issuer");
      if ((initBits & INIT_BIT_JWT_ID) != 0) attributes.add("jwtId");
      if ((initBits & INIT_BIT_ORIGIN) != 0) attributes.add("origin");
      if ((initBits & INIT_BIT_REVOCABLE) != 0) attributes.add("revocable");
      if ((initBits & INIT_BIT_REVOCATION_SIGNATURE) != 0) attributes.add("revocationSignature");
      if ((initBits & INIT_BIT_SUBJECT) != 0) attributes.add("subject");
      if ((initBits & INIT_BIT_USER_ID) != 0) attributes.add("userId");
      if ((initBits & INIT_BIT_USER_NAME) != 0) attributes.add("userName");
      if ((initBits & INIT_BIT_ZONE_ID) != 0) attributes.add("zoneId");
      return "Cannot build CheckTokenResponse, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
