package org.cloudfoundry.uaa.tokens;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.BasicAuthorized;

/**
 * Immutable implementation of {@link _GetTokenByOneTimePasscodeRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code GetTokenByOneTimePasscodeRequest.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_GetTokenByOneTimePasscodeRequest"})
public final class GetTokenByOneTimePasscodeRequest
    extends org.cloudfoundry.uaa.tokens._GetTokenByOneTimePasscodeRequest {
  private final String passcode;
  private final @Nullable TokenFormat tokenFormat;
  private final String clientId;
  private final String clientSecret;

  private GetTokenByOneTimePasscodeRequest(GetTokenByOneTimePasscodeRequest.Builder builder) {
    this.passcode = builder.passcode;
    this.tokenFormat = builder.tokenFormat;
    this.clientId = builder.clientId;
    this.clientSecret = builder.clientSecret;
  }

  /**
   * The passcode
   */
  @Override
  public String getPasscode() {
    return passcode;
  }

  /**
   * The token format
   */
  @Override
  public @Nullable TokenFormat getTokenFormat() {
    return tokenFormat;
  }

  /**
   * The client id
   */
  @Override
  public String getClientId() {
    return clientId;
  }

  /**
   * The client secret
   */
  @Override
  public String getClientSecret() {
    return clientSecret;
  }

  /**
   * This instance is equal to all instances of {@code GetTokenByOneTimePasscodeRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetTokenByOneTimePasscodeRequest
        && equalTo((GetTokenByOneTimePasscodeRequest) another);
  }

  private boolean equalTo(GetTokenByOneTimePasscodeRequest another) {
    return passcode.equals(another.passcode)
        && Objects.equals(tokenFormat, another.tokenFormat)
        && clientId.equals(another.clientId)
        && clientSecret.equals(another.clientSecret);
  }

  /**
   * Computes a hash code from attributes: {@code passcode}, {@code tokenFormat}, {@code clientId}, {@code clientSecret}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + passcode.hashCode();
    h = h * 17 + Objects.hashCode(tokenFormat);
    h = h * 17 + clientId.hashCode();
    h = h * 17 + clientSecret.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetTokenByOneTimePasscodeRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetTokenByOneTimePasscodeRequest{"
        + "passcode=" + passcode
        + ", tokenFormat=" + tokenFormat
        + ", clientId=" + clientId
        + ", clientSecret=" + clientSecret
        + "}";
  }

  /**
   * Creates a builder for {@link GetTokenByOneTimePasscodeRequest GetTokenByOneTimePasscodeRequest}.
   * @return A new GetTokenByOneTimePasscodeRequest builder
   */
  public static GetTokenByOneTimePasscodeRequest.Builder builder() {
    return new GetTokenByOneTimePasscodeRequest.Builder();
  }

  /**
   * Builds instances of type {@link GetTokenByOneTimePasscodeRequest GetTokenByOneTimePasscodeRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_PASSCODE = 0x1L;
    private static final long INIT_BIT_CLIENT_ID = 0x2L;
    private static final long INIT_BIT_CLIENT_SECRET = 0x4L;
    private long initBits = 0x7L;

    private String passcode;
    private TokenFormat tokenFormat;
    private String clientId;
    private String clientSecret;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.BasicAuthorized} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(BasicAuthorized instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetTokenByOneTimePasscodeRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetTokenByOneTimePasscodeRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _GetTokenByOneTimePasscodeRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetTokenByOneTimePasscodeRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof BasicAuthorized) {
        BasicAuthorized instance = (BasicAuthorized) object;
        clientSecret(instance.getClientSecret());
        clientId(instance.getClientId());
      }
      if (object instanceof org.cloudfoundry.uaa.tokens._GetTokenByOneTimePasscodeRequest) {
        org.cloudfoundry.uaa.tokens._GetTokenByOneTimePasscodeRequest instance = (org.cloudfoundry.uaa.tokens._GetTokenByOneTimePasscodeRequest) object;
        TokenFormat tokenFormatValue = instance.getTokenFormat();
        if (tokenFormatValue != null) {
          tokenFormat(tokenFormatValue);
        }
        passcode(instance.getPasscode());
      }
    }

    /**
     * Initializes the value for the {@link _GetTokenByOneTimePasscodeRequest#getPasscode() passcode} attribute.
     * @param passcode The value for passcode 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder passcode(String passcode) {
      this.passcode = Objects.requireNonNull(passcode, "passcode");
      initBits &= ~INIT_BIT_PASSCODE;
      return this;
    }

    /**
     * Initializes the value for the {@link _GetTokenByOneTimePasscodeRequest#getTokenFormat() tokenFormat} attribute.
     * @param tokenFormat The value for tokenFormat (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tokenFormat(@Nullable TokenFormat tokenFormat) {
      this.tokenFormat = tokenFormat;
      return this;
    }

    /**
     * Initializes the value for the {@link _GetTokenByOneTimePasscodeRequest#getClientId() clientId} attribute.
     * @param clientId The value for clientId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clientId(String clientId) {
      this.clientId = Objects.requireNonNull(clientId, "clientId");
      initBits &= ~INIT_BIT_CLIENT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _GetTokenByOneTimePasscodeRequest#getClientSecret() clientSecret} attribute.
     * @param clientSecret The value for clientSecret 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clientSecret(String clientSecret) {
      this.clientSecret = Objects.requireNonNull(clientSecret, "clientSecret");
      initBits &= ~INIT_BIT_CLIENT_SECRET;
      return this;
    }

    /**
     * Builds a new {@link GetTokenByOneTimePasscodeRequest GetTokenByOneTimePasscodeRequest}.
     * @return An immutable instance of GetTokenByOneTimePasscodeRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetTokenByOneTimePasscodeRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetTokenByOneTimePasscodeRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_PASSCODE) != 0) attributes.add("passcode");
      if ((initBits & INIT_BIT_CLIENT_ID) != 0) attributes.add("clientId");
      if ((initBits & INIT_BIT_CLIENT_SECRET) != 0) attributes.add("clientSecret");
      return "Cannot build GetTokenByOneTimePasscodeRequest, some of required attributes are not set " + attributes;
    }
  }
}
