package org.cloudfoundry.uaa.users;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.Versioned;

/**
 * Immutable implementation of {@link _VerifyUserRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code VerifyUserRequest.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_VerifyUserRequest"})
public final class VerifyUserRequest extends org.cloudfoundry.uaa.users._VerifyUserRequest {
  private final String userId;
  private final @Nullable String version;

  private VerifyUserRequest(VerifyUserRequest.Builder builder) {
    this.userId = builder.userId;
    this.version = builder.version;
  }

  /**
   * The user id
   */
  @Override
  public String getUserId() {
    return userId;
  }

  /**
   * Returns the version
   */
  @Override
  public @Nullable String getVersion() {
    return version;
  }

  /**
   * This instance is equal to all instances of {@code VerifyUserRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof VerifyUserRequest
        && equalTo((VerifyUserRequest) another);
  }

  private boolean equalTo(VerifyUserRequest another) {
    return userId.equals(another.userId)
        && Objects.equals(version, another.version);
  }

  /**
   * Computes a hash code from attributes: {@code userId}, {@code version}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + userId.hashCode();
    h = h * 17 + Objects.hashCode(version);
    return h;
  }

  /**
   * Prints the immutable value {@code VerifyUserRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "VerifyUserRequest{"
        + "userId=" + userId
        + ", version=" + version
        + "}";
  }

  /**
   * Creates a builder for {@link VerifyUserRequest VerifyUserRequest}.
   * @return A new VerifyUserRequest builder
   */
  public static VerifyUserRequest.Builder builder() {
    return new VerifyUserRequest.Builder();
  }

  /**
   * Builds instances of type {@link VerifyUserRequest VerifyUserRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_USER_ID = 0x1L;
    private long initBits = 0x1L;

    private String userId;
    private String version;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.Versioned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Versioned instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code VerifyUserRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(VerifyUserRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _VerifyUserRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_VerifyUserRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof Versioned) {
        Versioned instance = (Versioned) object;
        String versionValue = instance.getVersion();
        if (versionValue != null) {
          version(versionValue);
        }
      }
      if (object instanceof org.cloudfoundry.uaa.users._VerifyUserRequest) {
        org.cloudfoundry.uaa.users._VerifyUserRequest instance = (org.cloudfoundry.uaa.users._VerifyUserRequest) object;
        userId(instance.getUserId());
      }
    }

    /**
     * Initializes the value for the {@link _VerifyUserRequest#getUserId() userId} attribute.
     * @param userId The value for userId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userId(String userId) {
      this.userId = Objects.requireNonNull(userId, "userId");
      initBits &= ~INIT_BIT_USER_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _VerifyUserRequest#getVersion() version} attribute.
     * @param version The value for version (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder version(@Nullable String version) {
      this.version = version;
      return this;
    }

    /**
     * Builds a new {@link VerifyUserRequest VerifyUserRequest}.
     * @return An immutable instance of VerifyUserRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public VerifyUserRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new VerifyUserRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_USER_ID) != 0) attributes.add("userId");
      return "Cannot build VerifyUserRequest, some of required attributes are not set " + attributes;
    }
  }
}
