/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.applications;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.applications._Usage;

public final class Usage
extends _Usage {
    @Nullable
    private final Double cpu;
    @Nullable
    private final Long disk;
    @Nullable
    private final Long memory;
    @Nullable
    private final String time;

    private Usage(Builder builder) {
        this.cpu = builder.cpu;
        this.disk = builder.disk;
        this.memory = builder.memory;
        this.time = builder.time;
    }

    @Override
    @JsonProperty(value="cpu")
    @Nullable
    public Double getCpu() {
        return this.cpu;
    }

    @Override
    @JsonProperty(value="disk")
    @Nullable
    public Long getDisk() {
        return this.disk;
    }

    @Override
    @JsonProperty(value="mem")
    @Nullable
    public Long getMemory() {
        return this.memory;
    }

    @Override
    @JsonProperty(value="time")
    @Nullable
    public String getTime() {
        return this.time;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Usage && this.equalTo((Usage)another);
    }

    private boolean equalTo(Usage another) {
        return Objects.equals(this.cpu, another.cpu) && Objects.equals(this.disk, another.disk) && Objects.equals(this.memory, another.memory) && Objects.equals(this.time, another.time);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.cpu);
        h = h * 17 + Objects.hashCode(this.disk);
        h = h * 17 + Objects.hashCode(this.memory);
        h = h * 17 + Objects.hashCode(this.time);
        return h;
    }

    public String toString() {
        return "Usage{cpu=" + this.cpu + ", disk=" + this.disk + ", memory=" + this.memory + ", time=" + this.time + "}";
    }

    @Deprecated
    @JsonCreator
    static Usage fromJson(Json json) {
        Builder builder = Usage.builder();
        if (json.cpu != null) {
            builder.cpu(json.cpu);
        }
        if (json.disk != null) {
            builder.disk(json.disk);
        }
        if (json.memory != null) {
            builder.memory(json.memory);
        }
        if (json.time != null) {
            builder.time(json.time);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Double cpu;
        private Long disk;
        private Long memory;
        private String time;

        private Builder() {
        }

        public final Builder from(Usage instance) {
            return this.from((_Usage)instance);
        }

        final Builder from(_Usage instance) {
            String timeValue;
            Long memoryValue;
            Long diskValue;
            Objects.requireNonNull(instance, "instance");
            Double cpuValue = instance.getCpu();
            if (cpuValue != null) {
                this.cpu(cpuValue);
            }
            if ((diskValue = instance.getDisk()) != null) {
                this.disk(diskValue);
            }
            if ((memoryValue = instance.getMemory()) != null) {
                this.memory(memoryValue);
            }
            if ((timeValue = instance.getTime()) != null) {
                this.time(timeValue);
            }
            return this;
        }

        public final Builder cpu(@Nullable Double cpu) {
            this.cpu = cpu;
            return this;
        }

        public final Builder disk(@Nullable Long disk) {
            this.disk = disk;
            return this;
        }

        public final Builder memory(@Nullable Long memory) {
            this.memory = memory;
            return this;
        }

        public final Builder time(@Nullable String time) {
            this.time = time;
            return this;
        }

        public Usage build() {
            return new Usage(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _Usage {
        Double cpu;
        Long disk;
        Long memory;
        String time;

        Json() {
        }

        @JsonProperty(value="cpu")
        public void setCpu(@Nullable Double cpu) {
            this.cpu = cpu;
        }

        @JsonProperty(value="disk")
        public void setDisk(@Nullable Long disk) {
            this.disk = disk;
        }

        @JsonProperty(value="mem")
        public void setMemory(@Nullable Long memory) {
            this.memory = memory;
        }

        @JsonProperty(value="time")
        public void setTime(@Nullable String time) {
            this.time = time;
        }

        @Override
        public Double getCpu() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long getDisk() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long getMemory() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTime() {
            throw new UnsupportedOperationException();
        }
    }
}

