/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.organizations;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.client.v2.organizations._RemoveOrganizationAuditorRequest;

public final class RemoveOrganizationAuditorRequest
extends _RemoveOrganizationAuditorRequest {
    private final String auditorId;
    private final String organizationId;

    private RemoveOrganizationAuditorRequest(Builder builder) {
        this.auditorId = builder.auditorId;
        this.organizationId = builder.organizationId;
    }

    @Override
    public String getAuditorId() {
        return this.auditorId;
    }

    @Override
    public String getOrganizationId() {
        return this.organizationId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof RemoveOrganizationAuditorRequest && this.equalTo((RemoveOrganizationAuditorRequest)another);
    }

    private boolean equalTo(RemoveOrganizationAuditorRequest another) {
        return this.auditorId.equals(another.auditorId) && this.organizationId.equals(another.organizationId);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.auditorId.hashCode();
        h = h * 17 + this.organizationId.hashCode();
        return h;
    }

    public String toString() {
        return "RemoveOrganizationAuditorRequest{auditorId=" + this.auditorId + ", organizationId=" + this.organizationId + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_AUDITOR_ID = 1L;
        private static final long INIT_BIT_ORGANIZATION_ID = 2L;
        private long initBits = 3L;
        private String auditorId;
        private String organizationId;

        private Builder() {
        }

        public final Builder from(RemoveOrganizationAuditorRequest instance) {
            return this.from((_RemoveOrganizationAuditorRequest)instance);
        }

        final Builder from(_RemoveOrganizationAuditorRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.auditorId(instance.getAuditorId());
            this.organizationId(instance.getOrganizationId());
            return this;
        }

        public final Builder auditorId(String auditorId) {
            this.auditorId = Objects.requireNonNull(auditorId, "auditorId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder organizationId(String organizationId) {
            this.organizationId = Objects.requireNonNull(organizationId, "organizationId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public RemoveOrganizationAuditorRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new RemoveOrganizationAuditorRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("auditorId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("organizationId");
            }
            return "Cannot build RemoveOrganizationAuditorRequest, some of required attributes are not set " + attributes;
        }
    }
}

