/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.privatedomains;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.client.v2.privatedomains._CreatePrivateDomainRequest;

public final class CreatePrivateDomainRequest
extends _CreatePrivateDomainRequest {
    private final String name;
    private final String owningOrganizationId;

    private CreatePrivateDomainRequest(Builder builder) {
        this.name = builder.name;
        this.owningOrganizationId = builder.owningOrganizationId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getOwningOrganizationId() {
        return this.owningOrganizationId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CreatePrivateDomainRequest && this.equalTo((CreatePrivateDomainRequest)another);
    }

    private boolean equalTo(CreatePrivateDomainRequest another) {
        return this.name.equals(another.name) && this.owningOrganizationId.equals(another.owningOrganizationId);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.name.hashCode();
        h = h * 17 + this.owningOrganizationId.hashCode();
        return h;
    }

    public String toString() {
        return "CreatePrivateDomainRequest{name=" + this.name + ", owningOrganizationId=" + this.owningOrganizationId + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_OWNING_ORGANIZATION_ID = 2L;
        private long initBits = 3L;
        private String name;
        private String owningOrganizationId;

        private Builder() {
        }

        public final Builder from(CreatePrivateDomainRequest instance) {
            return this.from((_CreatePrivateDomainRequest)instance);
        }

        final Builder from(_CreatePrivateDomainRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.getName());
            this.owningOrganizationId(instance.getOwningOrganizationId());
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder owningOrganizationId(String owningOrganizationId) {
            this.owningOrganizationId = Objects.requireNonNull(owningOrganizationId, "owningOrganizationId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public CreatePrivateDomainRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CreatePrivateDomainRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("owningOrganizationId");
            }
            return "Cannot build CreatePrivateDomainRequest, some of required attributes are not set " + attributes;
        }
    }
}

