/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.routemappings;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.routemappings._RouteMappingEntity;

public final class RouteMappingEntity
extends _RouteMappingEntity {
    @Nullable
    private final String applicationId;
    @Nullable
    private final Integer applicationPort;
    @Nullable
    private final String applicationUrl;
    @Nullable
    private final String routeId;
    @Nullable
    private final String routeUrl;

    private RouteMappingEntity(Builder builder) {
        this.applicationId = builder.applicationId;
        this.applicationPort = builder.applicationPort;
        this.applicationUrl = builder.applicationUrl;
        this.routeId = builder.routeId;
        this.routeUrl = builder.routeUrl;
    }

    @Override
    @JsonProperty(value="app_guid")
    @Nullable
    public String getApplicationId() {
        return this.applicationId;
    }

    @Override
    @JsonProperty(value="app_port")
    @Nullable
    public Integer getApplicationPort() {
        return this.applicationPort;
    }

    @Override
    @JsonProperty(value="app_url")
    @Nullable
    public String getApplicationUrl() {
        return this.applicationUrl;
    }

    @Override
    @JsonProperty(value="route_guid")
    @Nullable
    public String getRouteId() {
        return this.routeId;
    }

    @Override
    @JsonProperty(value="route_url")
    @Nullable
    public String getRouteUrl() {
        return this.routeUrl;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof RouteMappingEntity && this.equalTo((RouteMappingEntity)another);
    }

    private boolean equalTo(RouteMappingEntity another) {
        return Objects.equals(this.applicationId, another.applicationId) && Objects.equals(this.applicationPort, another.applicationPort) && Objects.equals(this.applicationUrl, another.applicationUrl) && Objects.equals(this.routeId, another.routeId) && Objects.equals(this.routeUrl, another.routeUrl);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.applicationId);
        h = h * 17 + Objects.hashCode(this.applicationPort);
        h = h * 17 + Objects.hashCode(this.applicationUrl);
        h = h * 17 + Objects.hashCode(this.routeId);
        h = h * 17 + Objects.hashCode(this.routeUrl);
        return h;
    }

    public String toString() {
        return "RouteMappingEntity{applicationId=" + this.applicationId + ", applicationPort=" + this.applicationPort + ", applicationUrl=" + this.applicationUrl + ", routeId=" + this.routeId + ", routeUrl=" + this.routeUrl + "}";
    }

    @Deprecated
    @JsonCreator
    static RouteMappingEntity fromJson(Json json) {
        Builder builder = RouteMappingEntity.builder();
        if (json.applicationId != null) {
            builder.applicationId(json.applicationId);
        }
        if (json.applicationPort != null) {
            builder.applicationPort(json.applicationPort);
        }
        if (json.applicationUrl != null) {
            builder.applicationUrl(json.applicationUrl);
        }
        if (json.routeId != null) {
            builder.routeId(json.routeId);
        }
        if (json.routeUrl != null) {
            builder.routeUrl(json.routeUrl);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String applicationId;
        private Integer applicationPort;
        private String applicationUrl;
        private String routeId;
        private String routeUrl;

        private Builder() {
        }

        public final Builder from(RouteMappingEntity instance) {
            return this.from((_RouteMappingEntity)instance);
        }

        final Builder from(_RouteMappingEntity instance) {
            String routeUrlValue;
            String routeIdValue;
            String applicationUrlValue;
            Integer applicationPortValue;
            Objects.requireNonNull(instance, "instance");
            String applicationIdValue = instance.getApplicationId();
            if (applicationIdValue != null) {
                this.applicationId(applicationIdValue);
            }
            if ((applicationPortValue = instance.getApplicationPort()) != null) {
                this.applicationPort(applicationPortValue);
            }
            if ((applicationUrlValue = instance.getApplicationUrl()) != null) {
                this.applicationUrl(applicationUrlValue);
            }
            if ((routeIdValue = instance.getRouteId()) != null) {
                this.routeId(routeIdValue);
            }
            if ((routeUrlValue = instance.getRouteUrl()) != null) {
                this.routeUrl(routeUrlValue);
            }
            return this;
        }

        public final Builder applicationId(@Nullable String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final Builder applicationPort(@Nullable Integer applicationPort) {
            this.applicationPort = applicationPort;
            return this;
        }

        public final Builder applicationUrl(@Nullable String applicationUrl) {
            this.applicationUrl = applicationUrl;
            return this;
        }

        public final Builder routeId(@Nullable String routeId) {
            this.routeId = routeId;
            return this;
        }

        public final Builder routeUrl(@Nullable String routeUrl) {
            this.routeUrl = routeUrl;
            return this;
        }

        public RouteMappingEntity build() {
            return new RouteMappingEntity(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _RouteMappingEntity {
        String applicationId;
        Integer applicationPort;
        String applicationUrl;
        String routeId;
        String routeUrl;

        Json() {
        }

        @JsonProperty(value="app_guid")
        public void setApplicationId(@Nullable String applicationId) {
            this.applicationId = applicationId;
        }

        @JsonProperty(value="app_port")
        public void setApplicationPort(@Nullable Integer applicationPort) {
            this.applicationPort = applicationPort;
        }

        @JsonProperty(value="app_url")
        public void setApplicationUrl(@Nullable String applicationUrl) {
            this.applicationUrl = applicationUrl;
        }

        @JsonProperty(value="route_guid")
        public void setRouteId(@Nullable String routeId) {
            this.routeId = routeId;
        }

        @JsonProperty(value="route_url")
        public void setRouteUrl(@Nullable String routeUrl) {
            this.routeUrl = routeUrl;
        }

        @Override
        public String getApplicationId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getApplicationPort() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getApplicationUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getRouteId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getRouteUrl() {
            throw new UnsupportedOperationException();
        }
    }
}

