/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.routes;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.routes._DeleteRouteRequest;

public final class DeleteRouteRequest
extends _DeleteRouteRequest {
    @Nullable
    private final Boolean async;
    private final String routeId;

    private DeleteRouteRequest(Builder builder) {
        this.async = builder.async;
        this.routeId = builder.routeId;
    }

    @Override
    @Nullable
    public Boolean getAsync() {
        return this.async;
    }

    @Override
    public String getRouteId() {
        return this.routeId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof DeleteRouteRequest && this.equalTo((DeleteRouteRequest)another);
    }

    private boolean equalTo(DeleteRouteRequest another) {
        return Objects.equals(this.async, another.async) && this.routeId.equals(another.routeId);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.async);
        h = h * 17 + this.routeId.hashCode();
        return h;
    }

    public String toString() {
        return "DeleteRouteRequest{async=" + this.async + ", routeId=" + this.routeId + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ROUTE_ID = 1L;
        private long initBits = 1L;
        private Boolean async;
        private String routeId;

        private Builder() {
        }

        public final Builder from(DeleteRouteRequest instance) {
            return this.from((_DeleteRouteRequest)instance);
        }

        final Builder from(_DeleteRouteRequest instance) {
            Objects.requireNonNull(instance, "instance");
            Boolean asyncValue = instance.getAsync();
            if (asyncValue != null) {
                this.async(asyncValue);
            }
            this.routeId(instance.getRouteId());
            return this;
        }

        public final Builder async(@Nullable Boolean async) {
            this.async = async;
            return this;
        }

        public final Builder routeId(String routeId) {
            this.routeId = Objects.requireNonNull(routeId, "routeId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public DeleteRouteRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new DeleteRouteRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("routeId");
            }
            return "Cannot build DeleteRouteRequest, some of required attributes are not set " + attributes;
        }
    }
}

