/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.routes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.routes._RouteEntity;

public final class RouteEntity
extends _RouteEntity {
    @Nullable
    private final String applicationsUrl;
    @Nullable
    private final String domainId;
    @Nullable
    private final String domainUrl;
    @Nullable
    private final String host;
    @Nullable
    private final String path;
    @Nullable
    private final Integer port;
    @Nullable
    private final String routeMappingsUrl;
    @Nullable
    private final String serviceInstanceId;
    @Nullable
    private final String serviceInstanceUrl;
    @Nullable
    private final String spaceId;
    @Nullable
    private final String spaceUrl;

    private RouteEntity(Builder builder) {
        this.applicationsUrl = builder.applicationsUrl;
        this.domainId = builder.domainId;
        this.domainUrl = builder.domainUrl;
        this.host = builder.host;
        this.path = builder.path;
        this.port = builder.port;
        this.routeMappingsUrl = builder.routeMappingsUrl;
        this.serviceInstanceId = builder.serviceInstanceId;
        this.serviceInstanceUrl = builder.serviceInstanceUrl;
        this.spaceId = builder.spaceId;
        this.spaceUrl = builder.spaceUrl;
    }

    @Override
    @JsonProperty(value="apps_url")
    @Nullable
    public String getApplicationsUrl() {
        return this.applicationsUrl;
    }

    @Override
    @JsonProperty(value="domain_guid")
    @Nullable
    public String getDomainId() {
        return this.domainId;
    }

    @Override
    @JsonProperty(value="domain_url")
    @Nullable
    public String getDomainUrl() {
        return this.domainUrl;
    }

    @Override
    @JsonProperty(value="host")
    @Nullable
    public String getHost() {
        return this.host;
    }

    @Override
    @JsonProperty(value="path")
    @Nullable
    public String getPath() {
        return this.path;
    }

    @Override
    @JsonProperty(value="port")
    @Nullable
    public Integer getPort() {
        return this.port;
    }

    @Override
    @JsonProperty(value="route_mappings_url")
    @Nullable
    public String getRouteMappingsUrl() {
        return this.routeMappingsUrl;
    }

    @Override
    @JsonProperty(value="service_instance_guid")
    @Nullable
    public String getServiceInstanceId() {
        return this.serviceInstanceId;
    }

    @Override
    @JsonProperty(value="service_instance_url")
    @Nullable
    public String getServiceInstanceUrl() {
        return this.serviceInstanceUrl;
    }

    @Override
    @JsonProperty(value="space_guid")
    @Nullable
    public String getSpaceId() {
        return this.spaceId;
    }

    @Override
    @JsonProperty(value="space_url")
    @Nullable
    public String getSpaceUrl() {
        return this.spaceUrl;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof RouteEntity && this.equalTo((RouteEntity)another);
    }

    private boolean equalTo(RouteEntity another) {
        return Objects.equals(this.applicationsUrl, another.applicationsUrl) && Objects.equals(this.domainId, another.domainId) && Objects.equals(this.domainUrl, another.domainUrl) && Objects.equals(this.host, another.host) && Objects.equals(this.path, another.path) && Objects.equals(this.port, another.port) && Objects.equals(this.routeMappingsUrl, another.routeMappingsUrl) && Objects.equals(this.serviceInstanceId, another.serviceInstanceId) && Objects.equals(this.serviceInstanceUrl, another.serviceInstanceUrl) && Objects.equals(this.spaceId, another.spaceId) && Objects.equals(this.spaceUrl, another.spaceUrl);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.applicationsUrl);
        h = h * 17 + Objects.hashCode(this.domainId);
        h = h * 17 + Objects.hashCode(this.domainUrl);
        h = h * 17 + Objects.hashCode(this.host);
        h = h * 17 + Objects.hashCode(this.path);
        h = h * 17 + Objects.hashCode(this.port);
        h = h * 17 + Objects.hashCode(this.routeMappingsUrl);
        h = h * 17 + Objects.hashCode(this.serviceInstanceId);
        h = h * 17 + Objects.hashCode(this.serviceInstanceUrl);
        h = h * 17 + Objects.hashCode(this.spaceId);
        h = h * 17 + Objects.hashCode(this.spaceUrl);
        return h;
    }

    public String toString() {
        return "RouteEntity{applicationsUrl=" + this.applicationsUrl + ", domainId=" + this.domainId + ", domainUrl=" + this.domainUrl + ", host=" + this.host + ", path=" + this.path + ", port=" + this.port + ", routeMappingsUrl=" + this.routeMappingsUrl + ", serviceInstanceId=" + this.serviceInstanceId + ", serviceInstanceUrl=" + this.serviceInstanceUrl + ", spaceId=" + this.spaceId + ", spaceUrl=" + this.spaceUrl + "}";
    }

    @Deprecated
    @JsonCreator
    static RouteEntity fromJson(Json json) {
        Builder builder = RouteEntity.builder();
        if (json.applicationsUrl != null) {
            builder.applicationsUrl(json.applicationsUrl);
        }
        if (json.domainId != null) {
            builder.domainId(json.domainId);
        }
        if (json.domainUrl != null) {
            builder.domainUrl(json.domainUrl);
        }
        if (json.host != null) {
            builder.host(json.host);
        }
        if (json.path != null) {
            builder.path(json.path);
        }
        if (json.port != null) {
            builder.port(json.port);
        }
        if (json.routeMappingsUrl != null) {
            builder.routeMappingsUrl(json.routeMappingsUrl);
        }
        if (json.serviceInstanceId != null) {
            builder.serviceInstanceId(json.serviceInstanceId);
        }
        if (json.serviceInstanceUrl != null) {
            builder.serviceInstanceUrl(json.serviceInstanceUrl);
        }
        if (json.spaceId != null) {
            builder.spaceId(json.spaceId);
        }
        if (json.spaceUrl != null) {
            builder.spaceUrl(json.spaceUrl);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String applicationsUrl;
        private String domainId;
        private String domainUrl;
        private String host;
        private String path;
        private Integer port;
        private String routeMappingsUrl;
        private String serviceInstanceId;
        private String serviceInstanceUrl;
        private String spaceId;
        private String spaceUrl;

        private Builder() {
        }

        public final Builder from(RouteEntity instance) {
            return this.from((_RouteEntity)instance);
        }

        final Builder from(_RouteEntity instance) {
            String spaceUrlValue;
            String spaceIdValue;
            String serviceInstanceUrlValue;
            String serviceInstanceIdValue;
            String routeMappingsUrlValue;
            Integer portValue;
            String pathValue;
            String hostValue;
            String domainUrlValue;
            String domainIdValue;
            Objects.requireNonNull(instance, "instance");
            String applicationsUrlValue = instance.getApplicationsUrl();
            if (applicationsUrlValue != null) {
                this.applicationsUrl(applicationsUrlValue);
            }
            if ((domainIdValue = instance.getDomainId()) != null) {
                this.domainId(domainIdValue);
            }
            if ((domainUrlValue = instance.getDomainUrl()) != null) {
                this.domainUrl(domainUrlValue);
            }
            if ((hostValue = instance.getHost()) != null) {
                this.host(hostValue);
            }
            if ((pathValue = instance.getPath()) != null) {
                this.path(pathValue);
            }
            if ((portValue = instance.getPort()) != null) {
                this.port(portValue);
            }
            if ((routeMappingsUrlValue = instance.getRouteMappingsUrl()) != null) {
                this.routeMappingsUrl(routeMappingsUrlValue);
            }
            if ((serviceInstanceIdValue = instance.getServiceInstanceId()) != null) {
                this.serviceInstanceId(serviceInstanceIdValue);
            }
            if ((serviceInstanceUrlValue = instance.getServiceInstanceUrl()) != null) {
                this.serviceInstanceUrl(serviceInstanceUrlValue);
            }
            if ((spaceIdValue = instance.getSpaceId()) != null) {
                this.spaceId(spaceIdValue);
            }
            if ((spaceUrlValue = instance.getSpaceUrl()) != null) {
                this.spaceUrl(spaceUrlValue);
            }
            return this;
        }

        public final Builder applicationsUrl(@Nullable String applicationsUrl) {
            this.applicationsUrl = applicationsUrl;
            return this;
        }

        public final Builder domainId(@Nullable String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final Builder domainUrl(@Nullable String domainUrl) {
            this.domainUrl = domainUrl;
            return this;
        }

        public final Builder host(@Nullable String host) {
            this.host = host;
            return this;
        }

        public final Builder path(@Nullable String path) {
            this.path = path;
            return this;
        }

        public final Builder port(@Nullable Integer port) {
            this.port = port;
            return this;
        }

        public final Builder routeMappingsUrl(@Nullable String routeMappingsUrl) {
            this.routeMappingsUrl = routeMappingsUrl;
            return this;
        }

        public final Builder serviceInstanceId(@Nullable String serviceInstanceId) {
            this.serviceInstanceId = serviceInstanceId;
            return this;
        }

        public final Builder serviceInstanceUrl(@Nullable String serviceInstanceUrl) {
            this.serviceInstanceUrl = serviceInstanceUrl;
            return this;
        }

        public final Builder spaceId(@Nullable String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        public final Builder spaceUrl(@Nullable String spaceUrl) {
            this.spaceUrl = spaceUrl;
            return this;
        }

        public RouteEntity build() {
            return new RouteEntity(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _RouteEntity {
        String applicationsUrl;
        String domainId;
        String domainUrl;
        String host;
        String path;
        Integer port;
        String routeMappingsUrl;
        String serviceInstanceId;
        String serviceInstanceUrl;
        String spaceId;
        String spaceUrl;

        Json() {
        }

        @JsonProperty(value="apps_url")
        public void setApplicationsUrl(@Nullable String applicationsUrl) {
            this.applicationsUrl = applicationsUrl;
        }

        @JsonProperty(value="domain_guid")
        public void setDomainId(@Nullable String domainId) {
            this.domainId = domainId;
        }

        @JsonProperty(value="domain_url")
        public void setDomainUrl(@Nullable String domainUrl) {
            this.domainUrl = domainUrl;
        }

        @JsonProperty(value="host")
        public void setHost(@Nullable String host) {
            this.host = host;
        }

        @JsonProperty(value="path")
        public void setPath(@Nullable String path) {
            this.path = path;
        }

        @JsonProperty(value="port")
        public void setPort(@Nullable Integer port) {
            this.port = port;
        }

        @JsonProperty(value="route_mappings_url")
        public void setRouteMappingsUrl(@Nullable String routeMappingsUrl) {
            this.routeMappingsUrl = routeMappingsUrl;
        }

        @JsonProperty(value="service_instance_guid")
        public void setServiceInstanceId(@Nullable String serviceInstanceId) {
            this.serviceInstanceId = serviceInstanceId;
        }

        @JsonProperty(value="service_instance_url")
        public void setServiceInstanceUrl(@Nullable String serviceInstanceUrl) {
            this.serviceInstanceUrl = serviceInstanceUrl;
        }

        @JsonProperty(value="space_guid")
        public void setSpaceId(@Nullable String spaceId) {
            this.spaceId = spaceId;
        }

        @JsonProperty(value="space_url")
        public void setSpaceUrl(@Nullable String spaceUrl) {
            this.spaceUrl = spaceUrl;
        }

        @Override
        public String getApplicationsUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDomainId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDomainUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getHost() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPath() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getPort() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getRouteMappingsUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getServiceInstanceId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getServiceInstanceUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSpaceId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSpaceUrl() {
            throw new UnsupportedOperationException();
        }
    }
}

