/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.routes;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.routes._UpdateRouteRequest;

public final class UpdateRouteRequest
extends _UpdateRouteRequest {
    @Nullable
    private final String domainId;
    @Nullable
    private final String host;
    @Nullable
    private final String path;
    @Nullable
    private final Integer port;
    private final String routeId;
    @Nullable
    private final String spaceId;

    private UpdateRouteRequest(Builder builder) {
        this.domainId = builder.domainId;
        this.host = builder.host;
        this.path = builder.path;
        this.port = builder.port;
        this.routeId = builder.routeId;
        this.spaceId = builder.spaceId;
    }

    @Override
    @Nullable
    public String getDomainId() {
        return this.domainId;
    }

    @Override
    @Nullable
    public String getHost() {
        return this.host;
    }

    @Override
    @Nullable
    public String getPath() {
        return this.path;
    }

    @Override
    @Nullable
    public Integer getPort() {
        return this.port;
    }

    @Override
    public String getRouteId() {
        return this.routeId;
    }

    @Override
    @Nullable
    public String getSpaceId() {
        return this.spaceId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UpdateRouteRequest && this.equalTo((UpdateRouteRequest)another);
    }

    private boolean equalTo(UpdateRouteRequest another) {
        return Objects.equals(this.domainId, another.domainId) && Objects.equals(this.host, another.host) && Objects.equals(this.path, another.path) && Objects.equals(this.port, another.port) && this.routeId.equals(another.routeId) && Objects.equals(this.spaceId, another.spaceId);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.domainId);
        h = h * 17 + Objects.hashCode(this.host);
        h = h * 17 + Objects.hashCode(this.path);
        h = h * 17 + Objects.hashCode(this.port);
        h = h * 17 + this.routeId.hashCode();
        h = h * 17 + Objects.hashCode(this.spaceId);
        return h;
    }

    public String toString() {
        return "UpdateRouteRequest{domainId=" + this.domainId + ", host=" + this.host + ", path=" + this.path + ", port=" + this.port + ", routeId=" + this.routeId + ", spaceId=" + this.spaceId + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ROUTE_ID = 1L;
        private long initBits = 1L;
        private String domainId;
        private String host;
        private String path;
        private Integer port;
        private String routeId;
        private String spaceId;

        private Builder() {
        }

        public final Builder from(UpdateRouteRequest instance) {
            return this.from((_UpdateRouteRequest)instance);
        }

        final Builder from(_UpdateRouteRequest instance) {
            Integer portValue;
            String pathValue;
            String hostValue;
            Objects.requireNonNull(instance, "instance");
            String domainIdValue = instance.getDomainId();
            if (domainIdValue != null) {
                this.domainId(domainIdValue);
            }
            if ((hostValue = instance.getHost()) != null) {
                this.host(hostValue);
            }
            if ((pathValue = instance.getPath()) != null) {
                this.path(pathValue);
            }
            if ((portValue = instance.getPort()) != null) {
                this.port(portValue);
            }
            this.routeId(instance.getRouteId());
            String spaceIdValue = instance.getSpaceId();
            if (spaceIdValue != null) {
                this.spaceId(spaceIdValue);
            }
            return this;
        }

        public final Builder domainId(@Nullable String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final Builder host(@Nullable String host) {
            this.host = host;
            return this;
        }

        public final Builder path(@Nullable String path) {
            this.path = path;
            return this;
        }

        public final Builder port(@Nullable Integer port) {
            this.port = port;
            return this;
        }

        public final Builder routeId(String routeId) {
            this.routeId = Objects.requireNonNull(routeId, "routeId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder spaceId(@Nullable String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        public UpdateRouteRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new UpdateRouteRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("routeId");
            }
            return "Cannot build UpdateRouteRequest, some of required attributes are not set " + attributes;
        }
    }
}

