/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.securitygroups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.securitygroups._RuleEntity;

public final class RuleEntity
extends _RuleEntity {
    @Nullable
    private final String destination;
    @Nullable
    private final String ports;
    @Nullable
    private final String protocol;
    @Nullable
    private final Integer type;
    @Nullable
    private final Integer code;
    @Nullable
    private final Boolean log;

    private RuleEntity(Builder builder) {
        this.destination = builder.destination;
        this.ports = builder.ports;
        this.protocol = builder.protocol;
        this.type = builder.type;
        this.code = builder.code;
        this.log = builder.log;
    }

    @Override
    @JsonProperty(value="destination")
    @Nullable
    public String getDestination() {
        return this.destination;
    }

    @Override
    @JsonProperty(value="ports")
    @Nullable
    public String getPorts() {
        return this.ports;
    }

    @Override
    @JsonProperty(value="protocol")
    @Nullable
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    @JsonProperty(value="type")
    @Nullable
    public Integer getType() {
        return this.type;
    }

    @Override
    @JsonProperty(value="code")
    @Nullable
    public Integer getCode() {
        return this.code;
    }

    @Override
    @JsonProperty(value="log")
    @Nullable
    public Boolean getLog() {
        return this.log;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof RuleEntity && this.equalTo((RuleEntity)another);
    }

    private boolean equalTo(RuleEntity another) {
        return Objects.equals(this.destination, another.destination) && Objects.equals(this.ports, another.ports) && Objects.equals(this.protocol, another.protocol) && Objects.equals(this.type, another.type) && Objects.equals(this.code, another.code) && Objects.equals(this.log, another.log);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.destination);
        h = h * 17 + Objects.hashCode(this.ports);
        h = h * 17 + Objects.hashCode(this.protocol);
        h = h * 17 + Objects.hashCode(this.type);
        h = h * 17 + Objects.hashCode(this.code);
        h = h * 17 + Objects.hashCode(this.log);
        return h;
    }

    public String toString() {
        return "RuleEntity{destination=" + this.destination + ", ports=" + this.ports + ", protocol=" + this.protocol + ", type=" + this.type + ", code=" + this.code + ", log=" + this.log + "}";
    }

    @Deprecated
    @JsonCreator
    static RuleEntity fromJson(Json json) {
        Builder builder = RuleEntity.builder();
        if (json.destination != null) {
            builder.destination(json.destination);
        }
        if (json.ports != null) {
            builder.ports(json.ports);
        }
        if (json.protocol != null) {
            builder.protocol(json.protocol);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.code != null) {
            builder.code(json.code);
        }
        if (json.log != null) {
            builder.log(json.log);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String destination;
        private String ports;
        private String protocol;
        private Integer type;
        private Integer code;
        private Boolean log;

        private Builder() {
        }

        public final Builder from(RuleEntity instance) {
            return this.from((_RuleEntity)instance);
        }

        final Builder from(_RuleEntity instance) {
            Boolean logValue;
            Integer codeValue;
            Integer typeValue;
            String protocolValue;
            String portsValue;
            Objects.requireNonNull(instance, "instance");
            String destinationValue = instance.getDestination();
            if (destinationValue != null) {
                this.destination(destinationValue);
            }
            if ((portsValue = instance.getPorts()) != null) {
                this.ports(portsValue);
            }
            if ((protocolValue = instance.getProtocol()) != null) {
                this.protocol(protocolValue);
            }
            if ((typeValue = instance.getType()) != null) {
                this.type(typeValue);
            }
            if ((codeValue = instance.getCode()) != null) {
                this.code(codeValue);
            }
            if ((logValue = instance.getLog()) != null) {
                this.log(logValue);
            }
            return this;
        }

        public final Builder destination(@Nullable String destination) {
            this.destination = destination;
            return this;
        }

        public final Builder ports(@Nullable String ports) {
            this.ports = ports;
            return this;
        }

        public final Builder protocol(@Nullable String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final Builder type(@Nullable Integer type) {
            this.type = type;
            return this;
        }

        public final Builder code(@Nullable Integer code) {
            this.code = code;
            return this;
        }

        public final Builder log(@Nullable Boolean log) {
            this.log = log;
            return this;
        }

        public RuleEntity build() {
            return new RuleEntity(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _RuleEntity {
        String destination;
        String ports;
        String protocol;
        Integer type;
        Integer code;
        Boolean log;

        Json() {
        }

        @JsonProperty(value="destination")
        public void setDestination(@Nullable String destination) {
            this.destination = destination;
        }

        @JsonProperty(value="ports")
        public void setPorts(@Nullable String ports) {
            this.ports = ports;
        }

        @JsonProperty(value="protocol")
        public void setProtocol(@Nullable String protocol) {
            this.protocol = protocol;
        }

        @JsonProperty(value="type")
        public void setType(@Nullable Integer type) {
            this.type = type;
        }

        @JsonProperty(value="code")
        public void setCode(@Nullable Integer code) {
            this.code = code;
        }

        @JsonProperty(value="log")
        public void setLog(@Nullable Boolean log) {
            this.log = log;
        }

        @Override
        public String getDestination() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPorts() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getProtocol() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getCode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getLog() {
            throw new UnsupportedOperationException();
        }
    }
}

