/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.servicebindings;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.servicebindings._ServiceBindingEntity;
import org.cloudfoundry.client.v2.serviceinstances.GatewayData;

public final class ServiceBindingEntity
extends _ServiceBindingEntity {
    @Nullable
    private final String applicationId;
    @Nullable
    private final String applicationUrl;
    @Nullable
    private final Map<String, Object> bindingOptions;
    @Nullable
    private final Map<String, Object> credentials;
    @Nullable
    private final GatewayData gatewayData;
    @Nullable
    private final String gatewayName;
    @Nullable
    private final String serviceInstanceId;
    @Nullable
    private final String serviceInstanceUrl;
    @Nullable
    private final String syslogDrainUrl;

    private ServiceBindingEntity(Builder builder) {
        this.applicationId = builder.applicationId;
        this.applicationUrl = builder.applicationUrl;
        this.bindingOptions = builder.bindingOptions == null ? null : ServiceBindingEntity.createUnmodifiableMap(false, false, builder.bindingOptions);
        this.credentials = builder.credentials == null ? null : ServiceBindingEntity.createUnmodifiableMap(false, false, builder.credentials);
        this.gatewayData = builder.gatewayData;
        this.gatewayName = builder.gatewayName;
        this.serviceInstanceId = builder.serviceInstanceId;
        this.serviceInstanceUrl = builder.serviceInstanceUrl;
        this.syslogDrainUrl = builder.syslogDrainUrl;
    }

    @Override
    @JsonProperty(value="app_guid")
    @Nullable
    public String getApplicationId() {
        return this.applicationId;
    }

    @Override
    @JsonProperty(value="app_url")
    @Nullable
    public String getApplicationUrl() {
        return this.applicationUrl;
    }

    @Override
    @JsonProperty(value="binding_options")
    @Nullable
    public Map<String, Object> getBindingOptions() {
        return this.bindingOptions;
    }

    @Override
    @JsonProperty(value="credentials")
    @Nullable
    public Map<String, Object> getCredentials() {
        return this.credentials;
    }

    @Override
    @JsonProperty(value="gateway_data")
    @Deprecated
    @Nullable
    public GatewayData getGatewayData() {
        return this.gatewayData;
    }

    @Override
    @JsonProperty(value="gateway_name")
    @Nullable
    public String getGatewayName() {
        return this.gatewayName;
    }

    @Override
    @JsonProperty(value="service_instance_guid")
    @Nullable
    public String getServiceInstanceId() {
        return this.serviceInstanceId;
    }

    @Override
    @JsonProperty(value="service_instance_url")
    @Nullable
    public String getServiceInstanceUrl() {
        return this.serviceInstanceUrl;
    }

    @Override
    @JsonProperty(value="syslog_drain_url")
    @Nullable
    public String getSyslogDrainUrl() {
        return this.syslogDrainUrl;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ServiceBindingEntity && this.equalTo((ServiceBindingEntity)another);
    }

    private boolean equalTo(ServiceBindingEntity another) {
        return Objects.equals(this.applicationId, another.applicationId) && Objects.equals(this.applicationUrl, another.applicationUrl) && Objects.equals(this.bindingOptions, another.bindingOptions) && Objects.equals(this.credentials, another.credentials) && Objects.equals(this.gatewayData, another.gatewayData) && Objects.equals(this.gatewayName, another.gatewayName) && Objects.equals(this.serviceInstanceId, another.serviceInstanceId) && Objects.equals(this.serviceInstanceUrl, another.serviceInstanceUrl) && Objects.equals(this.syslogDrainUrl, another.syslogDrainUrl);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.applicationId);
        h = h * 17 + Objects.hashCode(this.applicationUrl);
        h = h * 17 + Objects.hashCode(this.bindingOptions);
        h = h * 17 + Objects.hashCode(this.credentials);
        h = h * 17 + Objects.hashCode(this.gatewayData);
        h = h * 17 + Objects.hashCode(this.gatewayName);
        h = h * 17 + Objects.hashCode(this.serviceInstanceId);
        h = h * 17 + Objects.hashCode(this.serviceInstanceUrl);
        h = h * 17 + Objects.hashCode(this.syslogDrainUrl);
        return h;
    }

    public String toString() {
        return "ServiceBindingEntity{applicationId=" + this.applicationId + ", applicationUrl=" + this.applicationUrl + ", bindingOptions=" + this.bindingOptions + ", credentials=" + this.credentials + ", gatewayData=" + this.gatewayData + ", gatewayName=" + this.gatewayName + ", serviceInstanceId=" + this.serviceInstanceId + ", serviceInstanceUrl=" + this.serviceInstanceUrl + ", syslogDrainUrl=" + this.syslogDrainUrl + "}";
    }

    @Deprecated
    @JsonCreator
    static ServiceBindingEntity fromJson(Json json) {
        Builder builder = ServiceBindingEntity.builder();
        if (json.applicationId != null) {
            builder.applicationId(json.applicationId);
        }
        if (json.applicationUrl != null) {
            builder.applicationUrl(json.applicationUrl);
        }
        if (json.bindingOptions != null) {
            builder.putAllBindingOptions(json.bindingOptions);
        }
        if (json.credentials != null) {
            builder.putAllCredentials(json.credentials);
        }
        if (json.gatewayData != null) {
            builder.gatewayData(json.gatewayData);
        }
        if (json.gatewayName != null) {
            builder.gatewayName(json.gatewayName);
        }
        if (json.serviceInstanceId != null) {
            builder.serviceInstanceId(json.serviceInstanceId);
        }
        if (json.serviceInstanceUrl != null) {
            builder.serviceInstanceUrl(json.serviceInstanceUrl);
        }
        if (json.syslogDrainUrl != null) {
            builder.syslogDrainUrl(json.syslogDrainUrl);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    public static final class Builder {
        private String applicationId;
        private String applicationUrl;
        private Map<String, Object> bindingOptions = null;
        private Map<String, Object> credentials = null;
        private GatewayData gatewayData;
        private String gatewayName;
        private String serviceInstanceId;
        private String serviceInstanceUrl;
        private String syslogDrainUrl;

        private Builder() {
        }

        public final Builder from(ServiceBindingEntity instance) {
            return this.from((_ServiceBindingEntity)instance);
        }

        final Builder from(_ServiceBindingEntity instance) {
            String syslogDrainUrlValue;
            String serviceInstanceUrlValue;
            String serviceInstanceIdValue;
            String gatewayNameValue;
            GatewayData gatewayDataValue;
            Map<String, Object> credentialsValue;
            Map<String, Object> bindingOptionsValue;
            String applicationUrlValue;
            Objects.requireNonNull(instance, "instance");
            String applicationIdValue = instance.getApplicationId();
            if (applicationIdValue != null) {
                this.applicationId(applicationIdValue);
            }
            if ((applicationUrlValue = instance.getApplicationUrl()) != null) {
                this.applicationUrl(applicationUrlValue);
            }
            if ((bindingOptionsValue = instance.getBindingOptions()) != null) {
                this.putAllBindingOptions(bindingOptionsValue);
            }
            if ((credentialsValue = instance.getCredentials()) != null) {
                this.putAllCredentials(credentialsValue);
            }
            if ((gatewayDataValue = instance.getGatewayData()) != null) {
                this.gatewayData(gatewayDataValue);
            }
            if ((gatewayNameValue = instance.getGatewayName()) != null) {
                this.gatewayName(gatewayNameValue);
            }
            if ((serviceInstanceIdValue = instance.getServiceInstanceId()) != null) {
                this.serviceInstanceId(serviceInstanceIdValue);
            }
            if ((serviceInstanceUrlValue = instance.getServiceInstanceUrl()) != null) {
                this.serviceInstanceUrl(serviceInstanceUrlValue);
            }
            if ((syslogDrainUrlValue = instance.getSyslogDrainUrl()) != null) {
                this.syslogDrainUrl(syslogDrainUrlValue);
            }
            return this;
        }

        public final Builder applicationId(@Nullable String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final Builder applicationUrl(@Nullable String applicationUrl) {
            this.applicationUrl = applicationUrl;
            return this;
        }

        public final Builder bindingOption(String key, Object value) {
            if (this.bindingOptions == null) {
                this.bindingOptions = new LinkedHashMap<String, Object>();
            }
            this.bindingOptions.put(Objects.requireNonNull(key, "bindingOptions key"), Objects.requireNonNull(value, "bindingOptions value"));
            return this;
        }

        public final Builder bindingOption(Map.Entry<String, ? extends Object> entry) {
            if (this.bindingOptions == null) {
                this.bindingOptions = new LinkedHashMap<String, Object>();
            }
            String k = entry.getKey();
            Object v = entry.getValue();
            this.bindingOptions.put(Objects.requireNonNull(k, "bindingOptions key"), Objects.requireNonNull(v, "bindingOptions value"));
            return this;
        }

        public final Builder bindingOptions(@Nullable Map<String, ? extends Object> bindingOptions) {
            if (bindingOptions == null) {
                this.bindingOptions = null;
                return this;
            }
            this.bindingOptions = new LinkedHashMap<String, Object>();
            return this.putAllBindingOptions(bindingOptions);
        }

        public final Builder putAllBindingOptions(Map<String, ? extends Object> bindingOptions) {
            if (this.bindingOptions == null) {
                this.bindingOptions = new LinkedHashMap<String, Object>();
            }
            for (Map.Entry<String, ? extends Object> entry : bindingOptions.entrySet()) {
                String k = entry.getKey();
                Object v = entry.getValue();
                this.bindingOptions.put(Objects.requireNonNull(k, "bindingOptions key"), Objects.requireNonNull(v, "bindingOptions value"));
            }
            return this;
        }

        public final Builder credential(String key, Object value) {
            if (this.credentials == null) {
                this.credentials = new LinkedHashMap<String, Object>();
            }
            this.credentials.put(Objects.requireNonNull(key, "credentials key"), Objects.requireNonNull(value, "credentials value"));
            return this;
        }

        public final Builder credential(Map.Entry<String, ? extends Object> entry) {
            if (this.credentials == null) {
                this.credentials = new LinkedHashMap<String, Object>();
            }
            String k = entry.getKey();
            Object v = entry.getValue();
            this.credentials.put(Objects.requireNonNull(k, "credentials key"), Objects.requireNonNull(v, "credentials value"));
            return this;
        }

        public final Builder credentials(@Nullable Map<String, ? extends Object> credentials) {
            if (credentials == null) {
                this.credentials = null;
                return this;
            }
            this.credentials = new LinkedHashMap<String, Object>();
            return this.putAllCredentials(credentials);
        }

        public final Builder putAllCredentials(Map<String, ? extends Object> credentials) {
            if (this.credentials == null) {
                this.credentials = new LinkedHashMap<String, Object>();
            }
            for (Map.Entry<String, ? extends Object> entry : credentials.entrySet()) {
                String k = entry.getKey();
                Object v = entry.getValue();
                this.credentials.put(Objects.requireNonNull(k, "credentials key"), Objects.requireNonNull(v, "credentials value"));
            }
            return this;
        }

        @Deprecated
        public final Builder gatewayData(@Nullable GatewayData gatewayData) {
            this.gatewayData = gatewayData;
            return this;
        }

        public final Builder gatewayName(@Nullable String gatewayName) {
            this.gatewayName = gatewayName;
            return this;
        }

        public final Builder serviceInstanceId(@Nullable String serviceInstanceId) {
            this.serviceInstanceId = serviceInstanceId;
            return this;
        }

        public final Builder serviceInstanceUrl(@Nullable String serviceInstanceUrl) {
            this.serviceInstanceUrl = serviceInstanceUrl;
            return this;
        }

        public final Builder syslogDrainUrl(@Nullable String syslogDrainUrl) {
            this.syslogDrainUrl = syslogDrainUrl;
            return this;
        }

        public ServiceBindingEntity build() {
            return new ServiceBindingEntity(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _ServiceBindingEntity {
        String applicationId;
        String applicationUrl;
        Map<String, Object> bindingOptions;
        Map<String, Object> credentials;
        GatewayData gatewayData;
        String gatewayName;
        String serviceInstanceId;
        String serviceInstanceUrl;
        String syslogDrainUrl;

        Json() {
        }

        @JsonProperty(value="app_guid")
        public void setApplicationId(@Nullable String applicationId) {
            this.applicationId = applicationId;
        }

        @JsonProperty(value="app_url")
        public void setApplicationUrl(@Nullable String applicationUrl) {
            this.applicationUrl = applicationUrl;
        }

        @JsonProperty(value="binding_options")
        public void setBindingOptions(@Nullable Map<String, Object> bindingOptions) {
            this.bindingOptions = bindingOptions;
        }

        @JsonProperty(value="credentials")
        public void setCredentials(@Nullable Map<String, Object> credentials) {
            this.credentials = credentials;
        }

        @JsonProperty(value="gateway_data")
        public void setGatewayData(@Nullable GatewayData gatewayData) {
            this.gatewayData = gatewayData;
        }

        @JsonProperty(value="gateway_name")
        public void setGatewayName(@Nullable String gatewayName) {
            this.gatewayName = gatewayName;
        }

        @JsonProperty(value="service_instance_guid")
        public void setServiceInstanceId(@Nullable String serviceInstanceId) {
            this.serviceInstanceId = serviceInstanceId;
        }

        @JsonProperty(value="service_instance_url")
        public void setServiceInstanceUrl(@Nullable String serviceInstanceUrl) {
            this.serviceInstanceUrl = serviceInstanceUrl;
        }

        @JsonProperty(value="syslog_drain_url")
        public void setSyslogDrainUrl(@Nullable String syslogDrainUrl) {
            this.syslogDrainUrl = syslogDrainUrl;
        }

        @Override
        public String getApplicationId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getApplicationUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Object> getBindingOptions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Object> getCredentials() {
            throw new UnsupportedOperationException();
        }

        @Override
        public GatewayData getGatewayData() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getGatewayName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getServiceInstanceId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getServiceInstanceUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSyslogDrainUrl() {
            throw new UnsupportedOperationException();
        }
    }
}

