/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.serviceinstances;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.serviceinstances._BindServiceInstanceToRouteRequest;

public final class BindServiceInstanceToRouteRequest
extends _BindServiceInstanceToRouteRequest {
    @Nullable
    private final Map<String, Object> parameters;
    private final String routeId;
    private final String serviceInstanceId;

    private BindServiceInstanceToRouteRequest(Builder builder) {
        this.parameters = builder.parameters == null ? null : BindServiceInstanceToRouteRequest.createUnmodifiableMap(false, false, builder.parameters);
        this.routeId = builder.routeId;
        this.serviceInstanceId = builder.serviceInstanceId;
    }

    @Override
    @Nullable
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @Override
    public String getRouteId() {
        return this.routeId;
    }

    @Override
    public String getServiceInstanceId() {
        return this.serviceInstanceId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof BindServiceInstanceToRouteRequest && this.equalTo((BindServiceInstanceToRouteRequest)another);
    }

    private boolean equalTo(BindServiceInstanceToRouteRequest another) {
        return Objects.equals(this.parameters, another.parameters) && this.routeId.equals(another.routeId) && this.serviceInstanceId.equals(another.serviceInstanceId);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.parameters);
        h = h * 17 + this.routeId.hashCode();
        h = h * 17 + this.serviceInstanceId.hashCode();
        return h;
    }

    public String toString() {
        return "BindServiceInstanceToRouteRequest{parameters=" + this.parameters + ", routeId=" + this.routeId + ", serviceInstanceId=" + this.serviceInstanceId + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    public static final class Builder {
        private static final long INIT_BIT_ROUTE_ID = 1L;
        private static final long INIT_BIT_SERVICE_INSTANCE_ID = 2L;
        private long initBits = 3L;
        private Map<String, Object> parameters = null;
        private String routeId;
        private String serviceInstanceId;

        private Builder() {
        }

        public final Builder from(BindServiceInstanceToRouteRequest instance) {
            return this.from((_BindServiceInstanceToRouteRequest)instance);
        }

        final Builder from(_BindServiceInstanceToRouteRequest instance) {
            Objects.requireNonNull(instance, "instance");
            Map<String, Object> parametersValue = instance.getParameters();
            if (parametersValue != null) {
                this.putAllParameters(parametersValue);
            }
            this.routeId(instance.getRouteId());
            this.serviceInstanceId(instance.getServiceInstanceId());
            return this;
        }

        public final Builder parameter(String key, Object value) {
            if (this.parameters == null) {
                this.parameters = new LinkedHashMap<String, Object>();
            }
            this.parameters.put(Objects.requireNonNull(key, "parameters key"), Objects.requireNonNull(value, "parameters value"));
            return this;
        }

        public final Builder parameter(Map.Entry<String, ? extends Object> entry) {
            if (this.parameters == null) {
                this.parameters = new LinkedHashMap<String, Object>();
            }
            String k = entry.getKey();
            Object v = entry.getValue();
            this.parameters.put(Objects.requireNonNull(k, "parameters key"), Objects.requireNonNull(v, "parameters value"));
            return this;
        }

        public final Builder parameters(@Nullable Map<String, ? extends Object> parameters) {
            if (parameters == null) {
                this.parameters = null;
                return this;
            }
            this.parameters = new LinkedHashMap<String, Object>();
            return this.putAllParameters(parameters);
        }

        public final Builder putAllParameters(Map<String, ? extends Object> parameters) {
            if (this.parameters == null) {
                this.parameters = new LinkedHashMap<String, Object>();
            }
            for (Map.Entry<String, ? extends Object> entry : parameters.entrySet()) {
                String k = entry.getKey();
                Object v = entry.getValue();
                this.parameters.put(Objects.requireNonNull(k, "parameters key"), Objects.requireNonNull(v, "parameters value"));
            }
            return this;
        }

        public final Builder routeId(String routeId) {
            this.routeId = Objects.requireNonNull(routeId, "routeId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder serviceInstanceId(String serviceInstanceId) {
            this.serviceInstanceId = Objects.requireNonNull(serviceInstanceId, "serviceInstanceId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public BindServiceInstanceToRouteRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new BindServiceInstanceToRouteRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("routeId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("serviceInstanceId");
            }
            return "Cannot build BindServiceInstanceToRouteRequest, some of required attributes are not set " + attributes;
        }
    }
}

