/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.servicekeys;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.Metadata;
import org.cloudfoundry.client.v2.servicekeys.ServiceKeyEntity;
import org.cloudfoundry.client.v2.servicekeys._CreateServiceKeyResponse;

public final class CreateServiceKeyResponse
extends _CreateServiceKeyResponse {
    @Nullable
    private final ServiceKeyEntity entity;
    @Nullable
    private final Metadata metadata;

    private CreateServiceKeyResponse(Builder builder) {
        this.entity = builder.entity;
        this.metadata = builder.metadata;
    }

    @Override
    @JsonProperty(value="entity")
    @Nullable
    public ServiceKeyEntity getEntity() {
        return this.entity;
    }

    @Override
    @JsonProperty(value="metadata")
    @Nullable
    public Metadata getMetadata() {
        return this.metadata;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CreateServiceKeyResponse && this.equalTo((CreateServiceKeyResponse)another);
    }

    private boolean equalTo(CreateServiceKeyResponse another) {
        return Objects.equals(this.entity, another.entity) && Objects.equals(this.metadata, another.metadata);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.entity);
        h = h * 17 + Objects.hashCode(this.metadata);
        return h;
    }

    public String toString() {
        return "CreateServiceKeyResponse{entity=" + this.entity + ", metadata=" + this.metadata + "}";
    }

    @Deprecated
    @JsonCreator
    static CreateServiceKeyResponse fromJson(Json json) {
        Builder builder = CreateServiceKeyResponse.builder();
        if (json.entity != null) {
            builder.entity(json.entity);
        }
        if (json.metadata != null) {
            builder.metadata(json.metadata);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ServiceKeyEntity entity;
        private Metadata metadata;

        private Builder() {
        }

        public final Builder from(CreateServiceKeyResponse instance) {
            return this.from((_CreateServiceKeyResponse)instance);
        }

        final Builder from(_CreateServiceKeyResponse instance) {
            Metadata metadataValue;
            Objects.requireNonNull(instance, "instance");
            ServiceKeyEntity entityValue = (ServiceKeyEntity)instance.getEntity();
            if (entityValue != null) {
                this.entity(entityValue);
            }
            if ((metadataValue = instance.getMetadata()) != null) {
                this.metadata(metadataValue);
            }
            return this;
        }

        public final Builder entity(@Nullable ServiceKeyEntity entity) {
            this.entity = entity;
            return this;
        }

        public final Builder metadata(@Nullable Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public CreateServiceKeyResponse build() {
            return new CreateServiceKeyResponse(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _CreateServiceKeyResponse {
        ServiceKeyEntity entity;
        Metadata metadata;

        Json() {
        }

        @JsonProperty(value="entity")
        public void setEntity(@Nullable ServiceKeyEntity entity) {
            this.entity = entity;
        }

        @JsonProperty(value="metadata")
        public void setMetadata(@Nullable Metadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public ServiceKeyEntity getEntity() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Metadata getMetadata() {
            throw new UnsupportedOperationException();
        }
    }
}

