/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.serviceplans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.serviceplans._ServicePlanEntity;

public final class ServicePlanEntity
extends _ServicePlanEntity {
    @Nullable
    private final Boolean active;
    @Nullable
    private final String description;
    @Nullable
    private final String extra;
    @Nullable
    private final Boolean free;
    @Nullable
    private final String name;
    @Nullable
    private final Boolean publiclyVisible;
    @Nullable
    private final String serviceId;
    @Nullable
    private final String serviceInstancesUrl;
    @Nullable
    private final String serviceUrl;
    @Nullable
    private final String uniqueId;

    private ServicePlanEntity(Builder builder) {
        this.active = builder.active;
        this.description = builder.description;
        this.extra = builder.extra;
        this.free = builder.free;
        this.name = builder.name;
        this.publiclyVisible = builder.publiclyVisible;
        this.serviceId = builder.serviceId;
        this.serviceInstancesUrl = builder.serviceInstancesUrl;
        this.serviceUrl = builder.serviceUrl;
        this.uniqueId = builder.uniqueId;
    }

    @Override
    @JsonProperty(value="active")
    @Nullable
    public Boolean getActive() {
        return this.active;
    }

    @Override
    @JsonProperty(value="description")
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    @JsonProperty(value="extra")
    @Nullable
    public String getExtra() {
        return this.extra;
    }

    @Override
    @JsonProperty(value="free")
    @Nullable
    public Boolean getFree() {
        return this.free;
    }

    @Override
    @JsonProperty(value="name")
    @Nullable
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="public")
    @Nullable
    public Boolean getPubliclyVisible() {
        return this.publiclyVisible;
    }

    @Override
    @JsonProperty(value="service_guid")
    @Nullable
    public String getServiceId() {
        return this.serviceId;
    }

    @Override
    @JsonProperty(value="service_instances_url")
    @Nullable
    public String getServiceInstancesUrl() {
        return this.serviceInstancesUrl;
    }

    @Override
    @JsonProperty(value="service_url")
    @Nullable
    public String getServiceUrl() {
        return this.serviceUrl;
    }

    @Override
    @JsonProperty(value="unique_id")
    @Nullable
    public String getUniqueId() {
        return this.uniqueId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ServicePlanEntity && this.equalTo((ServicePlanEntity)another);
    }

    private boolean equalTo(ServicePlanEntity another) {
        return Objects.equals(this.active, another.active) && Objects.equals(this.description, another.description) && Objects.equals(this.extra, another.extra) && Objects.equals(this.free, another.free) && Objects.equals(this.name, another.name) && Objects.equals(this.publiclyVisible, another.publiclyVisible) && Objects.equals(this.serviceId, another.serviceId) && Objects.equals(this.serviceInstancesUrl, another.serviceInstancesUrl) && Objects.equals(this.serviceUrl, another.serviceUrl) && Objects.equals(this.uniqueId, another.uniqueId);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.active);
        h = h * 17 + Objects.hashCode(this.description);
        h = h * 17 + Objects.hashCode(this.extra);
        h = h * 17 + Objects.hashCode(this.free);
        h = h * 17 + Objects.hashCode(this.name);
        h = h * 17 + Objects.hashCode(this.publiclyVisible);
        h = h * 17 + Objects.hashCode(this.serviceId);
        h = h * 17 + Objects.hashCode(this.serviceInstancesUrl);
        h = h * 17 + Objects.hashCode(this.serviceUrl);
        h = h * 17 + Objects.hashCode(this.uniqueId);
        return h;
    }

    public String toString() {
        return "ServicePlanEntity{active=" + this.active + ", description=" + this.description + ", extra=" + this.extra + ", free=" + this.free + ", name=" + this.name + ", publiclyVisible=" + this.publiclyVisible + ", serviceId=" + this.serviceId + ", serviceInstancesUrl=" + this.serviceInstancesUrl + ", serviceUrl=" + this.serviceUrl + ", uniqueId=" + this.uniqueId + "}";
    }

    @Deprecated
    @JsonCreator
    static ServicePlanEntity fromJson(Json json) {
        Builder builder = ServicePlanEntity.builder();
        if (json.active != null) {
            builder.active(json.active);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.extra != null) {
            builder.extra(json.extra);
        }
        if (json.free != null) {
            builder.free(json.free);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.publiclyVisible != null) {
            builder.publiclyVisible(json.publiclyVisible);
        }
        if (json.serviceId != null) {
            builder.serviceId(json.serviceId);
        }
        if (json.serviceInstancesUrl != null) {
            builder.serviceInstancesUrl(json.serviceInstancesUrl);
        }
        if (json.serviceUrl != null) {
            builder.serviceUrl(json.serviceUrl);
        }
        if (json.uniqueId != null) {
            builder.uniqueId(json.uniqueId);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean active;
        private String description;
        private String extra;
        private Boolean free;
        private String name;
        private Boolean publiclyVisible;
        private String serviceId;
        private String serviceInstancesUrl;
        private String serviceUrl;
        private String uniqueId;

        private Builder() {
        }

        public final Builder from(ServicePlanEntity instance) {
            return this.from((_ServicePlanEntity)instance);
        }

        final Builder from(_ServicePlanEntity instance) {
            String uniqueIdValue;
            String serviceUrlValue;
            String serviceInstancesUrlValue;
            String serviceIdValue;
            Boolean publiclyVisibleValue;
            String nameValue;
            Boolean freeValue;
            String extraValue;
            String descriptionValue;
            Objects.requireNonNull(instance, "instance");
            Boolean activeValue = instance.getActive();
            if (activeValue != null) {
                this.active(activeValue);
            }
            if ((descriptionValue = instance.getDescription()) != null) {
                this.description(descriptionValue);
            }
            if ((extraValue = instance.getExtra()) != null) {
                this.extra(extraValue);
            }
            if ((freeValue = instance.getFree()) != null) {
                this.free(freeValue);
            }
            if ((nameValue = instance.getName()) != null) {
                this.name(nameValue);
            }
            if ((publiclyVisibleValue = instance.getPubliclyVisible()) != null) {
                this.publiclyVisible(publiclyVisibleValue);
            }
            if ((serviceIdValue = instance.getServiceId()) != null) {
                this.serviceId(serviceIdValue);
            }
            if ((serviceInstancesUrlValue = instance.getServiceInstancesUrl()) != null) {
                this.serviceInstancesUrl(serviceInstancesUrlValue);
            }
            if ((serviceUrlValue = instance.getServiceUrl()) != null) {
                this.serviceUrl(serviceUrlValue);
            }
            if ((uniqueIdValue = instance.getUniqueId()) != null) {
                this.uniqueId(uniqueIdValue);
            }
            return this;
        }

        public final Builder active(@Nullable Boolean active) {
            this.active = active;
            return this;
        }

        public final Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        public final Builder extra(@Nullable String extra) {
            this.extra = extra;
            return this;
        }

        public final Builder free(@Nullable Boolean free) {
            this.free = free;
            return this;
        }

        public final Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        public final Builder publiclyVisible(@Nullable Boolean publiclyVisible) {
            this.publiclyVisible = publiclyVisible;
            return this;
        }

        public final Builder serviceId(@Nullable String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public final Builder serviceInstancesUrl(@Nullable String serviceInstancesUrl) {
            this.serviceInstancesUrl = serviceInstancesUrl;
            return this;
        }

        public final Builder serviceUrl(@Nullable String serviceUrl) {
            this.serviceUrl = serviceUrl;
            return this;
        }

        public final Builder uniqueId(@Nullable String uniqueId) {
            this.uniqueId = uniqueId;
            return this;
        }

        public ServicePlanEntity build() {
            return new ServicePlanEntity(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _ServicePlanEntity {
        Boolean active;
        String description;
        String extra;
        Boolean free;
        String name;
        Boolean publiclyVisible;
        String serviceId;
        String serviceInstancesUrl;
        String serviceUrl;
        String uniqueId;

        Json() {
        }

        @JsonProperty(value="active")
        public void setActive(@Nullable Boolean active) {
            this.active = active;
        }

        @JsonProperty(value="description")
        public void setDescription(@Nullable String description) {
            this.description = description;
        }

        @JsonProperty(value="extra")
        public void setExtra(@Nullable String extra) {
            this.extra = extra;
        }

        @JsonProperty(value="free")
        public void setFree(@Nullable Boolean free) {
            this.free = free;
        }

        @JsonProperty(value="name")
        public void setName(@Nullable String name) {
            this.name = name;
        }

        @JsonProperty(value="public")
        public void setPubliclyVisible(@Nullable Boolean publiclyVisible) {
            this.publiclyVisible = publiclyVisible;
        }

        @JsonProperty(value="service_guid")
        public void setServiceId(@Nullable String serviceId) {
            this.serviceId = serviceId;
        }

        @JsonProperty(value="service_instances_url")
        public void setServiceInstancesUrl(@Nullable String serviceInstancesUrl) {
            this.serviceInstancesUrl = serviceInstancesUrl;
        }

        @JsonProperty(value="service_url")
        public void setServiceUrl(@Nullable String serviceUrl) {
            this.serviceUrl = serviceUrl;
        }

        @JsonProperty(value="unique_id")
        public void setUniqueId(@Nullable String uniqueId) {
            this.uniqueId = uniqueId;
        }

        @Override
        public Boolean getActive() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDescription() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getExtra() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getFree() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getPubliclyVisible() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getServiceId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getServiceInstancesUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getServiceUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUniqueId() {
            throw new UnsupportedOperationException();
        }
    }
}

