/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.serviceplans;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.serviceplans._UpdateServicePlanRequest;

public final class UpdateServicePlanRequest
extends _UpdateServicePlanRequest {
    @Nullable
    private final Boolean publiclyVisible;
    private final String servicePlanId;

    private UpdateServicePlanRequest(Builder builder) {
        this.publiclyVisible = builder.publiclyVisible;
        this.servicePlanId = builder.servicePlanId;
    }

    @Override
    @Nullable
    public Boolean getPubliclyVisible() {
        return this.publiclyVisible;
    }

    @Override
    public String getServicePlanId() {
        return this.servicePlanId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UpdateServicePlanRequest && this.equalTo((UpdateServicePlanRequest)another);
    }

    private boolean equalTo(UpdateServicePlanRequest another) {
        return Objects.equals(this.publiclyVisible, another.publiclyVisible) && this.servicePlanId.equals(another.servicePlanId);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.publiclyVisible);
        h = h * 17 + this.servicePlanId.hashCode();
        return h;
    }

    public String toString() {
        return "UpdateServicePlanRequest{publiclyVisible=" + this.publiclyVisible + ", servicePlanId=" + this.servicePlanId + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_SERVICE_PLAN_ID = 1L;
        private long initBits = 1L;
        private Boolean publiclyVisible;
        private String servicePlanId;

        private Builder() {
        }

        public final Builder from(UpdateServicePlanRequest instance) {
            return this.from((_UpdateServicePlanRequest)instance);
        }

        final Builder from(_UpdateServicePlanRequest instance) {
            Objects.requireNonNull(instance, "instance");
            Boolean publiclyVisibleValue = instance.getPubliclyVisible();
            if (publiclyVisibleValue != null) {
                this.publiclyVisible(publiclyVisibleValue);
            }
            this.servicePlanId(instance.getServicePlanId());
            return this;
        }

        public final Builder publiclyVisible(@Nullable Boolean publiclyVisible) {
            this.publiclyVisible = publiclyVisible;
            return this;
        }

        public final Builder servicePlanId(String servicePlanId) {
            this.servicePlanId = Objects.requireNonNull(servicePlanId, "servicePlanId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public UpdateServicePlanRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new UpdateServicePlanRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("servicePlanId");
            }
            return "Cannot build UpdateServicePlanRequest, some of required attributes are not set " + attributes;
        }
    }
}

