/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.serviceplanvisibilities;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.Metadata;
import org.cloudfoundry.client.v2.serviceplanvisibilities.ServicePlanVisibilityEntity;
import org.cloudfoundry.client.v2.serviceplanvisibilities._ServicePlanVisibilityResource;

public final class ServicePlanVisibilityResource
extends _ServicePlanVisibilityResource {
    @Nullable
    private final ServicePlanVisibilityEntity entity;
    @Nullable
    private final Metadata metadata;

    private ServicePlanVisibilityResource(Builder builder) {
        this.entity = builder.entity;
        this.metadata = builder.metadata;
    }

    @Override
    @JsonProperty(value="entity")
    @Nullable
    public ServicePlanVisibilityEntity getEntity() {
        return this.entity;
    }

    @Override
    @JsonProperty(value="metadata")
    @Nullable
    public Metadata getMetadata() {
        return this.metadata;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ServicePlanVisibilityResource && this.equalTo((ServicePlanVisibilityResource)another);
    }

    private boolean equalTo(ServicePlanVisibilityResource another) {
        return Objects.equals(this.entity, another.entity) && Objects.equals(this.metadata, another.metadata);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.entity);
        h = h * 17 + Objects.hashCode(this.metadata);
        return h;
    }

    public String toString() {
        return "ServicePlanVisibilityResource{entity=" + this.entity + ", metadata=" + this.metadata + "}";
    }

    @Deprecated
    @JsonCreator
    static ServicePlanVisibilityResource fromJson(Json json) {
        Builder builder = ServicePlanVisibilityResource.builder();
        if (json.entity != null) {
            builder.entity(json.entity);
        }
        if (json.metadata != null) {
            builder.metadata(json.metadata);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ServicePlanVisibilityEntity entity;
        private Metadata metadata;

        private Builder() {
        }

        public final Builder from(ServicePlanVisibilityResource instance) {
            return this.from((_ServicePlanVisibilityResource)instance);
        }

        final Builder from(_ServicePlanVisibilityResource instance) {
            Metadata metadataValue;
            Objects.requireNonNull(instance, "instance");
            ServicePlanVisibilityEntity entityValue = (ServicePlanVisibilityEntity)instance.getEntity();
            if (entityValue != null) {
                this.entity(entityValue);
            }
            if ((metadataValue = instance.getMetadata()) != null) {
                this.metadata(metadataValue);
            }
            return this;
        }

        public final Builder entity(@Nullable ServicePlanVisibilityEntity entity) {
            this.entity = entity;
            return this;
        }

        public final Builder metadata(@Nullable Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public ServicePlanVisibilityResource build() {
            return new ServicePlanVisibilityResource(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _ServicePlanVisibilityResource {
        ServicePlanVisibilityEntity entity;
        Metadata metadata;

        Json() {
        }

        @JsonProperty(value="entity")
        public void setEntity(@Nullable ServicePlanVisibilityEntity entity) {
            this.entity = entity;
        }

        @JsonProperty(value="metadata")
        public void setMetadata(@Nullable Metadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public ServicePlanVisibilityEntity getEntity() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Metadata getMetadata() {
            throw new UnsupportedOperationException();
        }
    }
}

