/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.spaces;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.spaces._DeleteSpaceRequest;

public final class DeleteSpaceRequest
extends _DeleteSpaceRequest {
    @Nullable
    private final Boolean async;
    private final String spaceId;

    private DeleteSpaceRequest(Builder builder) {
        this.async = builder.async;
        this.spaceId = builder.spaceId;
    }

    @Override
    @Nullable
    public Boolean getAsync() {
        return this.async;
    }

    @Override
    public String getSpaceId() {
        return this.spaceId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof DeleteSpaceRequest && this.equalTo((DeleteSpaceRequest)another);
    }

    private boolean equalTo(DeleteSpaceRequest another) {
        return Objects.equals(this.async, another.async) && this.spaceId.equals(another.spaceId);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.async);
        h = h * 17 + this.spaceId.hashCode();
        return h;
    }

    public String toString() {
        return "DeleteSpaceRequest{async=" + this.async + ", spaceId=" + this.spaceId + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_SPACE_ID = 1L;
        private long initBits = 1L;
        private Boolean async;
        private String spaceId;

        private Builder() {
        }

        public final Builder from(DeleteSpaceRequest instance) {
            return this.from((_DeleteSpaceRequest)instance);
        }

        final Builder from(_DeleteSpaceRequest instance) {
            Objects.requireNonNull(instance, "instance");
            Boolean asyncValue = instance.getAsync();
            if (asyncValue != null) {
                this.async(asyncValue);
            }
            this.spaceId(instance.getSpaceId());
            return this;
        }

        public final Builder async(@Nullable Boolean async) {
            this.async = async;
            return this;
        }

        public final Builder spaceId(String spaceId) {
            this.spaceId = Objects.requireNonNull(spaceId, "spaceId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public DeleteSpaceRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new DeleteSpaceRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("spaceId");
            }
            return "Cannot build DeleteSpaceRequest, some of required attributes are not set " + attributes;
        }
    }
}

