/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.stacks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.Metadata;
import org.cloudfoundry.client.v2.stacks.StackEntity;
import org.cloudfoundry.client.v2.stacks._StackResource;

public final class StackResource
extends _StackResource {
    @Nullable
    private final StackEntity entity;
    @Nullable
    private final Metadata metadata;

    private StackResource(Builder builder) {
        this.entity = builder.entity;
        this.metadata = builder.metadata;
    }

    @Override
    @JsonProperty(value="entity")
    @Nullable
    public StackEntity getEntity() {
        return this.entity;
    }

    @Override
    @JsonProperty(value="metadata")
    @Nullable
    public Metadata getMetadata() {
        return this.metadata;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof StackResource && this.equalTo((StackResource)another);
    }

    private boolean equalTo(StackResource another) {
        return Objects.equals(this.entity, another.entity) && Objects.equals(this.metadata, another.metadata);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.entity);
        h = h * 17 + Objects.hashCode(this.metadata);
        return h;
    }

    public String toString() {
        return "StackResource{entity=" + this.entity + ", metadata=" + this.metadata + "}";
    }

    @Deprecated
    @JsonCreator
    static StackResource fromJson(Json json) {
        Builder builder = StackResource.builder();
        if (json.entity != null) {
            builder.entity(json.entity);
        }
        if (json.metadata != null) {
            builder.metadata(json.metadata);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private StackEntity entity;
        private Metadata metadata;

        private Builder() {
        }

        public final Builder from(StackResource instance) {
            return this.from((_StackResource)instance);
        }

        final Builder from(_StackResource instance) {
            Metadata metadataValue;
            Objects.requireNonNull(instance, "instance");
            StackEntity entityValue = (StackEntity)instance.getEntity();
            if (entityValue != null) {
                this.entity(entityValue);
            }
            if ((metadataValue = instance.getMetadata()) != null) {
                this.metadata(metadataValue);
            }
            return this;
        }

        public final Builder entity(@Nullable StackEntity entity) {
            this.entity = entity;
            return this;
        }

        public final Builder metadata(@Nullable Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public StackResource build() {
            return new StackResource(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _StackResource {
        StackEntity entity;
        Metadata metadata;

        Json() {
        }

        @JsonProperty(value="entity")
        public void setEntity(@Nullable StackEntity entity) {
            this.entity = entity;
        }

        @JsonProperty(value="metadata")
        public void setMetadata(@Nullable Metadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public StackEntity getEntity() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Metadata getMetadata() {
            throw new UnsupportedOperationException();
        }
    }
}

