/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3._Hash;

public final class Hash
extends _Hash {
    @Nullable
    private final String type;
    @Nullable
    private final String value;

    private Hash(Builder builder) {
        this.type = builder.type;
        this.value = builder.value;
    }

    @Override
    @JsonProperty(value="type")
    @Nullable
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty(value="value")
    @Nullable
    public String getValue() {
        return this.value;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Hash && this.equalTo((Hash)another);
    }

    private boolean equalTo(Hash another) {
        return Objects.equals(this.type, another.type) && Objects.equals(this.value, another.value);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.type);
        h = h * 17 + Objects.hashCode(this.value);
        return h;
    }

    public String toString() {
        return "Hash{type=" + this.type + ", value=" + this.value + "}";
    }

    @Deprecated
    @JsonCreator
    static Hash fromJson(Json json) {
        Builder builder = Hash.builder();
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.value != null) {
            builder.value(json.value);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String type;
        private String value;

        private Builder() {
        }

        public final Builder from(Hash instance) {
            return this.from((_Hash)instance);
        }

        final Builder from(_Hash instance) {
            String valueValue;
            Objects.requireNonNull(instance, "instance");
            String typeValue = instance.getType();
            if (typeValue != null) {
                this.type(typeValue);
            }
            if ((valueValue = instance.getValue()) != null) {
                this.value(valueValue);
            }
            return this;
        }

        public final Builder type(@Nullable String type) {
            this.type = type;
            return this;
        }

        public final Builder value(@Nullable String value) {
            this.value = value;
            return this;
        }

        public Hash build() {
            return new Hash(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _Hash {
        String type;
        String value;

        Json() {
        }

        @JsonProperty(value="type")
        public void setType(@Nullable String type) {
            this.type = type;
        }

        @JsonProperty(value="value")
        public void setValue(@Nullable String value) {
            this.value = value;
        }

        @Override
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getValue() {
            throw new UnsupportedOperationException();
        }
    }
}

