/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.applications;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.client.v3.applications._CancelApplicationTaskRequest;

public final class CancelApplicationTaskRequest
extends _CancelApplicationTaskRequest {
    private final String applicationId;
    private final String taskId;

    private CancelApplicationTaskRequest(Builder builder) {
        this.applicationId = builder.applicationId;
        this.taskId = builder.taskId;
    }

    @Override
    public String getApplicationId() {
        return this.applicationId;
    }

    @Override
    public String getTaskId() {
        return this.taskId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CancelApplicationTaskRequest && this.equalTo((CancelApplicationTaskRequest)another);
    }

    private boolean equalTo(CancelApplicationTaskRequest another) {
        return this.applicationId.equals(another.applicationId) && this.taskId.equals(another.taskId);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.applicationId.hashCode();
        h = h * 17 + this.taskId.hashCode();
        return h;
    }

    public String toString() {
        return "CancelApplicationTaskRequest{applicationId=" + this.applicationId + ", taskId=" + this.taskId + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_APPLICATION_ID = 1L;
        private static final long INIT_BIT_TASK_ID = 2L;
        private long initBits = 3L;
        private String applicationId;
        private String taskId;

        private Builder() {
        }

        public final Builder from(CancelApplicationTaskRequest instance) {
            return this.from((_CancelApplicationTaskRequest)instance);
        }

        final Builder from(_CancelApplicationTaskRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.applicationId(instance.getApplicationId());
            this.taskId(instance.getTaskId());
            return this;
        }

        public final Builder applicationId(String applicationId) {
            this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder taskId(String taskId) {
            this.taskId = Objects.requireNonNull(taskId, "taskId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public CancelApplicationTaskRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CancelApplicationTaskRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("applicationId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("taskId");
            }
            return "Cannot build CancelApplicationTaskRequest, some of required attributes are not set " + attributes;
        }
    }
}

