/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.applications;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Link;
import org.cloudfoundry.client.v3.applications._GetApplicationTaskResponse;
import org.cloudfoundry.client.v3.tasks.Result;
import org.cloudfoundry.client.v3.tasks.State;
import org.cloudfoundry.client.v3.tasks.Task;

public final class GetApplicationTaskResponse
extends _GetApplicationTaskResponse {
    @Nullable
    private final String command;
    @Nullable
    private final String createdAt;
    @Nullable
    private final Map<String, String> environmentVariables;
    @Nullable
    private final String id;
    @Nullable
    private final Map<String, Link> links;
    @Nullable
    private final Integer memoryInMb;
    @Nullable
    private final String name;
    @Nullable
    private final Result result;
    @Nullable
    private final State state;
    @Nullable
    private final String updatedAt;

    private GetApplicationTaskResponse(Builder builder) {
        this.command = builder.command;
        this.createdAt = builder.createdAt;
        this.environmentVariables = builder.environmentVariables == null ? null : GetApplicationTaskResponse.createUnmodifiableMap(false, false, builder.environmentVariables);
        this.id = builder.id;
        this.links = builder.links == null ? null : GetApplicationTaskResponse.createUnmodifiableMap(false, false, builder.links);
        this.memoryInMb = builder.memoryInMb;
        this.name = builder.name;
        this.result = builder.result;
        this.state = builder.state;
        this.updatedAt = builder.updatedAt;
    }

    @Override
    @JsonProperty(value="command")
    @Nullable
    public String getCommand() {
        return this.command;
    }

    @Override
    @JsonProperty(value="created_at")
    @Nullable
    public String getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty(value="environment_variables")
    @Nullable
    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    @Override
    @JsonProperty(value="guid")
    @Nullable
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="links")
    @Nullable
    public Map<String, Link> getLinks() {
        return this.links;
    }

    @Override
    @JsonProperty(value="memory_in_mb")
    @Nullable
    public Integer getMemoryInMb() {
        return this.memoryInMb;
    }

    @Override
    @JsonProperty(value="name")
    @Nullable
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="result")
    @Nullable
    public Result getResult() {
        return this.result;
    }

    @Override
    @JsonProperty(value="state")
    @Nullable
    public State getState() {
        return this.state;
    }

    @Override
    @JsonProperty(value="updated_at")
    @Nullable
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GetApplicationTaskResponse && this.equalTo((GetApplicationTaskResponse)another);
    }

    private boolean equalTo(GetApplicationTaskResponse another) {
        return Objects.equals(this.command, another.command) && Objects.equals(this.createdAt, another.createdAt) && Objects.equals(this.environmentVariables, another.environmentVariables) && Objects.equals(this.id, another.id) && Objects.equals(this.links, another.links) && Objects.equals(this.memoryInMb, another.memoryInMb) && Objects.equals(this.name, another.name) && Objects.equals(this.result, another.result) && Objects.equals((Object)this.state, (Object)another.state) && Objects.equals(this.updatedAt, another.updatedAt);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.command);
        h = h * 17 + Objects.hashCode(this.createdAt);
        h = h * 17 + Objects.hashCode(this.environmentVariables);
        h = h * 17 + Objects.hashCode(this.id);
        h = h * 17 + Objects.hashCode(this.links);
        h = h * 17 + Objects.hashCode(this.memoryInMb);
        h = h * 17 + Objects.hashCode(this.name);
        h = h * 17 + Objects.hashCode(this.result);
        h = h * 17 + Objects.hashCode((Object)this.state);
        h = h * 17 + Objects.hashCode(this.updatedAt);
        return h;
    }

    public String toString() {
        return "GetApplicationTaskResponse{command=" + this.command + ", createdAt=" + this.createdAt + ", environmentVariables=" + this.environmentVariables + ", id=" + this.id + ", links=" + this.links + ", memoryInMb=" + this.memoryInMb + ", name=" + this.name + ", result=" + this.result + ", state=" + (Object)((Object)this.state) + ", updatedAt=" + this.updatedAt + "}";
    }

    @Deprecated
    @JsonCreator
    static GetApplicationTaskResponse fromJson(Json json) {
        Builder builder = GetApplicationTaskResponse.builder();
        if (json.command != null) {
            builder.command(json.command);
        }
        if (json.createdAt != null) {
            builder.createdAt(json.createdAt);
        }
        if (json.environmentVariables != null) {
            builder.putAllEnvironmentVariables(json.environmentVariables);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.links != null) {
            builder.putAllLinks(json.links);
        }
        if (json.memoryInMb != null) {
            builder.memoryInMb(json.memoryInMb);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.result != null) {
            builder.result(json.result);
        }
        if (json.state != null) {
            builder.state(json.state);
        }
        if (json.updatedAt != null) {
            builder.updatedAt(json.updatedAt);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    public static final class Builder {
        private String command;
        private String createdAt;
        private Map<String, String> environmentVariables = null;
        private String id;
        private Map<String, Link> links = null;
        private Integer memoryInMb;
        private String name;
        private Result result;
        private State state;
        private String updatedAt;

        private Builder() {
        }

        public final Builder from(Task instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GetApplicationTaskResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        final Builder from(_GetApplicationTaskResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            if (object instanceof Task) {
                String updatedAtValue;
                String commandValue;
                State stateValue;
                String idValue;
                Map<String, Link> linksValue;
                String nameValue;
                Integer memoryInMbValue;
                Map<String, String> environmentVariablesValue;
                String createdAtValue;
                Task instance = (Task)object;
                Result resultValue = instance.getResult();
                if (resultValue != null) {
                    this.result(resultValue);
                }
                if ((createdAtValue = instance.getCreatedAt()) != null) {
                    this.createdAt(createdAtValue);
                }
                if ((environmentVariablesValue = instance.getEnvironmentVariables()) != null) {
                    this.putAllEnvironmentVariables(environmentVariablesValue);
                }
                if ((memoryInMbValue = instance.getMemoryInMb()) != null) {
                    this.memoryInMb(memoryInMbValue);
                }
                if ((nameValue = instance.getName()) != null) {
                    this.name(nameValue);
                }
                if ((linksValue = instance.getLinks()) != null) {
                    this.putAllLinks(linksValue);
                }
                if ((idValue = instance.getId()) != null) {
                    this.id(idValue);
                }
                if ((stateValue = instance.getState()) != null) {
                    this.state(stateValue);
                }
                if ((commandValue = instance.getCommand()) != null) {
                    this.command(commandValue);
                }
                if ((updatedAtValue = instance.getUpdatedAt()) != null) {
                    this.updatedAt(updatedAtValue);
                }
            }
        }

        public final Builder command(@Nullable String command) {
            this.command = command;
            return this;
        }

        public final Builder createdAt(@Nullable String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Builder environmentVariable(String key, String value) {
            if (this.environmentVariables == null) {
                this.environmentVariables = new LinkedHashMap<String, String>();
            }
            this.environmentVariables.put(Objects.requireNonNull(key, "environmentVariables key"), Objects.requireNonNull(value, "environmentVariables value"));
            return this;
        }

        public final Builder environmentVariable(Map.Entry<String, ? extends String> entry) {
            if (this.environmentVariables == null) {
                this.environmentVariables = new LinkedHashMap<String, String>();
            }
            String k = entry.getKey();
            String v = entry.getValue();
            this.environmentVariables.put(Objects.requireNonNull(k, "environmentVariables key"), Objects.requireNonNull(v, "environmentVariables value"));
            return this;
        }

        public final Builder environmentVariables(@Nullable Map<String, ? extends String> environmentVariables) {
            if (environmentVariables == null) {
                this.environmentVariables = null;
                return this;
            }
            this.environmentVariables = new LinkedHashMap<String, String>();
            return this.putAllEnvironmentVariables(environmentVariables);
        }

        public final Builder putAllEnvironmentVariables(Map<String, ? extends String> environmentVariables) {
            if (this.environmentVariables == null) {
                this.environmentVariables = new LinkedHashMap<String, String>();
            }
            for (Map.Entry<String, ? extends String> entry : environmentVariables.entrySet()) {
                String k = entry.getKey();
                String v = entry.getValue();
                this.environmentVariables.put(Objects.requireNonNull(k, "environmentVariables key"), Objects.requireNonNull(v, "environmentVariables value"));
            }
            return this;
        }

        public final Builder id(@Nullable String id) {
            this.id = id;
            return this;
        }

        public final Builder link(String key, Link value) {
            if (this.links == null) {
                this.links = new LinkedHashMap<String, Link>();
            }
            this.links.put(Objects.requireNonNull(key, "links key"), Objects.requireNonNull(value, "links value"));
            return this;
        }

        public final Builder link(Map.Entry<String, ? extends Link> entry) {
            if (this.links == null) {
                this.links = new LinkedHashMap<String, Link>();
            }
            String k = entry.getKey();
            Link v = entry.getValue();
            this.links.put(Objects.requireNonNull(k, "links key"), Objects.requireNonNull(v, "links value"));
            return this;
        }

        public final Builder links(@Nullable Map<String, ? extends Link> links) {
            if (links == null) {
                this.links = null;
                return this;
            }
            this.links = new LinkedHashMap<String, Link>();
            return this.putAllLinks(links);
        }

        public final Builder putAllLinks(Map<String, ? extends Link> links) {
            if (this.links == null) {
                this.links = new LinkedHashMap<String, Link>();
            }
            for (Map.Entry<String, ? extends Link> entry : links.entrySet()) {
                String k = entry.getKey();
                Link v = entry.getValue();
                this.links.put(Objects.requireNonNull(k, "links key"), Objects.requireNonNull(v, "links value"));
            }
            return this;
        }

        public final Builder memoryInMb(@Nullable Integer memoryInMb) {
            this.memoryInMb = memoryInMb;
            return this;
        }

        public final Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        public final Builder result(@Nullable Result result) {
            this.result = result;
            return this;
        }

        public final Builder state(@Nullable State state) {
            this.state = state;
            return this;
        }

        public final Builder updatedAt(@Nullable String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public GetApplicationTaskResponse build() {
            return new GetApplicationTaskResponse(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _GetApplicationTaskResponse {
        String command;
        String createdAt;
        Map<String, String> environmentVariables;
        String id;
        Map<String, Link> links;
        Integer memoryInMb;
        String name;
        Result result;
        State state;
        String updatedAt;

        Json() {
        }

        @JsonProperty(value="command")
        public void setCommand(@Nullable String command) {
            this.command = command;
        }

        @JsonProperty(value="created_at")
        public void setCreatedAt(@Nullable String createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty(value="environment_variables")
        public void setEnvironmentVariables(@Nullable Map<String, String> environmentVariables) {
            this.environmentVariables = environmentVariables;
        }

        @JsonProperty(value="guid")
        public void setId(@Nullable String id) {
            this.id = id;
        }

        @JsonProperty(value="links")
        public void setLinks(@Nullable Map<String, Link> links) {
            this.links = links;
        }

        @JsonProperty(value="memory_in_mb")
        public void setMemoryInMb(@Nullable Integer memoryInMb) {
            this.memoryInMb = memoryInMb;
        }

        @JsonProperty(value="name")
        public void setName(@Nullable String name) {
            this.name = name;
        }

        @JsonProperty(value="result")
        public void setResult(@Nullable Result result) {
            this.result = result;
        }

        @JsonProperty(value="state")
        public void setState(@Nullable State state) {
            this.state = state;
        }

        @JsonProperty(value="updated_at")
        public void setUpdatedAt(@Nullable String updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public String getCommand() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCreatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> getEnvironmentVariables() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Link> getLinks() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getMemoryInMb() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Result getResult() {
            throw new UnsupportedOperationException();
        }

        @Override
        public State getState() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUpdatedAt() {
            throw new UnsupportedOperationException();
        }
    }
}

