/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.applications;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.PaginatedRequest;
import org.cloudfoundry.client.v3.applications._ListApplicationProcessesRequest;

public final class ListApplicationProcessesRequest
extends _ListApplicationProcessesRequest {
    private final String applicationId;
    @Nullable
    private final Integer page;
    @Nullable
    private final Integer perPage;

    private ListApplicationProcessesRequest(Builder builder) {
        this.applicationId = builder.applicationId;
        this.page = builder.page;
        this.perPage = builder.perPage;
    }

    @Override
    public String getApplicationId() {
        return this.applicationId;
    }

    @Override
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @Override
    @Nullable
    public Integer getPerPage() {
        return this.perPage;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListApplicationProcessesRequest && this.equalTo((ListApplicationProcessesRequest)another);
    }

    private boolean equalTo(ListApplicationProcessesRequest another) {
        return this.applicationId.equals(another.applicationId) && Objects.equals(this.page, another.page) && Objects.equals(this.perPage, another.perPage);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.applicationId.hashCode();
        h = h * 17 + Objects.hashCode(this.page);
        h = h * 17 + Objects.hashCode(this.perPage);
        return h;
    }

    public String toString() {
        return "ListApplicationProcessesRequest{applicationId=" + this.applicationId + ", page=" + this.page + ", perPage=" + this.perPage + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_APPLICATION_ID = 1L;
        private long initBits = 1L;
        private String applicationId;
        private Integer page;
        private Integer perPage;

        private Builder() {
        }

        public final Builder from(ListApplicationProcessesRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        final Builder from(_ListApplicationProcessesRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PaginatedRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PaginatedRequest instance;
            if (object instanceof _ListApplicationProcessesRequest) {
                instance = (_ListApplicationProcessesRequest)object;
                this.applicationId(((_ListApplicationProcessesRequest)instance).getApplicationId());
            }
            if (object instanceof PaginatedRequest) {
                Integer pageValue;
                instance = (PaginatedRequest)object;
                Integer perPageValue = instance.getPerPage();
                if (perPageValue != null) {
                    this.perPage(perPageValue);
                }
                if ((pageValue = instance.getPage()) != null) {
                    this.page(pageValue);
                }
            }
        }

        public final Builder applicationId(String applicationId) {
            this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder page(@Nullable Integer page) {
            this.page = page;
            return this;
        }

        public final Builder perPage(@Nullable Integer perPage) {
            this.perPage = perPage;
            return this;
        }

        public ListApplicationProcessesRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ListApplicationProcessesRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("applicationId");
            }
            return "Cannot build ListApplicationProcessesRequest, some of required attributes are not set " + attributes;
        }
    }
}

