/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.applications;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.PaginatedAndSortedRequest;
import org.cloudfoundry.client.v3.PaginatedRequest;
import org.cloudfoundry.client.v3.applications._ListApplicationsRequest;

public final class ListApplicationsRequest
extends _ListApplicationsRequest {
    private final List<String> ids;
    private final List<String> names;
    private final List<String> organizationIds;
    private final List<String> spaceIds;
    @Nullable
    private final String orderBy;
    @Nullable
    private final Integer page;
    @Nullable
    private final Integer perPage;

    private ListApplicationsRequest(Builder builder) {
        this.ids = ListApplicationsRequest.createUnmodifiableList(true, builder.ids);
        this.names = ListApplicationsRequest.createUnmodifiableList(true, builder.names);
        this.organizationIds = ListApplicationsRequest.createUnmodifiableList(true, builder.organizationIds);
        this.spaceIds = ListApplicationsRequest.createUnmodifiableList(true, builder.spaceIds);
        this.orderBy = builder.orderBy;
        this.page = builder.page;
        this.perPage = builder.perPage;
    }

    @Override
    public List<String> getIds() {
        return this.ids;
    }

    @Override
    public List<String> getNames() {
        return this.names;
    }

    @Override
    public List<String> getOrganizationIds() {
        return this.organizationIds;
    }

    @Override
    public List<String> getSpaceIds() {
        return this.spaceIds;
    }

    @Override
    @Nullable
    public String getOrderBy() {
        return this.orderBy;
    }

    @Override
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @Override
    @Nullable
    public Integer getPerPage() {
        return this.perPage;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListApplicationsRequest && this.equalTo((ListApplicationsRequest)another);
    }

    private boolean equalTo(ListApplicationsRequest another) {
        return this.ids.equals(another.ids) && this.names.equals(another.names) && this.organizationIds.equals(another.organizationIds) && this.spaceIds.equals(another.spaceIds) && Objects.equals(this.orderBy, another.orderBy) && Objects.equals(this.page, another.page) && Objects.equals(this.perPage, another.perPage);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.ids.hashCode();
        h = h * 17 + this.names.hashCode();
        h = h * 17 + this.organizationIds.hashCode();
        h = h * 17 + this.spaceIds.hashCode();
        h = h * 17 + Objects.hashCode(this.orderBy);
        h = h * 17 + Objects.hashCode(this.page);
        h = h * 17 + Objects.hashCode(this.perPage);
        return h;
    }

    public String toString() {
        return "ListApplicationsRequest{ids=" + this.ids + ", names=" + this.names + ", organizationIds=" + this.organizationIds + ", spaceIds=" + this.spaceIds + ", orderBy=" + this.orderBy + ", page=" + this.page + ", perPage=" + this.perPage + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private List<String> ids = new ArrayList<String>();
        private List<String> names = new ArrayList<String>();
        private List<String> organizationIds = new ArrayList<String>();
        private List<String> spaceIds = new ArrayList<String>();
        private String orderBy;
        private Integer page;
        private Integer perPage;

        private Builder() {
        }

        public final Builder from(PaginatedRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ListApplicationsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        final Builder from(_ListApplicationsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PaginatedAndSortedRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            String orderByValue;
            PaginatedRequest instance;
            if (object instanceof PaginatedRequest) {
                Integer pageValue;
                instance = (PaginatedRequest)object;
                Integer perPageValue = instance.getPerPage();
                if (perPageValue != null) {
                    this.perPage(perPageValue);
                }
                if ((pageValue = instance.getPage()) != null) {
                    this.page(pageValue);
                }
            }
            if (object instanceof _ListApplicationsRequest) {
                instance = (_ListApplicationsRequest)object;
                this.addAllIds(((_ListApplicationsRequest)instance).getIds());
                this.addAllNames(((_ListApplicationsRequest)instance).getNames());
                this.addAllSpaceIds(((_ListApplicationsRequest)instance).getSpaceIds());
                this.addAllOrganizationIds(((_ListApplicationsRequest)instance).getOrganizationIds());
            }
            if (object instanceof PaginatedAndSortedRequest && (orderByValue = ((PaginatedAndSortedRequest)(instance = (PaginatedAndSortedRequest)object)).getOrderBy()) != null) {
                this.orderBy(orderByValue);
            }
        }

        public final Builder id(String element) {
            this.ids.add(Objects.requireNonNull(element, "ids element"));
            return this;
        }

        public final Builder id(String ... elements) {
            for (String element : elements) {
                this.ids.add(Objects.requireNonNull(element, "ids element"));
            }
            return this;
        }

        public final Builder ids(Iterable<String> elements) {
            this.ids.clear();
            return this.addAllIds(elements);
        }

        public final Builder addAllIds(Iterable<String> elements) {
            for (String element : elements) {
                this.ids.add(Objects.requireNonNull(element, "ids element"));
            }
            return this;
        }

        public final Builder name(String element) {
            this.names.add(Objects.requireNonNull(element, "names element"));
            return this;
        }

        public final Builder name(String ... elements) {
            for (String element : elements) {
                this.names.add(Objects.requireNonNull(element, "names element"));
            }
            return this;
        }

        public final Builder names(Iterable<String> elements) {
            this.names.clear();
            return this.addAllNames(elements);
        }

        public final Builder addAllNames(Iterable<String> elements) {
            for (String element : elements) {
                this.names.add(Objects.requireNonNull(element, "names element"));
            }
            return this;
        }

        public final Builder organizationId(String element) {
            this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
            return this;
        }

        public final Builder organizationId(String ... elements) {
            for (String element : elements) {
                this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
            }
            return this;
        }

        public final Builder organizationIds(Iterable<String> elements) {
            this.organizationIds.clear();
            return this.addAllOrganizationIds(elements);
        }

        public final Builder addAllOrganizationIds(Iterable<String> elements) {
            for (String element : elements) {
                this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
            }
            return this;
        }

        public final Builder spaceId(String element) {
            this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
            return this;
        }

        public final Builder spaceId(String ... elements) {
            for (String element : elements) {
                this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
            }
            return this;
        }

        public final Builder spaceIds(Iterable<String> elements) {
            this.spaceIds.clear();
            return this.addAllSpaceIds(elements);
        }

        public final Builder addAllSpaceIds(Iterable<String> elements) {
            for (String element : elements) {
                this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
            }
            return this;
        }

        public final Builder orderBy(@Nullable String orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        public final Builder page(@Nullable Integer page) {
            this.page = page;
            return this;
        }

        public final Builder perPage(@Nullable Integer perPage) {
            this.perPage = perPage;
            return this;
        }

        public ListApplicationsRequest build() {
            return new ListApplicationsRequest(this);
        }
    }
}

