/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.applications;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.client.v3.Relationship;
import org.cloudfoundry.client.v3.applications._Relationships;

public final class Relationships
extends _Relationships {
    private final Relationship space;

    private Relationships(Builder builder) {
        this.space = builder.space;
    }

    @Override
    public Relationship getSpace() {
        return this.space;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Relationships && this.equalTo((Relationships)another);
    }

    private boolean equalTo(Relationships another) {
        return this.space.equals(another.space);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.space.hashCode();
        return h;
    }

    public String toString() {
        return "Relationships{space=" + this.space + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_SPACE = 1L;
        private long initBits = 1L;
        private Relationship space;

        private Builder() {
        }

        public final Builder from(Relationships instance) {
            return this.from((_Relationships)instance);
        }

        final Builder from(_Relationships instance) {
            Objects.requireNonNull(instance, "instance");
            this.space(instance.getSpace());
            return this;
        }

        public final Builder space(Relationship space) {
            this.space = Objects.requireNonNull(space, "space");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public Relationships build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new Relationships(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("space");
            }
            return "Cannot build Relationships, some of required attributes are not set " + attributes;
        }
    }
}

