/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.applications;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.applications._ScaleApplicationRequest;

public final class ScaleApplicationRequest
extends _ScaleApplicationRequest {
    private final String applicationId;
    @Nullable
    private final Integer diskInMb;
    @Nullable
    private final Integer instances;
    @Nullable
    private final Integer memoryInMb;
    private final String type;

    private ScaleApplicationRequest(Builder builder) {
        this.applicationId = builder.applicationId;
        this.diskInMb = builder.diskInMb;
        this.instances = builder.instances;
        this.memoryInMb = builder.memoryInMb;
        this.type = builder.type;
    }

    @Override
    public String getApplicationId() {
        return this.applicationId;
    }

    @Override
    @Nullable
    public Integer getDiskInMb() {
        return this.diskInMb;
    }

    @Override
    @Nullable
    public Integer getInstances() {
        return this.instances;
    }

    @Override
    @Nullable
    public Integer getMemoryInMb() {
        return this.memoryInMb;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ScaleApplicationRequest && this.equalTo((ScaleApplicationRequest)another);
    }

    private boolean equalTo(ScaleApplicationRequest another) {
        return this.applicationId.equals(another.applicationId) && Objects.equals(this.diskInMb, another.diskInMb) && Objects.equals(this.instances, another.instances) && Objects.equals(this.memoryInMb, another.memoryInMb) && this.type.equals(another.type);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.applicationId.hashCode();
        h = h * 17 + Objects.hashCode(this.diskInMb);
        h = h * 17 + Objects.hashCode(this.instances);
        h = h * 17 + Objects.hashCode(this.memoryInMb);
        h = h * 17 + this.type.hashCode();
        return h;
    }

    public String toString() {
        return "ScaleApplicationRequest{applicationId=" + this.applicationId + ", diskInMb=" + this.diskInMb + ", instances=" + this.instances + ", memoryInMb=" + this.memoryInMb + ", type=" + this.type + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_APPLICATION_ID = 1L;
        private static final long INIT_BIT_TYPE = 2L;
        private long initBits = 3L;
        private String applicationId;
        private Integer diskInMb;
        private Integer instances;
        private Integer memoryInMb;
        private String type;

        private Builder() {
        }

        public final Builder from(ScaleApplicationRequest instance) {
            return this.from((_ScaleApplicationRequest)instance);
        }

        final Builder from(_ScaleApplicationRequest instance) {
            Integer memoryInMbValue;
            Integer instancesValue;
            Objects.requireNonNull(instance, "instance");
            this.applicationId(instance.getApplicationId());
            Integer diskInMbValue = instance.getDiskInMb();
            if (diskInMbValue != null) {
                this.diskInMb(diskInMbValue);
            }
            if ((instancesValue = instance.getInstances()) != null) {
                this.instances(instancesValue);
            }
            if ((memoryInMbValue = instance.getMemoryInMb()) != null) {
                this.memoryInMb(memoryInMbValue);
            }
            this.type(instance.getType());
            return this;
        }

        public final Builder applicationId(String applicationId) {
            this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder diskInMb(@Nullable Integer diskInMb) {
            this.diskInMb = diskInMb;
            return this;
        }

        public final Builder instances(@Nullable Integer instances) {
            this.instances = instances;
            return this;
        }

        public final Builder memoryInMb(@Nullable Integer memoryInMb) {
            this.memoryInMb = memoryInMb;
            return this;
        }

        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ScaleApplicationRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ScaleApplicationRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("applicationId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build ScaleApplicationRequest, some of required attributes are not set " + attributes;
        }
    }
}

