/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.applications;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.client.v3.applications._TerminateApplicationInstanceRequest;

public final class TerminateApplicationInstanceRequest
extends _TerminateApplicationInstanceRequest {
    private final String applicationId;
    private final String index;
    private final String type;

    private TerminateApplicationInstanceRequest(Builder builder) {
        this.applicationId = builder.applicationId;
        this.index = builder.index;
        this.type = builder.type;
    }

    @Override
    public String getApplicationId() {
        return this.applicationId;
    }

    @Override
    public String getIndex() {
        return this.index;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof TerminateApplicationInstanceRequest && this.equalTo((TerminateApplicationInstanceRequest)another);
    }

    private boolean equalTo(TerminateApplicationInstanceRequest another) {
        return this.applicationId.equals(another.applicationId) && this.index.equals(another.index) && this.type.equals(another.type);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.applicationId.hashCode();
        h = h * 17 + this.index.hashCode();
        h = h * 17 + this.type.hashCode();
        return h;
    }

    public String toString() {
        return "TerminateApplicationInstanceRequest{applicationId=" + this.applicationId + ", index=" + this.index + ", type=" + this.type + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_APPLICATION_ID = 1L;
        private static final long INIT_BIT_INDEX = 2L;
        private static final long INIT_BIT_TYPE = 4L;
        private long initBits = 7L;
        private String applicationId;
        private String index;
        private String type;

        private Builder() {
        }

        public final Builder from(TerminateApplicationInstanceRequest instance) {
            return this.from((_TerminateApplicationInstanceRequest)instance);
        }

        final Builder from(_TerminateApplicationInstanceRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.applicationId(instance.getApplicationId());
            this.index(instance.getIndex());
            this.type(instance.getType());
            return this;
        }

        public final Builder applicationId(String applicationId) {
            this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder index(String index) {
            this.index = Objects.requireNonNull(index, "index");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public TerminateApplicationInstanceRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new TerminateApplicationInstanceRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("applicationId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("index");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build TerminateApplicationInstanceRequest, some of required attributes are not set " + attributes;
        }
    }
}

