/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.applications;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Lifecycle;
import org.cloudfoundry.client.v3.applications._UpdateApplicationRequest;

public final class UpdateApplicationRequest
extends _UpdateApplicationRequest {
    private final String applicationId;
    @Nullable
    private final Map<String, Object> environmentVariables;
    @Nullable
    private final Lifecycle lifecycle;
    @Nullable
    private final String name;

    private UpdateApplicationRequest(Builder builder) {
        this.applicationId = builder.applicationId;
        this.environmentVariables = builder.environmentVariables == null ? null : UpdateApplicationRequest.createUnmodifiableMap(false, false, builder.environmentVariables);
        this.lifecycle = builder.lifecycle;
        this.name = builder.name;
    }

    @Override
    public String getApplicationId() {
        return this.applicationId;
    }

    @Override
    @Nullable
    public Map<String, Object> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    @Override
    @Nullable
    public Lifecycle getLifecycle() {
        return this.lifecycle;
    }

    @Override
    @Nullable
    public String getName() {
        return this.name;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UpdateApplicationRequest && this.equalTo((UpdateApplicationRequest)another);
    }

    private boolean equalTo(UpdateApplicationRequest another) {
        return this.applicationId.equals(another.applicationId) && Objects.equals(this.environmentVariables, another.environmentVariables) && Objects.equals(this.lifecycle, another.lifecycle) && Objects.equals(this.name, another.name);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.applicationId.hashCode();
        h = h * 17 + Objects.hashCode(this.environmentVariables);
        h = h * 17 + Objects.hashCode(this.lifecycle);
        h = h * 17 + Objects.hashCode(this.name);
        return h;
    }

    public String toString() {
        return "UpdateApplicationRequest{applicationId=" + this.applicationId + ", environmentVariables=" + this.environmentVariables + ", lifecycle=" + this.lifecycle + ", name=" + this.name + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    public static final class Builder {
        private static final long INIT_BIT_APPLICATION_ID = 1L;
        private long initBits = 1L;
        private String applicationId;
        private Map<String, Object> environmentVariables = null;
        private Lifecycle lifecycle;
        private String name;

        private Builder() {
        }

        public final Builder from(UpdateApplicationRequest instance) {
            return this.from((_UpdateApplicationRequest)instance);
        }

        final Builder from(_UpdateApplicationRequest instance) {
            String nameValue;
            Lifecycle lifecycleValue;
            Objects.requireNonNull(instance, "instance");
            this.applicationId(instance.getApplicationId());
            Map<String, Object> environmentVariablesValue = instance.getEnvironmentVariables();
            if (environmentVariablesValue != null) {
                this.putAllEnvironmentVariables(environmentVariablesValue);
            }
            if ((lifecycleValue = instance.getLifecycle()) != null) {
                this.lifecycle(lifecycleValue);
            }
            if ((nameValue = instance.getName()) != null) {
                this.name(nameValue);
            }
            return this;
        }

        public final Builder applicationId(String applicationId) {
            this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder environmentVariable(String key, Object value) {
            if (this.environmentVariables == null) {
                this.environmentVariables = new LinkedHashMap<String, Object>();
            }
            this.environmentVariables.put(Objects.requireNonNull(key, "environmentVariables key"), Objects.requireNonNull(value, "environmentVariables value"));
            return this;
        }

        public final Builder environmentVariable(Map.Entry<String, ? extends Object> entry) {
            if (this.environmentVariables == null) {
                this.environmentVariables = new LinkedHashMap<String, Object>();
            }
            String k = entry.getKey();
            Object v = entry.getValue();
            this.environmentVariables.put(Objects.requireNonNull(k, "environmentVariables key"), Objects.requireNonNull(v, "environmentVariables value"));
            return this;
        }

        public final Builder environmentVariables(@Nullable Map<String, ? extends Object> environmentVariables) {
            if (environmentVariables == null) {
                this.environmentVariables = null;
                return this;
            }
            this.environmentVariables = new LinkedHashMap<String, Object>();
            return this.putAllEnvironmentVariables(environmentVariables);
        }

        public final Builder putAllEnvironmentVariables(Map<String, ? extends Object> environmentVariables) {
            if (this.environmentVariables == null) {
                this.environmentVariables = new LinkedHashMap<String, Object>();
            }
            for (Map.Entry<String, ? extends Object> entry : environmentVariables.entrySet()) {
                String k = entry.getKey();
                Object v = entry.getValue();
                this.environmentVariables.put(Objects.requireNonNull(k, "environmentVariables key"), Objects.requireNonNull(v, "environmentVariables value"));
            }
            return this;
        }

        public final Builder lifecycle(@Nullable Lifecycle lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        public final Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        public UpdateApplicationRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new UpdateApplicationRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("applicationId");
            }
            return "Cannot build UpdateApplicationRequest, some of required attributes are not set " + attributes;
        }
    }
}

