/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.droplets;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.Map;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Lifecycle;
import org.cloudfoundry.client.v3.Link;
import org.cloudfoundry.client.v3.droplets.ExpiredResult;
import org.cloudfoundry.client.v3.droplets.FailedResult;
import org.cloudfoundry.client.v3.droplets.Result;
import org.cloudfoundry.client.v3.droplets.StagedResult;
import org.cloudfoundry.client.v3.droplets.State;
import reactor.core.Exceptions;

public abstract class Droplet {
    @JsonProperty(value="created_at")
    @Nullable
    public abstract String getCreatedAt();

    @JsonProperty(value="environment_variables")
    @Nullable
    public abstract Map<String, Object> getEnvironmentVariables();

    @JsonProperty(value="error")
    @Nullable
    public abstract String getError();

    @JsonProperty(value="guid")
    @Nullable
    public abstract String getId();

    @JsonProperty(value="lifecycle")
    @Nullable
    public abstract Lifecycle getLifecycle();

    @JsonProperty(value="links")
    @Nullable
    public abstract Map<String, Link> getLinks();

    @JsonDeserialize(using=ResultDeserializer.class)
    @JsonProperty(value="result")
    @Nullable
    public abstract Result getResult();

    @JsonProperty(value="staging_disk_in_mb")
    @Nullable
    public abstract Integer getStagingDiskInMb();

    @JsonProperty(value="staging_memory_in_mb")
    @Nullable
    public abstract Integer getStagingMemoryInMb();

    @JsonProperty(value="state")
    @Nullable
    public abstract State getState();

    @JsonProperty(value="updated_at")
    @Nullable
    public abstract String getUpdatedAt();

    public static final class ResultDeserializer
    extends StdDeserializer<Result> {
        private static final long serialVersionUID = 4299183263982676771L;

        ResultDeserializer() {
            super(Result.class);
        }

        public Result deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            State state = this.getState(p.getParsingContext().getParent().getCurrentValue());
            switch (state) {
                case EXPIRED: {
                    return (Result)p.readValueAs(ExpiredResult.class);
                }
                case FAILED: {
                    return (Result)p.readValueAs(FailedResult.class);
                }
                case STAGED: {
                    return (Result)p.readValueAs(StagedResult.class);
                }
            }
            return null;
        }

        private State getState(Object droplet) {
            try {
                return (State)((Object)droplet.getClass().getDeclaredField("state").get(droplet));
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw Exceptions.propagate((Throwable)e);
            }
        }
    }
}

