/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.droplets;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Lifecycle;
import org.cloudfoundry.client.v3.Link;
import org.cloudfoundry.client.v3.droplets.Droplet;
import org.cloudfoundry.client.v3.droplets.Result;
import org.cloudfoundry.client.v3.droplets.State;
import org.cloudfoundry.client.v3.droplets._GetDropletResponse;

public final class GetDropletResponse
extends _GetDropletResponse {
    @Nullable
    private final String createdAt;
    @Nullable
    private final Map<String, Object> environmentVariables;
    @Nullable
    private final String error;
    @Nullable
    private final String id;
    @Nullable
    private final Lifecycle lifecycle;
    @Nullable
    private final Map<String, Link> links;
    @Nullable
    private final Result result;
    @Nullable
    private final Integer stagingDiskInMb;
    @Nullable
    private final Integer stagingMemoryInMb;
    @Nullable
    private final State state;
    @Nullable
    private final String updatedAt;

    private GetDropletResponse(Builder builder) {
        this.createdAt = builder.createdAt;
        this.environmentVariables = builder.environmentVariables == null ? null : GetDropletResponse.createUnmodifiableMap(false, false, builder.environmentVariables);
        this.error = builder.error;
        this.id = builder.id;
        this.lifecycle = builder.lifecycle;
        this.links = builder.links == null ? null : GetDropletResponse.createUnmodifiableMap(false, false, builder.links);
        this.result = builder.result;
        this.stagingDiskInMb = builder.stagingDiskInMb;
        this.stagingMemoryInMb = builder.stagingMemoryInMb;
        this.state = builder.state;
        this.updatedAt = builder.updatedAt;
    }

    @Override
    @JsonProperty(value="created_at")
    @Nullable
    public String getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty(value="environment_variables")
    @Nullable
    public Map<String, Object> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    @Override
    @JsonProperty(value="error")
    @Nullable
    public String getError() {
        return this.error;
    }

    @Override
    @JsonProperty(value="guid")
    @Nullable
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="lifecycle")
    @Nullable
    public Lifecycle getLifecycle() {
        return this.lifecycle;
    }

    @Override
    @JsonProperty(value="links")
    @Nullable
    public Map<String, Link> getLinks() {
        return this.links;
    }

    @Override
    @JsonDeserialize(using=Droplet.ResultDeserializer.class)
    @JsonProperty(value="result")
    @Nullable
    public Result getResult() {
        return this.result;
    }

    @Override
    @JsonProperty(value="staging_disk_in_mb")
    @Nullable
    public Integer getStagingDiskInMb() {
        return this.stagingDiskInMb;
    }

    @Override
    @JsonProperty(value="staging_memory_in_mb")
    @Nullable
    public Integer getStagingMemoryInMb() {
        return this.stagingMemoryInMb;
    }

    @Override
    @JsonProperty(value="state")
    @Nullable
    public State getState() {
        return this.state;
    }

    @Override
    @JsonProperty(value="updated_at")
    @Nullable
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GetDropletResponse && this.equalTo((GetDropletResponse)another);
    }

    private boolean equalTo(GetDropletResponse another) {
        return Objects.equals(this.createdAt, another.createdAt) && Objects.equals(this.environmentVariables, another.environmentVariables) && Objects.equals(this.error, another.error) && Objects.equals(this.id, another.id) && Objects.equals(this.lifecycle, another.lifecycle) && Objects.equals(this.links, another.links) && Objects.equals(this.result, another.result) && Objects.equals(this.stagingDiskInMb, another.stagingDiskInMb) && Objects.equals(this.stagingMemoryInMb, another.stagingMemoryInMb) && Objects.equals((Object)this.state, (Object)another.state) && Objects.equals(this.updatedAt, another.updatedAt);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.createdAt);
        h = h * 17 + Objects.hashCode(this.environmentVariables);
        h = h * 17 + Objects.hashCode(this.error);
        h = h * 17 + Objects.hashCode(this.id);
        h = h * 17 + Objects.hashCode(this.lifecycle);
        h = h * 17 + Objects.hashCode(this.links);
        h = h * 17 + Objects.hashCode(this.result);
        h = h * 17 + Objects.hashCode(this.stagingDiskInMb);
        h = h * 17 + Objects.hashCode(this.stagingMemoryInMb);
        h = h * 17 + Objects.hashCode((Object)this.state);
        h = h * 17 + Objects.hashCode(this.updatedAt);
        return h;
    }

    public String toString() {
        return "GetDropletResponse{createdAt=" + this.createdAt + ", environmentVariables=" + this.environmentVariables + ", error=" + this.error + ", id=" + this.id + ", lifecycle=" + this.lifecycle + ", links=" + this.links + ", result=" + this.result + ", stagingDiskInMb=" + this.stagingDiskInMb + ", stagingMemoryInMb=" + this.stagingMemoryInMb + ", state=" + (Object)((Object)this.state) + ", updatedAt=" + this.updatedAt + "}";
    }

    @Deprecated
    @JsonCreator
    static GetDropletResponse fromJson(Json json) {
        Builder builder = GetDropletResponse.builder();
        if (json.createdAt != null) {
            builder.createdAt(json.createdAt);
        }
        if (json.environmentVariables != null) {
            builder.putAllEnvironmentVariables(json.environmentVariables);
        }
        if (json.error != null) {
            builder.error(json.error);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.lifecycle != null) {
            builder.lifecycle(json.lifecycle);
        }
        if (json.links != null) {
            builder.putAllLinks(json.links);
        }
        if (json.result != null) {
            builder.result(json.result);
        }
        if (json.stagingDiskInMb != null) {
            builder.stagingDiskInMb(json.stagingDiskInMb);
        }
        if (json.stagingMemoryInMb != null) {
            builder.stagingMemoryInMb(json.stagingMemoryInMb);
        }
        if (json.state != null) {
            builder.state(json.state);
        }
        if (json.updatedAt != null) {
            builder.updatedAt(json.updatedAt);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    public static final class Builder {
        private String createdAt;
        private Map<String, Object> environmentVariables = null;
        private String error;
        private String id;
        private Lifecycle lifecycle;
        private Map<String, Link> links = null;
        private Result result;
        private Integer stagingDiskInMb;
        private Integer stagingMemoryInMb;
        private State state;
        private String updatedAt;

        private Builder() {
        }

        public final Builder from(Droplet instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GetDropletResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        final Builder from(_GetDropletResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            if (object instanceof Droplet) {
                String updatedAtValue;
                String errorValue;
                State stateValue;
                String idValue;
                Integer stagingMemoryInMbValue;
                Map<String, Link> linksValue;
                Integer stagingDiskInMbValue;
                Map<String, Object> environmentVariablesValue;
                String createdAtValue;
                Result resultValue;
                Droplet instance = (Droplet)object;
                Lifecycle lifecycleValue = instance.getLifecycle();
                if (lifecycleValue != null) {
                    this.lifecycle(lifecycleValue);
                }
                if ((resultValue = instance.getResult()) != null) {
                    this.result(resultValue);
                }
                if ((createdAtValue = instance.getCreatedAt()) != null) {
                    this.createdAt(createdAtValue);
                }
                if ((environmentVariablesValue = instance.getEnvironmentVariables()) != null) {
                    this.putAllEnvironmentVariables(environmentVariablesValue);
                }
                if ((stagingDiskInMbValue = instance.getStagingDiskInMb()) != null) {
                    this.stagingDiskInMb(stagingDiskInMbValue);
                }
                if ((linksValue = instance.getLinks()) != null) {
                    this.putAllLinks(linksValue);
                }
                if ((stagingMemoryInMbValue = instance.getStagingMemoryInMb()) != null) {
                    this.stagingMemoryInMb(stagingMemoryInMbValue);
                }
                if ((idValue = instance.getId()) != null) {
                    this.id(idValue);
                }
                if ((stateValue = instance.getState()) != null) {
                    this.state(stateValue);
                }
                if ((errorValue = instance.getError()) != null) {
                    this.error(errorValue);
                }
                if ((updatedAtValue = instance.getUpdatedAt()) != null) {
                    this.updatedAt(updatedAtValue);
                }
            }
        }

        public final Builder createdAt(@Nullable String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Builder environmentVariable(String key, Object value) {
            if (this.environmentVariables == null) {
                this.environmentVariables = new LinkedHashMap<String, Object>();
            }
            this.environmentVariables.put(Objects.requireNonNull(key, "environmentVariables key"), Objects.requireNonNull(value, "environmentVariables value"));
            return this;
        }

        public final Builder environmentVariable(Map.Entry<String, ? extends Object> entry) {
            if (this.environmentVariables == null) {
                this.environmentVariables = new LinkedHashMap<String, Object>();
            }
            String k = entry.getKey();
            Object v = entry.getValue();
            this.environmentVariables.put(Objects.requireNonNull(k, "environmentVariables key"), Objects.requireNonNull(v, "environmentVariables value"));
            return this;
        }

        public final Builder environmentVariables(@Nullable Map<String, ? extends Object> environmentVariables) {
            if (environmentVariables == null) {
                this.environmentVariables = null;
                return this;
            }
            this.environmentVariables = new LinkedHashMap<String, Object>();
            return this.putAllEnvironmentVariables(environmentVariables);
        }

        public final Builder putAllEnvironmentVariables(Map<String, ? extends Object> environmentVariables) {
            if (this.environmentVariables == null) {
                this.environmentVariables = new LinkedHashMap<String, Object>();
            }
            for (Map.Entry<String, ? extends Object> entry : environmentVariables.entrySet()) {
                String k = entry.getKey();
                Object v = entry.getValue();
                this.environmentVariables.put(Objects.requireNonNull(k, "environmentVariables key"), Objects.requireNonNull(v, "environmentVariables value"));
            }
            return this;
        }

        public final Builder error(@Nullable String error) {
            this.error = error;
            return this;
        }

        public final Builder id(@Nullable String id) {
            this.id = id;
            return this;
        }

        public final Builder lifecycle(@Nullable Lifecycle lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        public final Builder link(String key, Link value) {
            if (this.links == null) {
                this.links = new LinkedHashMap<String, Link>();
            }
            this.links.put(Objects.requireNonNull(key, "links key"), Objects.requireNonNull(value, "links value"));
            return this;
        }

        public final Builder link(Map.Entry<String, ? extends Link> entry) {
            if (this.links == null) {
                this.links = new LinkedHashMap<String, Link>();
            }
            String k = entry.getKey();
            Link v = entry.getValue();
            this.links.put(Objects.requireNonNull(k, "links key"), Objects.requireNonNull(v, "links value"));
            return this;
        }

        public final Builder links(@Nullable Map<String, ? extends Link> links) {
            if (links == null) {
                this.links = null;
                return this;
            }
            this.links = new LinkedHashMap<String, Link>();
            return this.putAllLinks(links);
        }

        public final Builder putAllLinks(Map<String, ? extends Link> links) {
            if (this.links == null) {
                this.links = new LinkedHashMap<String, Link>();
            }
            for (Map.Entry<String, ? extends Link> entry : links.entrySet()) {
                String k = entry.getKey();
                Link v = entry.getValue();
                this.links.put(Objects.requireNonNull(k, "links key"), Objects.requireNonNull(v, "links value"));
            }
            return this;
        }

        public final Builder result(@Nullable Result result) {
            this.result = result;
            return this;
        }

        public final Builder stagingDiskInMb(@Nullable Integer stagingDiskInMb) {
            this.stagingDiskInMb = stagingDiskInMb;
            return this;
        }

        public final Builder stagingMemoryInMb(@Nullable Integer stagingMemoryInMb) {
            this.stagingMemoryInMb = stagingMemoryInMb;
            return this;
        }

        public final Builder state(@Nullable State state) {
            this.state = state;
            return this;
        }

        public final Builder updatedAt(@Nullable String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public GetDropletResponse build() {
            return new GetDropletResponse(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _GetDropletResponse {
        String createdAt;
        Map<String, Object> environmentVariables;
        String error;
        String id;
        Lifecycle lifecycle;
        Map<String, Link> links;
        Result result;
        Integer stagingDiskInMb;
        Integer stagingMemoryInMb;
        State state;
        String updatedAt;

        Json() {
        }

        @JsonProperty(value="created_at")
        public void setCreatedAt(@Nullable String createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty(value="environment_variables")
        public void setEnvironmentVariables(@Nullable Map<String, Object> environmentVariables) {
            this.environmentVariables = environmentVariables;
        }

        @JsonProperty(value="error")
        public void setError(@Nullable String error) {
            this.error = error;
        }

        @JsonProperty(value="guid")
        public void setId(@Nullable String id) {
            this.id = id;
        }

        @JsonProperty(value="lifecycle")
        public void setLifecycle(@Nullable Lifecycle lifecycle) {
            this.lifecycle = lifecycle;
        }

        @JsonProperty(value="links")
        public void setLinks(@Nullable Map<String, Link> links) {
            this.links = links;
        }

        @JsonDeserialize(using=Droplet.ResultDeserializer.class)
        @JsonProperty(value="result")
        public void setResult(@Nullable Result result) {
            this.result = result;
        }

        @JsonProperty(value="staging_disk_in_mb")
        public void setStagingDiskInMb(@Nullable Integer stagingDiskInMb) {
            this.stagingDiskInMb = stagingDiskInMb;
        }

        @JsonProperty(value="staging_memory_in_mb")
        public void setStagingMemoryInMb(@Nullable Integer stagingMemoryInMb) {
            this.stagingMemoryInMb = stagingMemoryInMb;
        }

        @JsonProperty(value="state")
        public void setState(@Nullable State state) {
            this.state = state;
        }

        @JsonProperty(value="updated_at")
        public void setUpdatedAt(@Nullable String updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public String getCreatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Object> getEnvironmentVariables() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getError() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Lifecycle getLifecycle() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Link> getLinks() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Result getResult() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getStagingDiskInMb() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getStagingMemoryInMb() {
            throw new UnsupportedOperationException();
        }

        @Override
        public State getState() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUpdatedAt() {
            throw new UnsupportedOperationException();
        }
    }
}

