/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.droplets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.PaginatedAndSortedRequest;
import org.cloudfoundry.client.v3.PaginatedRequest;
import org.cloudfoundry.client.v3.droplets._ListDropletsRequest;

public final class ListDropletsRequest
extends _ListDropletsRequest {
    private final List<String> applicationIds;
    private final List<String> states;
    @Nullable
    private final String orderBy;
    @Nullable
    private final Integer page;
    @Nullable
    private final Integer perPage;

    private ListDropletsRequest(Builder builder) {
        this.applicationIds = ListDropletsRequest.createUnmodifiableList(true, builder.applicationIds);
        this.states = ListDropletsRequest.createUnmodifiableList(true, builder.states);
        this.orderBy = builder.orderBy;
        this.page = builder.page;
        this.perPage = builder.perPage;
    }

    @Override
    public List<String> getApplicationIds() {
        return this.applicationIds;
    }

    @Override
    public List<String> getStates() {
        return this.states;
    }

    @Override
    @Nullable
    public String getOrderBy() {
        return this.orderBy;
    }

    @Override
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @Override
    @Nullable
    public Integer getPerPage() {
        return this.perPage;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListDropletsRequest && this.equalTo((ListDropletsRequest)another);
    }

    private boolean equalTo(ListDropletsRequest another) {
        return this.applicationIds.equals(another.applicationIds) && this.states.equals(another.states) && Objects.equals(this.orderBy, another.orderBy) && Objects.equals(this.page, another.page) && Objects.equals(this.perPage, another.perPage);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.applicationIds.hashCode();
        h = h * 17 + this.states.hashCode();
        h = h * 17 + Objects.hashCode(this.orderBy);
        h = h * 17 + Objects.hashCode(this.page);
        h = h * 17 + Objects.hashCode(this.perPage);
        return h;
    }

    public String toString() {
        return "ListDropletsRequest{applicationIds=" + this.applicationIds + ", states=" + this.states + ", orderBy=" + this.orderBy + ", page=" + this.page + ", perPage=" + this.perPage + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private List<String> applicationIds = new ArrayList<String>();
        private List<String> states = new ArrayList<String>();
        private String orderBy;
        private Integer page;
        private Integer perPage;

        private Builder() {
        }

        public final Builder from(ListDropletsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        final Builder from(_ListDropletsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PaginatedRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PaginatedAndSortedRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            String orderByValue;
            PaginatedRequest instance;
            if (object instanceof _ListDropletsRequest) {
                instance = (_ListDropletsRequest)object;
                this.addAllApplicationIds(((_ListDropletsRequest)instance).getApplicationIds());
                this.addAllStates(((_ListDropletsRequest)instance).getStates());
            }
            if (object instanceof PaginatedRequest) {
                Integer pageValue;
                instance = (PaginatedRequest)object;
                Integer perPageValue = instance.getPerPage();
                if (perPageValue != null) {
                    this.perPage(perPageValue);
                }
                if ((pageValue = instance.getPage()) != null) {
                    this.page(pageValue);
                }
            }
            if (object instanceof PaginatedAndSortedRequest && (orderByValue = ((PaginatedAndSortedRequest)(instance = (PaginatedAndSortedRequest)object)).getOrderBy()) != null) {
                this.orderBy(orderByValue);
            }
        }

        public final Builder applicationId(String element) {
            this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
            return this;
        }

        public final Builder applicationId(String ... elements) {
            for (String element : elements) {
                this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
            }
            return this;
        }

        public final Builder applicationIds(Iterable<String> elements) {
            this.applicationIds.clear();
            return this.addAllApplicationIds(elements);
        }

        public final Builder addAllApplicationIds(Iterable<String> elements) {
            for (String element : elements) {
                this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
            }
            return this;
        }

        public final Builder state(String element) {
            this.states.add(Objects.requireNonNull(element, "states element"));
            return this;
        }

        public final Builder state(String ... elements) {
            for (String element : elements) {
                this.states.add(Objects.requireNonNull(element, "states element"));
            }
            return this;
        }

        public final Builder states(Iterable<String> elements) {
            this.states.clear();
            return this.addAllStates(elements);
        }

        public final Builder addAllStates(Iterable<String> elements) {
            for (String element : elements) {
                this.states.add(Objects.requireNonNull(element, "states element"));
            }
            return this;
        }

        public final Builder orderBy(@Nullable String orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        public final Builder page(@Nullable Integer page) {
            this.page = page;
            return this;
        }

        public final Builder perPage(@Nullable Integer perPage) {
            this.perPage = perPage;
            return this;
        }

        public ListDropletsRequest build() {
            return new ListDropletsRequest(this);
        }
    }
}

