/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.droplets;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Hash;
import org.cloudfoundry.client.v3.droplets._StagedResult;

public final class StagedResult
extends _StagedResult {
    @Nullable
    private final String buildpack;
    @Nullable
    private final String executionMetadata;
    @Nullable
    private final Hash hash;
    @Nullable
    private final Map<String, String> processTypes;
    @Nullable
    private final String stack;

    private StagedResult(Builder builder) {
        this.buildpack = builder.buildpack;
        this.executionMetadata = builder.executionMetadata;
        this.hash = builder.hash;
        this.processTypes = builder.processTypes == null ? null : StagedResult.createUnmodifiableMap(false, false, builder.processTypes);
        this.stack = builder.stack;
    }

    @Override
    @JsonProperty(value="buildpack")
    @Nullable
    public String getBuildpack() {
        return this.buildpack;
    }

    @Override
    @JsonProperty(value="execution_metadata")
    @Nullable
    public String getExecutionMetadata() {
        return this.executionMetadata;
    }

    @Override
    @JsonProperty(value="hash")
    @Nullable
    public Hash getHash() {
        return this.hash;
    }

    @Override
    @JsonProperty(value="process_types")
    @Nullable
    public Map<String, String> getProcessTypes() {
        return this.processTypes;
    }

    @Override
    @JsonProperty(value="stack")
    @Nullable
    public String getStack() {
        return this.stack;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof StagedResult && this.equalTo((StagedResult)another);
    }

    private boolean equalTo(StagedResult another) {
        return Objects.equals(this.buildpack, another.buildpack) && Objects.equals(this.executionMetadata, another.executionMetadata) && Objects.equals(this.hash, another.hash) && Objects.equals(this.processTypes, another.processTypes) && Objects.equals(this.stack, another.stack);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.buildpack);
        h = h * 17 + Objects.hashCode(this.executionMetadata);
        h = h * 17 + Objects.hashCode(this.hash);
        h = h * 17 + Objects.hashCode(this.processTypes);
        h = h * 17 + Objects.hashCode(this.stack);
        return h;
    }

    public String toString() {
        return "StagedResult{buildpack=" + this.buildpack + ", executionMetadata=" + this.executionMetadata + ", hash=" + this.hash + ", processTypes=" + this.processTypes + ", stack=" + this.stack + "}";
    }

    @Deprecated
    @JsonCreator
    static StagedResult fromJson(Json json) {
        Builder builder = StagedResult.builder();
        if (json.buildpack != null) {
            builder.buildpack(json.buildpack);
        }
        if (json.executionMetadata != null) {
            builder.executionMetadata(json.executionMetadata);
        }
        if (json.hash != null) {
            builder.hash(json.hash);
        }
        if (json.processTypes != null) {
            builder.putAllProcessTypes(json.processTypes);
        }
        if (json.stack != null) {
            builder.stack(json.stack);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    public static final class Builder {
        private String buildpack;
        private String executionMetadata;
        private Hash hash;
        private Map<String, String> processTypes = null;
        private String stack;

        private Builder() {
        }

        public final Builder from(StagedResult instance) {
            return this.from((_StagedResult)instance);
        }

        final Builder from(_StagedResult instance) {
            String stackValue;
            Map<String, String> processTypesValue;
            Hash hashValue;
            String executionMetadataValue;
            Objects.requireNonNull(instance, "instance");
            String buildpackValue = instance.getBuildpack();
            if (buildpackValue != null) {
                this.buildpack(buildpackValue);
            }
            if ((executionMetadataValue = instance.getExecutionMetadata()) != null) {
                this.executionMetadata(executionMetadataValue);
            }
            if ((hashValue = instance.getHash()) != null) {
                this.hash(hashValue);
            }
            if ((processTypesValue = instance.getProcessTypes()) != null) {
                this.putAllProcessTypes(processTypesValue);
            }
            if ((stackValue = instance.getStack()) != null) {
                this.stack(stackValue);
            }
            return this;
        }

        public final Builder buildpack(@Nullable String buildpack) {
            this.buildpack = buildpack;
            return this;
        }

        public final Builder executionMetadata(@Nullable String executionMetadata) {
            this.executionMetadata = executionMetadata;
            return this;
        }

        public final Builder hash(@Nullable Hash hash) {
            this.hash = hash;
            return this;
        }

        public final Builder processType(String key, String value) {
            if (this.processTypes == null) {
                this.processTypes = new LinkedHashMap<String, String>();
            }
            this.processTypes.put(Objects.requireNonNull(key, "processTypes key"), Objects.requireNonNull(value, "processTypes value"));
            return this;
        }

        public final Builder processType(Map.Entry<String, ? extends String> entry) {
            if (this.processTypes == null) {
                this.processTypes = new LinkedHashMap<String, String>();
            }
            String k = entry.getKey();
            String v = entry.getValue();
            this.processTypes.put(Objects.requireNonNull(k, "processTypes key"), Objects.requireNonNull(v, "processTypes value"));
            return this;
        }

        public final Builder processTypes(@Nullable Map<String, ? extends String> processTypes) {
            if (processTypes == null) {
                this.processTypes = null;
                return this;
            }
            this.processTypes = new LinkedHashMap<String, String>();
            return this.putAllProcessTypes(processTypes);
        }

        public final Builder putAllProcessTypes(Map<String, ? extends String> processTypes) {
            if (this.processTypes == null) {
                this.processTypes = new LinkedHashMap<String, String>();
            }
            for (Map.Entry<String, ? extends String> entry : processTypes.entrySet()) {
                String k = entry.getKey();
                String v = entry.getValue();
                this.processTypes.put(Objects.requireNonNull(k, "processTypes key"), Objects.requireNonNull(v, "processTypes value"));
            }
            return this;
        }

        public final Builder stack(@Nullable String stack) {
            this.stack = stack;
            return this;
        }

        public StagedResult build() {
            return new StagedResult(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _StagedResult {
        String buildpack;
        String executionMetadata;
        Hash hash;
        Map<String, String> processTypes;
        String stack;

        Json() {
        }

        @JsonProperty(value="buildpack")
        public void setBuildpack(@Nullable String buildpack) {
            this.buildpack = buildpack;
        }

        @JsonProperty(value="execution_metadata")
        public void setExecutionMetadata(@Nullable String executionMetadata) {
            this.executionMetadata = executionMetadata;
        }

        @JsonProperty(value="hash")
        public void setHash(@Nullable Hash hash) {
            this.hash = hash;
        }

        @JsonProperty(value="process_types")
        public void setProcessTypes(@Nullable Map<String, String> processTypes) {
            this.processTypes = processTypes;
        }

        @JsonProperty(value="stack")
        public void setStack(@Nullable String stack) {
            this.stack = stack;
        }

        @Override
        public String getBuildpack() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getExecutionMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Hash getHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> getProcessTypes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getStack() {
            throw new UnsupportedOperationException();
        }
    }
}

